/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import org.zkoss.poi.xssf.usermodel.XSSFName;
import org.zkoss.poi.xssf.usermodel.XSSFTable;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;

public final class XSSFTableName {
    private XSSFWorkbook _workbook;
    private XSSFTable _table;

    protected XSSFTableName(XSSFTable table, XSSFWorkbook workbook) {
        this._workbook = workbook;
        this._table = table;
    }

    public XSSFTable getTable() {
        return this._table;
    }

    public String getTableNameName() {
        return this._table.getName();
    }

    public void setTableNameName(String name) {
        XSSFTableName.validateName(name);
        if (this._workbook.getTableName(name.toUpperCase()) != null) {
            String msg = "The workbook already contains this name: " + name;
            throw new IllegalArgumentException(msg);
        }
        int sheetIndex = -1;
        for (int i = 0; i < this._workbook.getNumberOfNames(); ++i) {
            XSSFName nm = this._workbook.getNameAt(i);
            if (!name.equalsIgnoreCase(nm.getNameName()) || sheetIndex != nm.getSheetIndex()) continue;
            String msg = "The " + (sheetIndex == -1 ? "workbook" : "sheet") + " already contains this name: " + name;
            throw new IllegalArgumentException(msg);
        }
        String oldName = this.getTableNameName();
        this._workbook.renameTableName(oldName, name);
    }

    public int hashCode() {
        return this._table.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSSFTableName)) {
            return false;
        }
        XSSFTableName cf = (XSSFTableName)o;
        return this._table.getName().equals(cf._table.getName());
    }

    private static void validateName(String name) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        char c = name.charAt(0);
        if (c != '_' && !Character.isLetter(c) || name.indexOf(32) != -1) {
            throw new IllegalArgumentException("Invalid name: '" + name + "'; Names must begin with a letter or underscore and not contain spaces");
        }
    }
}

