/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractProtectedHandler;
import io.keikai.ui.impl.undo.InsertCellAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;

public class InsertCellRightHandler
extends AbstractProtectedHandler {
    private static final long serialVersionUID = 3969443679620461004L;

    @Override
    protected boolean processAction(UserActionContext ctx) {
        AreaRef selection;
        Sheet sheet = ctx.getSheet();
        Range range = Ranges.range(sheet, selection = ctx.getSelection());
        if (this.checkInCornerFreezePanel(range)) {
            throw new IllegalOpArgumentException(Labels.getLabel((String)"zss.msg.operation_not_supported_with_freeze_panel"));
        }
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction(new InsertCellAction(Labels.getLabel((String)"zss.undo.shiftCell"), sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), Range.InsertShift.RIGHT, Range.InsertCopyOrigin.FORMAT_LEFT_ABOVE));
        ctx.clearClipboard();
        return true;
    }
}

