/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.model.impl;

import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.ModelRef;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.SBook;
import io.keikai.model.SSheet;
import io.keikai.range.impl.imexp.AbstractExcelImporter;
import java.io.Serializable;
import java.util.concurrent.locks.ReadWriteLock;

public class BookImpl
implements Book,
Serializable {
    private static final long serialVersionUID = -9005486925669208704L;
    private ModelRef<SBook> _bookRef;
    private Book.BookType _type;

    public BookImpl(ModelRef<SBook> ref) {
        this._bookRef = ref;
        SBook book = ref.get();
        String bookType = AbstractExcelImporter.getBookType((SBook)book);
        this._type = "xls".equalsIgnoreCase(bookType) ? Book.BookType.XLS : Book.BookType.XLSX;
    }

    public SBook getNative() {
        return this._bookRef.get();
    }

    @Override
    public SBook getInternalBook() {
        return this._bookRef.get();
    }

    public ModelRef<SBook> getRef() {
        return this._bookRef;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._bookRef == null ? 0 : this._bookRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BookImpl other = (BookImpl)obj;
        return !(this._bookRef == null ? other._bookRef != null : !this._bookRef.equals(other._bookRef));
    }

    @Override
    public String getBookName() {
        return this.getNative().getBookName();
    }

    @Override
    public Book.BookType getType() {
        return this._type;
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        if (sheet == null) {
            return -1;
        }
        return this.getNative().getSheetIndex(((SheetImpl)sheet).getNative());
    }

    @Override
    public int getNumberOfSheets() {
        return this.getNative().getNumOfSheet();
    }

    @Override
    public SheetImpl getSheetAt(int index) {
        SSheet sheet = this.getNative().getSheet(index);
        return new SheetImpl(this._bookRef, new SimpleRef<SSheet>(sheet));
    }

    @Override
    public SheetImpl getSheet(String name) {
        SSheet sheet = this.getNative().getSheetByName(name);
        return sheet == null ? null : new SheetImpl(this._bookRef, new SimpleRef<SSheet>(sheet));
    }

    @Override
    public void setShareScope(String scope) {
        this.getNative().setShareScope(scope);
    }

    @Override
    public String getShareScope() {
        return this.getNative().getShareScope();
    }

    @Override
    @Deprecated
    public Object getSync() {
        return this.getNative();
    }

    @Override
    public boolean hasNameRange(String name) {
        return this.getNative().getNameByName(name) != null;
    }

    @Override
    public int getMaxRows() {
        return this.getNative().getMaxRowSize();
    }

    @Override
    public int getMaxColumns() {
        return this.getNative().getMaxColumnSize();
    }

    @Override
    public ReadWriteLock getLock() {
        return this.getNative().getBookSeries().getLock();
    }
}

