


zss.FocusMarkCtrl = zk.$extends(zk.Object, {
	$init: function (sheet, cmp, pos) {
		this.$supers('$init', arguments);
		this.id = cmp.id;
		this.comp = cmp;
		var local = this;
		
		this.sheet = sheet;
		this.row = pos.row;
		this.column = pos.column;
		
		cmp.ctrl = this;
		jq(cmp).bind('mouseenter', this.proxy(this._doMouseEnter));
		jq(cmp).bind('mouseleave', this.proxy(this._doMouseLeave));
	},
	cleanup: function () {
		this.invalid = true;
		if (this.comp) {
			jq(this.comp).unbind('mouseenter', this.proxy(this._doMouseEnter));
			jq(this.comp).unbind('mouseleave', this.proxy(this._doMouseLeave));
			this.comp.ctrl = null;
			this.comp = null;
		}
		this.sheet =  null;
	},
	
	relocate: function (row, col) {
		var sheet = this.sheet;
		this.row = row;
		this.column = col;
		var cell = sheet.getCell(row, col),
			mr = cell && cell.merr ? cell.merr : col,
			mb = cell && cell.merb ? cell.merb : row,
			custColWidth = sheet.custColWidth,
			custRowHeight = sheet.custRowHeight,
			l = custColWidth.getStartPixel(col),
			t = custRowHeight.getStartPixel(row),
			w = custColWidth.getStartPixel(mr + 1) - l,
			h = custRowHeight.getStartPixel(mb + 1) - t;
		
		this.relocate_(l, t, w, h);
	},
	
	relocate_: function(l, t, w, h) {
		var sheet = this.sheet,
			dp = sheet.dp;
		
		l += sheet.leftWidth;
		t += sheet.topHeight + 1;
		jq(this.comp).css({'width': jq.px0(w + 3), 'height': jq.px0(h + 3), 'left': jq.px(l - 2), 'top': jq.px(t - 2)});
	},
	
	showMark: function (color, label) {
		this.comp.style.display = "block";
		var bright = 0;
		var comp = jq(this.comp);
		if(color){
			comp.css({'border-color':color});
			var rgb = comp.css('border-color');
			var rgbarr = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
			if(!rgbarr || rgbarr.length!=4){
				rgbarr = rgb.match(/^rgba\((\d+),\s*(\d+),\s*(\d+),\s*(\d+)\)$/);
			}
			if(rgbarr && rgbarr.length>=4){
				bright = 1 - (0.299*rgbarr[1]+0.587*rgbarr[2]+0.114*rgbarr[3])/255;
			}
		}
		
		this.color = color;
		this.label = label;
		this.bright = bright;
	},
	
	hideMark: function () {
		this.comp.style.display = "none";
	},
	_doMouseEnter: function (evt) {
		var color = this.color,
			label = this.label,
			sheet = this.sheet;
		if (!sheet || !sheet._wgt.hasFocus()) {
			return;
		}
		if (color && label) {
			var $comp = jq(this.comp),
				$lab = jq("<span class='zsfocmarkl'/>");
			this.lab = $lab;
			$lab.text(label).css({'background-color':color,'left':$comp.width() + 1}).appendTo($comp);
			if (this.bright > 0.5) {
				$lab.addClass('zsfocmarkl-lite');
				$lab.removeClass('zsfocmarkl-dark');
			} else {
				$lab.addClass('zsfocmarkl-dark');
				$lab.removeClass('zsfocmarkl-lite');
			}
		}
	},
	_doMouseLeave: function (evt) {
		if (this.lab) {
			this.lab.detach();
			this.lab = null;
		}
	}
});


zss.FocusMarkCtrlCorner = zk.$extends(zss.FocusMarkCtrl, {});


zss.FocusMarkCtrlLeft = zk.$extends(zss.FocusMarkCtrl, {
	
 	relocate_: function (l, t, w, h) {
		var sheet = this.sheet;
		l += sheet.leftWidth - 1;
		if (sheet.lp.toppad) {
			t -= sheet.lp.toppad;
		}
		jq(this.comp).css({'width': jq.px0(w + 3), 'height': jq.px0(h + 3), 'left': jq.px(l - 2), 'top': jq.px(t - 2)});
	}
});


zss.FocusMarkCtrlTop = zk.$extends(zss.FocusMarkCtrl, {
	
  	relocate_: function(l, t, w, h) {
		var sheet = this.sheet;
		t += sheet.topHeight;
		jq(this.comp).css({'width': jq.px0(w + 3), 'height': jq.px0(h + 3), 'left': jq.px(l - 2),'top': jq.px(t - 2)});
	}
});