/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedName;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationName;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.FormulaParser;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.functions.FreeRefFunction;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.TablePtg;
import org.zkoss.poi.ss.formula.udf.UDFFinder;
import org.zkoss.poi.xssf.model.IndexedUDFFinder;
import org.zkoss.poi.xssf.usermodel.XSSFCell;
import org.zkoss.poi.xssf.usermodel.XSSFEvaluationCell;
import org.zkoss.poi.xssf.usermodel.XSSFEvaluationSheet;
import org.zkoss.poi.xssf.usermodel.XSSFName;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFTable;
import org.zkoss.poi.xssf.usermodel.XSSFTableName;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;

public final class XSSFEvaluationWorkbook
implements FormulaRenderingWorkbook,
EvaluationWorkbook,
FormulaParsingWorkbook {
    private final XSSFWorkbook _uBook;

    public static XSSFEvaluationWorkbook create(XSSFWorkbook book) {
        if (book == null) {
            return null;
        }
        return new XSSFEvaluationWorkbook(book);
    }

    private XSSFEvaluationWorkbook(XSSFWorkbook book) {
        this._uBook = book;
    }

    @Override
    public int convertFromExternSheetIndex(int externSheetIndex) {
        String[] names = this._uBook.convertFromExternSheetIndex(externSheetIndex);
        if (names == null) {
            return -1;
        }
        return this.getSheetIndex(names[1]);
    }

    @Override
    public int convertLastIndexFromExternSheetIndex(int externSheetIndex) {
        String[] names = this._uBook.convertFromExternSheetIndex(externSheetIndex);
        if (names == null) {
            return -1;
        }
        return this.getSheetIndex(names[2]);
    }

    @Override
    public int getExternalSheetIndex(String sheetName) {
        int j = sheetName.indexOf(58);
        String sheetName1 = j < 0 ? sheetName : sheetName.substring(0, j);
        String sheetName2 = j < 0 ? sheetName : sheetName.substring(j + 1);
        return this._uBook.getOrCreateExternalSheetIndex(null, sheetName1, sheetName2);
    }

    @Override
    public EvaluationName getName(String name, int sheetIndex) {
        for (int i = 0; i < this._uBook.getNumberOfNames(); ++i) {
            XSSFName nm = this._uBook.getNameAt(i);
            String nameText = nm.getNameName();
            if (!name.equalsIgnoreCase(nameText) || nm.getSheetIndex() != sheetIndex) continue;
            return new Name(this._uBook.getNameAt(i), i, this);
        }
        return sheetIndex == -1 ? null : this.getName(name, -1);
    }

    @Override
    public int getSheetIndex(EvaluationSheet evalSheet) {
        XSSFSheet sheet = ((XSSFEvaluationSheet)evalSheet).getXSSFSheet();
        return this._uBook.getSheetIndex(sheet);
    }

    @Override
    public String getSheetName(int sheetIndex) {
        return this._uBook.getSheetName(sheetIndex);
    }

    @Override
    public EvaluationWorkbook.ExternalName getExternalName(int externSheetIndex, int externNameIndex) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public NameXPtg getNameXPtg(String name) {
        IndexedUDFFinder udfFinder = (IndexedUDFFinder)this.getUDFFinder();
        FreeRefFunction func = udfFinder.findFunction(name);
        if (func == null) {
            return null;
        }
        return new NameXPtg(0, udfFinder.getFunctionIndex(name));
    }

    @Override
    public String resolveNameXText(NameXPtg n) {
        int idx = n.getNameIndex();
        IndexedUDFFinder udfFinder = (IndexedUDFFinder)this.getUDFFinder();
        return udfFinder.getFunctionName(idx);
    }

    @Override
    public EvaluationSheet getSheet(int sheetIndex) {
        return new XSSFEvaluationSheet(this._uBook.getSheetAt(sheetIndex));
    }

    @Override
    public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
        String[] names = this._uBook.convertFromExternSheetIndex(externSheetIndex);
        if (names != null && names[0] != null) {
            return new EvaluationWorkbook.ExternalSheet(names[0], names[1], names[2]);
        }
        return null;
    }

    @Override
    public int getExternalSheetIndex(String workbookName, String sheetName) {
        int j = sheetName.indexOf(58);
        String sheetName1 = j < 0 ? sheetName : sheetName.substring(0, j);
        String sheetName2 = j < 0 ? sheetName : sheetName.substring(j + 1);
        return this._uBook.getOrCreateExternalSheetIndex(workbookName, sheetName1, sheetName2);
    }

    @Override
    public int getSheetIndex(String sheetName) {
        return this._uBook.getSheetIndex(sheetName);
    }

    @Override
    public String getSheetNameByExternSheet(int externSheetIndex) {
        String[] names = this._uBook.convertFromExternSheetIndex(externSheetIndex);
        return names == null ? "" : (names[1].equals(names[2]) ? names[1] : names[1] + ':' + names[2]);
    }

    @Override
    public String getNameText(NamePtg namePtg) {
        return this._uBook.getNameAt(namePtg.getIndex()).getNameName();
    }

    @Override
    public EvaluationName getName(NamePtg namePtg) {
        int ix = namePtg.getIndex();
        return new Name(this._uBook.getNameAt(ix), ix, this);
    }

    @Override
    public EvaluationName getName(NamePtg namePtg, int contextSheetIndex) {
        return this.getName(namePtg);
    }

    @Override
    public Ptg[] getFormulaTokens(EvaluationCell evalCell) {
        XSSFCell cell = ((XSSFEvaluationCell)evalCell).getXSSFCell();
        XSSFEvaluationWorkbook frBook = XSSFEvaluationWorkbook.create(this._uBook);
        return FormulaParser.parse(cell.getCellFormula(), frBook, 0, this._uBook.getSheetIndex(cell.getSheet()));
    }

    @Override
    public UDFFinder getUDFFinder() {
        return this._uBook.getUDFFinder();
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    @Override
    public String getBookNameFromExternalLinkIndex(String externalLinkIndex) {
        return this._uBook.getBookNameFromExternalLinkIndex(externalLinkIndex);
    }

    @Override
    public EvaluationName getOrCreateName(String name, int sheetIndex) {
        for (int i = 0; i < this._uBook.getNumberOfNames(); ++i) {
            XSSFName nm = this._uBook.getNameAt(i);
            String nameText = nm.getNameName();
            if (!name.equalsIgnoreCase(nameText) || nm.getSheetIndex() != sheetIndex) continue;
            return new Name(this._uBook.getNameAt(i), i, this);
        }
        if (sheetIndex == -1) {
            XSSFName nm = this._uBook.createName();
            nm.setNameName(name);
            return new Name(nm, this._uBook.getNumberOfNames() - 1, this);
        }
        return this.getOrCreateName(name, -1);
    }

    @Override
    public Ptg[] getFormulaTokens(int sheetIndex, String formula) {
        XSSFEvaluationWorkbook frBook = XSSFEvaluationWorkbook.create(this._uBook);
        return FormulaParser.parse(formula, frBook, 0, sheetIndex);
    }

    @Override
    public String getExternalLinkIndexFromBookName(String bookname) {
        return this._uBook.getExternalLinkIndexFromBookName(bookname);
    }

    @Override
    public boolean isAllowedDeferredNamePtg() {
        return true;
    }

    @Override
    public EvaluationName getName(String name, String sheetName) {
        int sheetIndex = this._uBook.getSheetIndex(sheetName);
        return this.getName(name, sheetIndex);
    }

    @Override
    public String getFullNameText(NamePtg namePtg) {
        int sheetIndex = this._uBook.getNameAt(namePtg.getIndex()).getSheetIndex();
        String sheetName = sheetIndex < 0 ? null : this.getSheetName(sheetIndex);
        return (sheetName == null ? "" : sheetName + '!') + this.getNameText(namePtg);
    }

    @Override
    public TablePtg createTablePtg(String tableName, Object[] specifiers, int sheetIndex, int rowIdx, int colIdx) {
        String[] stringArray;
        TablePtg.Item[] itemArray;
        if (specifiers.length > 3) {
            throw new IllegalArgumentException("At most total 3 table specifiers: " + specifiers);
        }
        String tableName0 = tableName;
        if (tableName0 == null) {
            XSSFSheet sheet = this._uBook.getSheetAt(sheetIndex);
            XSSFTable table = sheet.getTableByRowCol(rowIdx, colIdx);
            String string = tableName0 = table == null ? null : table.getName();
        }
        if (tableName0 == null) {
            throw new IllegalArgumentException("Unknown [...] expression; expect a Table");
        }
        Enum item1 = null;
        Enum item2 = null;
        String column1 = null;
        String column2 = null;
        for (Object obj : specifiers) {
            if (obj instanceof String) {
                if (column1 == null) {
                    column1 = XSSFEvaluationWorkbook.normalize((String)obj);
                    continue;
                }
                if (column2 == null) {
                    column2 = XSSFEvaluationWorkbook.normalize((String)obj);
                    continue;
                }
                throw new IllegalArgumentException("Should not have more than 2 column specifiers: " + specifiers);
            }
            if (obj instanceof TablePtg.Item) {
                if (item1 == null) {
                    item1 = (TablePtg.Item)((Object)obj);
                    continue;
                }
                if (item2 == null) {
                    item2 = (TablePtg.Item)((Object)obj);
                    continue;
                }
                throw new IllegalArgumentException("Should not have more than 2 item specifiers: " + specifiers);
            }
            throw new IllegalArgumentException("Unknown table specifiers: " + obj);
        }
        if (item2 != null) {
            if (item2.ordinal() < item1.ordinal()) {
                Enum tmp = item1;
                item1 = item2;
                item2 = tmp;
            }
            switch (1.$SwitchMap$org$zkoss$poi$ss$formula$ptg$TablePtg$Item[item1.ordinal()]) {
                case 1: {
                    item2 = null;
                    break;
                }
                case 2: {
                    if (item2 != TablePtg.Item.HEADERS && item2 != TablePtg.Item.TOTALS && item2 != TablePtg.Item.THIS_ROW) break;
                    item2 = null;
                    break;
                }
                case 3: {
                    if (item2 != TablePtg.Item.THIS_ROW && item2 != TablePtg.Item.DATA) break;
                    item1 = item2;
                    item2 = null;
                    break;
                }
                case 4: {
                    if (item2 != TablePtg.Item.TOTALS && item2 != TablePtg.Item.THIS_ROW) break;
                    item2 = null;
                    break;
                }
                case 5: {
                    if (item2 != TablePtg.Item.THIS_ROW) break;
                    item2 = null;
                }
            }
        }
        XSSFTableName tbName = this._uBook.getTableName(tableName0);
        XSSFTable table = tbName.getTable();
        XSSFSheet tbSheet = table.getXSSFSheet();
        int extIdx = this.getExternalSheetIndex(tbSheet.getSheetName());
        if (item1 == null) {
            itemArray = new TablePtg.Item[]{};
        } else if (item2 == null) {
            TablePtg.Item[] itemArray2 = new TablePtg.Item[1];
            itemArray = itemArray2;
            itemArray2[0] = item1;
        } else {
            TablePtg.Item[] itemArray3 = new TablePtg.Item[2];
            itemArray3[0] = item1;
            itemArray = itemArray3;
            itemArray3[1] = item2;
        }
        if (column1 == null) {
            stringArray = new String[]{};
        } else if (column2 == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = column1;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = column1;
            stringArray = stringArray3;
            stringArray3[1] = column2;
        }
        return new TablePtg(extIdx, -1, -1, -1, -1, tableName0, itemArray, stringArray, tableName == null);
    }

    private static String normalize(String col) {
        int preSingle = -2;
        StringBuilder sb = new StringBuilder();
        int len = col.length();
        for (int j = 0; j < len; ++j) {
            char ch = col.charAt(j);
            if (ch == '\'') {
                if (preSingle == j - 1) {
                    sb.append(ch);
                    preSingle = -2;
                    continue;
                }
                preSingle = j;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public String getTableName(String name) {
        XSSFTableName tbName = this._uBook.getTableName(name);
        return tbName == null ? null : tbName.getTableNameName();
    }

    private static final class Name
    implements EvaluationName {
        private final XSSFName _nameRecord;
        private final int _index;
        private final FormulaParsingWorkbook _fpBook;

        public Name(XSSFName name, int index, FormulaParsingWorkbook fpBook) {
            this._nameRecord = name;
            this._index = index;
            this._fpBook = fpBook;
        }

        @Override
        public Ptg[] getNameDefinition() {
            return FormulaParser.parse(this._nameRecord.getRefersToFormula(), this._fpBook, 4, this._nameRecord.getSheetIndex());
        }

        @Override
        public String getNameText() {
            return this._nameRecord.getNameName();
        }

        @Override
        public boolean hasFormula() {
            CTDefinedName ctn = this._nameRecord.getCTName();
            String strVal = ctn.getStringValue();
            return !ctn.getFunction() && strVal != null && strVal.length() > 0;
        }

        @Override
        public boolean isFunctionName() {
            return this._nameRecord.isFunctionName();
        }

        @Override
        public boolean isRange() {
            return this.hasFormula();
        }

        @Override
        public NamePtg createPtg() {
            return new NamePtg(this._index);
        }
    }
}

