/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.aggregates;

import org.zkoss.poi.hssf.model.InternalSheet;
import org.zkoss.poi.hssf.model.RecordStream;
import org.zkoss.poi.hssf.record.EnhancedProtection;
import org.zkoss.poi.hssf.record.FeatHdrRecord;
import org.zkoss.poi.hssf.record.ObjectProtectRecord;
import org.zkoss.poi.hssf.record.PasswordRecord;
import org.zkoss.poi.hssf.record.ProtectRecord;
import org.zkoss.poi.hssf.record.Record;
import org.zkoss.poi.hssf.record.RecordFormatException;
import org.zkoss.poi.hssf.record.ScenarioProtectRecord;
import org.zkoss.poi.hssf.record.aggregates.RecordAggregate;

public final class WorksheetProtectionBlock
extends RecordAggregate {
    private ProtectRecord _protectRecord;
    private ObjectProtectRecord _objectProtectRecord;
    private ScenarioProtectRecord _scenarioProtectRecord;
    private PasswordRecord _passwordRecord;
    private InternalSheet _sheet;

    public WorksheetProtectionBlock(InternalSheet sheet) {
        this._sheet = sheet;
    }

    public static boolean isComponentRecord(int sid) {
        switch (sid) {
            case 18: 
            case 19: 
            case 99: 
            case 221: {
                return true;
            }
        }
        return false;
    }

    private boolean readARecord(RecordStream rs) {
        switch (rs.peekNextSid()) {
            case 18: {
                this.checkNotPresent(this._protectRecord);
                this._protectRecord = (ProtectRecord)rs.getNext();
                break;
            }
            case 99: {
                this.checkNotPresent(this._objectProtectRecord);
                this._objectProtectRecord = (ObjectProtectRecord)rs.getNext();
                break;
            }
            case 221: {
                this.checkNotPresent(this._scenarioProtectRecord);
                this._scenarioProtectRecord = (ScenarioProtectRecord)rs.getNext();
                break;
            }
            case 19: {
                this.checkNotPresent(this._passwordRecord);
                this._passwordRecord = (PasswordRecord)rs.getNext();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void checkNotPresent(Record rec) {
        if (rec != null) {
            throw new RecordFormatException("Duplicate PageSettingsBlock record (sid=0x" + Integer.toHexString(rec.getSid()) + ")");
        }
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        WorksheetProtectionBlock.visitIfPresent(this._protectRecord, rv);
        WorksheetProtectionBlock.visitIfPresent(this._scenarioProtectRecord, rv);
        WorksheetProtectionBlock.visitIfPresent(this._objectProtectRecord, rv);
        WorksheetProtectionBlock.visitIfPresent(this._passwordRecord, rv);
    }

    private static void visitIfPresent(Record r, RecordAggregate.RecordVisitor rv) {
        if (r != null) {
            rv.visitRecord(r);
        }
    }

    public PasswordRecord getPasswordRecord() {
        return this._passwordRecord;
    }

    public ScenarioProtectRecord getHCenter() {
        return this._scenarioProtectRecord;
    }

    public void addRecords(RecordStream rs) {
        while (this.readARecord(rs)) {
        }
    }

    private ProtectRecord getProtect() {
        if (this._protectRecord == null) {
            this._protectRecord = new ProtectRecord(false);
        }
        return this._protectRecord;
    }

    private PasswordRecord getPassword() {
        if (this._passwordRecord == null) {
            this._passwordRecord = WorksheetProtectionBlock.createPassword();
        }
        return this._passwordRecord;
    }

    public void protectSheet(String password, boolean shouldProtectObjects, boolean shouldProtectScenarios) {
        EnhancedProtection enhancedProtection;
        FeatHdrRecord enhancedProtectionRecord = this._sheet.getOrCreateEnhancedProtectionRecord();
        EnhancedProtection enhancedProtection2 = enhancedProtection = enhancedProtectionRecord == null ? null : enhancedProtectionRecord.getEnhancedProtection();
        if (password == null) {
            if (enhancedProtection != null) {
                enhancedProtection.setObjects(true);
                enhancedProtection.setScenarios(true);
            }
            this._passwordRecord = null;
            this._protectRecord = null;
            this._objectProtectRecord = null;
            this._scenarioProtectRecord = null;
            return;
        }
        ProtectRecord prec = this.getProtect();
        prec.setProtect(true);
        if (!password.isEmpty()) {
            PasswordRecord pass = this.getPassword();
            pass.setPassword(PasswordRecord.hashPassword(password));
        } else {
            this._passwordRecord = null;
        }
        if (shouldProtectObjects) {
            if (enhancedProtection == null || !enhancedProtection.isObjects()) {
                ObjectProtectRecord rec = WorksheetProtectionBlock.createObjectProtect();
                rec.setProtect(true);
                this._objectProtectRecord = rec;
            } else {
                this._objectProtectRecord = null;
            }
        }
        if (shouldProtectScenarios) {
            if (enhancedProtection == null || !enhancedProtection.isScenarios()) {
                ScenarioProtectRecord srec = WorksheetProtectionBlock.createScenarioProtect();
                srec.setProtect(true);
                this._scenarioProtectRecord = srec;
            } else {
                this._scenarioProtectRecord = null;
            }
        }
    }

    public boolean isSheetProtected() {
        return this._protectRecord != null && this._protectRecord.getProtect();
    }

    public boolean isObjectProtected() {
        return this._objectProtectRecord != null && this._objectProtectRecord.getProtect();
    }

    public boolean isScenarioProtected() {
        return this._scenarioProtectRecord != null && this._scenarioProtectRecord.getProtect();
    }

    private static ObjectProtectRecord createObjectProtect() {
        ObjectProtectRecord retval = new ObjectProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    private static ScenarioProtectRecord createScenarioProtect() {
        ScenarioProtectRecord retval = new ScenarioProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    private static PasswordRecord createPassword() {
        return new PasswordRecord(0);
    }

    public int getPasswordHash() {
        if (this._passwordRecord == null) {
            return 0;
        }
        return this._passwordRecord.getPassword();
    }

    public void setPasswordHash(short hashpass) {
        if (hashpass != 0) {
            this.getPassword().setPassword(hashpass);
        }
    }
}

