/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyleElement;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STTableStyleType;
import org.zkoss.poi.ss.usermodel.DxfCellStyle;
import org.zkoss.poi.ss.usermodel.TableStyle;
import org.zkoss.poi.xssf.model.StylesTable;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFTableStyle
implements TableStyle {
    private CTTableStyle _ctTbStyle;
    private Map<String, CTTableStyleElement> _ctTbStyleElems;
    private XSSFWorkbook _book;

    public XSSFTableStyle(int styleId, StylesTable stylesSource, XSSFWorkbook book) {
        this._ctTbStyle = stylesSource.getTableStyles().get(styleId);
        this._book = book;
        this._ctTbStyle.setPivot(false);
    }

    public XSSFTableStyle(String name, StylesTable styleSource, XSSFWorkbook book) {
        this._ctTbStyle = CTTableStyle.Factory.newInstance();
        this._book = book;
        this._ctTbStyle.setName(name);
        this._ctTbStyle.setPivot(false);
    }

    @Override
    public String getName() {
        return this._ctTbStyle.getName();
    }

    @Override
    public DxfCellStyle getDxfCellStyle(String name) {
        CTTableStyleElement elem = this._getTableStyleElem(name);
        return elem != null ? this._book.createDxfCellStyle((int)elem.getDxfId()) : null;
    }

    private CTTableStyleElement _getTableStyleElem(String name) {
        if (this._ctTbStyleElems == null) {
            this._ctTbStyleElems = new LinkedHashMap<String, CTTableStyleElement>();
            for (CTTableStyleElement tbStyleElem : this._ctTbStyle.getTableStyleElementArray()) {
                this._ctTbStyleElems.put(tbStyleElem.getType().toString(), tbStyleElem);
            }
        }
        return this._ctTbStyleElems.get(name);
    }

    @Override
    public void addTableStyleElement(int dxfId, String type, int stripeSize) {
        CTTableStyleElement elem = this.addTableStyleElement0(dxfId, type);
        if (stripeSize > 1) {
            elem.setSize((long)stripeSize);
        }
        this._ctTbStyleElems = null;
    }

    @Override
    public void addTableStyleElement(int dxfId, String type) {
        this.addTableStyleElement0(dxfId, type);
    }

    private CTTableStyleElement addTableStyleElement0(int dxfId, String type) {
        CTTableStyleElement elem = this._ctTbStyle.addNewTableStyleElement();
        elem.setDxfId((long)dxfId);
        elem.setType(STTableStyleType.Enum.forString((String)type));
        this._ctTbStyleElems = null;
        this._ctTbStyle.setCount((long)this._ctTbStyle.getTableStyleElementList().size());
        return elem;
    }

    public CTTableStyle getCTTableStyle() {
        return this._ctTbStyle;
    }
}

