/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.event.SheetSelectEvent;
import io.keikai.ui.sys.SpreadsheetInCtrl;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class SelectSheetCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, SelectSheetCommand.class);
        }
        Map data = request.getData();
        if (data == null || data.size() != 14) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), SelectSheetCommand.class});
        }
        Spreadsheet spreadsheet = (Spreadsheet)comp;
        String sheetId = (String)data.get("sheetId");
        boolean cacheInClient = (Boolean)data.get("cache");
        int row = (Integer)data.get("row");
        int col = (Integer)data.get("col");
        int top = (Integer)data.get("top");
        int right = (Integer)data.get("right");
        int bottom = (Integer)data.get("bottom");
        int left = (Integer)data.get("left");
        int highlightLeft = (Integer)data.get("hleft");
        int highlightTop = (Integer)data.get("htop");
        int highlightRight = (Integer)data.get("hright");
        int highlightBottom = (Integer)data.get("hbottom");
        int rowfreeze = AuRequests.getInt((Map)data, (String)"frow", (int)-1);
        int colfreeze = AuRequests.getInt((Map)data, (String)"fcol", (int)-1);
        Sheet currSheet = spreadsheet.getSelectedSheet();
        Book book = spreadsheet.getBook();
        int len = book.getNumberOfSheets();
        for (int i = 0; i < len; ++i) {
            Sheet sheet = book.getSheetAt(i);
            if (!SelectSheetCommand.getSheetUuid(sheet).equals(sheetId)) continue;
            if (currSheet.equals(sheet)) break;
            ((SpreadsheetInCtrl)spreadsheet.getExtraCtrl()).setSelectedSheetDirectly(sheet.getSheetName(), cacheInClient, row, col, left, top, right, bottom, highlightLeft, highlightTop, highlightRight, highlightBottom, rowfreeze, colfreeze);
            SheetSelectEvent event = new SheetSelectEvent("onSheetSelect", (Component)spreadsheet, sheet, currSheet);
            Events.postEvent((Event)event);
            break;
        }
    }
}

