/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.sql.impl.expression.RowValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;

public enum SqlColumnType {
    VARCHAR(0, String.class),
    BOOLEAN(1, Boolean.class),
    TINYINT(2, Byte.class),
    SMALLINT(3, Short.class),
    INTEGER(4, Integer.class),
    BIGINT(5, Long.class),
    DECIMAL(6, BigDecimal.class),
    REAL(7, Float.class),
    DOUBLE(8, Double.class),
    DATE(9, LocalDate.class),
    TIME(10, LocalTime.class),
    TIMESTAMP(11, LocalDateTime.class),
    TIMESTAMP_WITH_TIME_ZONE(12, OffsetDateTime.class),
    OBJECT(13, Object.class),
    NULL(14, Void.class),
    JSON(15, HazelcastJsonValue.class),
    ROW(16, RowValue.class);

    private static final SqlColumnType[] CACHED_VALUES;
    private final int id;
    private final Class<?> valueClass;

    private SqlColumnType(int id, Class<?> valueClass) {
        this.id = id;
        this.valueClass = valueClass;
    }

    public static SqlColumnType getById(int id) {
        for (SqlColumnType type : CACHED_VALUES) {
            if (type.id != id) continue;
            return type;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }

    static {
        CACHED_VALUES = SqlColumnType.values();
    }
}

