/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterStateListener;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.operations.TriggerMemberListPublishOp;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.IPartitionLostEvent;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionAwareService;
import com.hazelcast.internal.partition.PartitionEventListener;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.PartitionServiceProxy;
import com.hazelcast.internal.partition.PartitionStampUtil;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.ReadonlyInternalPartition;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.MigrationInterceptor;
import com.hazelcast.internal.partition.impl.MigrationManager;
import com.hazelcast.internal.partition.impl.MigrationRunnable;
import com.hazelcast.internal.partition.impl.PartitionEventManager;
import com.hazelcast.internal.partition.impl.PartitionReplicaManager;
import com.hazelcast.internal.partition.impl.PartitionReplicaStateChecker;
import com.hazelcast.internal.partition.impl.PartitionServiceState;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.impl.PublishPartitionRuntimeStateTask;
import com.hazelcast.internal.partition.impl.ReplicaFragmentSyncInfo;
import com.hazelcast.internal.partition.operation.AssignPartitions;
import com.hazelcast.internal.partition.operation.FetchPartitionStateOperation;
import com.hazelcast.internal.partition.operation.PartitionStateCheckOperation;
import com.hazelcast.internal.partition.operation.PartitionStateOperation;
import com.hazelcast.internal.partition.operation.ShutdownRequestOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.scheduler.CoalescingDelayedTrigger;
import com.hazelcast.internal.util.scheduler.ScheduledEntry;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.partition.PartitionEvent;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationservice.UrgentSystemOperation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class InternalPartitionServiceImpl
implements InternalPartitionService,
EventPublishingService<PartitionEvent, PartitionEventListener<PartitionEvent>>,
PartitionAwareService,
ClusterStateListener {
    private static final int PARTITION_OWNERSHIP_WAIT_MILLIS = 10;
    private static final int SAFE_SHUTDOWN_MAX_AWAIT_STEP_MILLIS = 1000;
    private static final long FETCH_PARTITION_STATE_SECONDS = 5L;
    private static final long TRIGGER_MASTER_DELAY_MILLIS = 1000L;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final int partitionCount;
    private final long partitionMigrationTimeout;
    private final PartitionServiceProxy proxy;
    private final Lock partitionServiceLock = new ReentrantLock();
    private final PartitionStateManager partitionStateManager;
    private final MigrationManager migrationManager;
    private final PartitionReplicaManager replicaManager;
    private final PartitionReplicaStateChecker partitionReplicaStateChecker;
    private final PartitionEventManager partitionEventManager;
    private final AtomicBoolean masterTriggered = new AtomicBoolean(false);
    private final CoalescingDelayedTrigger masterTrigger;
    private final AtomicReference<CountDownLatch> shutdownLatchRef = new AtomicReference();
    private final Executor internalAsyncExecutor;
    private volatile Address latestMaster;
    private volatile boolean shouldFetchPartitionTables;

    public InternalPartitionServiceImpl(Node node) {
        HazelcastProperties properties = node.getProperties();
        this.partitionCount = properties.getInteger(ClusterProperty.PARTITION_COUNT);
        this.node = node;
        this.nodeEngine = node.nodeEngine;
        this.logger = node.getLogger(InternalPartitionService.class);
        this.internalAsyncExecutor = this.nodeEngine.getExecutionService().getExecutor("hz:async");
        this.partitionStateManager = new PartitionStateManager(node, this);
        this.migrationManager = new MigrationManager(node, this, this.partitionServiceLock);
        this.replicaManager = new PartitionReplicaManager(node, this);
        this.partitionReplicaStateChecker = new PartitionReplicaStateChecker(node, this);
        this.partitionEventManager = new PartitionEventManager(node);
        this.masterTrigger = new CoalescingDelayedTrigger(this.nodeEngine.getExecutionService(), 1000L, 2000L, this::resetMasterTriggeredFlag);
        this.partitionMigrationTimeout = properties.getMillis(ClusterProperty.PARTITION_MIGRATION_TIMEOUT);
        this.proxy = new PartitionServiceProxy(this.nodeEngine, this);
        MetricsRegistry metricsRegistry = this.nodeEngine.getMetricsRegistry();
        metricsRegistry.registerStaticMetrics(this, "partitions");
        metricsRegistry.registerStaticMetrics(this.partitionStateManager, "partitions");
        metricsRegistry.registerStaticMetrics(this.migrationManager, "partitions");
        metricsRegistry.registerStaticMetrics(this.replicaManager, "partitions");
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        int partitionTableSendInterval = this.node.getProperties().getSeconds(ClusterProperty.PARTITION_TABLE_SEND_INTERVAL);
        if (partitionTableSendInterval <= 0) {
            partitionTableSendInterval = 1;
        }
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.scheduleWithRepetition(new PublishPartitionRuntimeStateTask(this.node, this), partitionTableSendInterval, partitionTableSendInterval, TimeUnit.SECONDS);
        this.migrationManager.start();
        this.replicaManager.scheduleReplicaVersionSync(executionService);
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        InternalPartitionImpl partition;
        if (!this.partitionStateManager.isInitialized()) {
            this.firstArrangement();
        }
        if ((partition = this.partitionStateManager.getPartitionImpl(partitionId)).getOwnerReplicaOrNull() == null && !this.node.isMaster() && !this.isClusterFormedByOnlyLiteMembers()) {
            this.triggerMasterToAssignPartitions();
        }
        return partition.getOwnerOrNull();
    }

    @Override
    public Address getPartitionOwnerOrWait(int partitionId) {
        Address owner;
        while ((owner = this.getPartitionOwner(partitionId)) == null) {
            if (!this.nodeEngine.isRunning()) {
                throw new HazelcastInstanceNotActiveException();
            }
            ClusterState clusterState = this.node.getClusterService().getClusterState();
            if (!clusterState.isMigrationAllowed()) {
                throw new IllegalStateException("Partitions can't be assigned since cluster-state: " + (Object)((Object)clusterState));
            }
            if (this.isClusterFormedByOnlyLiteMembers()) {
                throw new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ExceptionUtil.rethrow(e);
            }
        }
        return owner;
    }

    @Override
    public PartitionRuntimeState firstArrangement() {
        if (!this.isLocalMemberMaster()) {
            this.triggerMasterToAssignPartitions();
            return null;
        }
        try {
            if (!this.partitionServiceLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                return null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            Set<Member> excludedMembers;
            if (!this.partitionStateManager.isInitialized() && this.partitionStateManager.initializePartitionAssignments(excludedMembers = this.migrationManager.getShutdownRequestedMembers())) {
                this.publishPartitionRuntimeState();
            }
            PartitionRuntimeState partitionRuntimeState = this.createPartitionStateInternal();
            return partitionRuntimeState;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public boolean isPartitionAssignmentDone() {
        return this.partitionStateManager.isInitialized();
    }

    private void triggerMasterToAssignPartitions() {
        if (!this.shouldTriggerMasterToAssignPartitions()) {
            return;
        }
        ClusterServiceImpl clusterService = this.node.getClusterService();
        ClusterState clusterState = clusterService.getClusterState();
        if (!clusterState.isMigrationAllowed()) {
            this.logger.warning("Partitions can't be assigned since cluster-state=" + (Object)((Object)clusterState));
            return;
        }
        Address masterAddress = this.latestMaster;
        if (masterAddress == null || masterAddress.equals(this.node.getThisAddress())) {
            return;
        }
        if (this.masterTriggered.compareAndSet(false, true)) {
            OperationServiceImpl operationService = this.nodeEngine.getOperationService();
            InvocationFuture future = operationService.invokeOnTarget("hz:core:partitionService", new AssignPartitions(), masterAddress);
            future.whenCompleteAsync((partitionState, throwable) -> {
                if (throwable == null) {
                    this.resetMasterTriggeredFlag();
                    if (partitionState != null) {
                        partitionState.setMaster(masterAddress);
                        this.processPartitionRuntimeState((PartitionRuntimeState)partitionState);
                    }
                } else {
                    this.resetMasterTriggeredFlag();
                    this.logger.severe((Throwable)throwable);
                }
            }, this.internalAsyncExecutor);
            this.masterTrigger.executeWithDelay();
        }
    }

    private boolean shouldTriggerMasterToAssignPartitions() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        return !this.partitionStateManager.isInitialized() && clusterService.isJoined() && this.node.getNodeExtension().isStartCompleted();
    }

    private void resetMasterTriggeredFlag() {
        this.masterTriggered.set(false);
    }

    private boolean isClusterFormedByOnlyLiteMembers() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        return clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).isEmpty();
    }

    public void setInitialState(PartitionTableView partitionTable) {
        this.partitionServiceLock.lock();
        try {
            this.partitionStateManager.setInitialState(partitionTable);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public int getMemberGroupsSize() {
        return this.partitionStateManager.getMemberGroupsSize();
    }

    @Override
    @Probe(name="maxBackupCount")
    public int getMaxAllowedBackupCount() {
        return Math.max(Math.min(this.getMemberGroupsSize() - 1, 6), 0);
    }

    public void updateMemberGroupSize() {
        this.partitionStateManager.updateMemberGroupsSize();
    }

    @Override
    public void memberAdded(Member member) {
        this.logger.fine("Adding " + member);
        this.partitionServiceLock.lock();
        try {
            this.latestMaster = this.node.getClusterService().getMasterAddress();
            if (!member.localMember()) {
                this.partitionStateManager.updateMemberGroupsSize();
            }
            if (this.isLocalMemberMaster() && this.partitionStateManager.isInitialized()) {
                this.migrationManager.triggerControlTask();
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberRemoved(Member ... members) {
        if (members.length == 0) {
            return;
        }
        this.logger.fine("Removing " + Arrays.toString(members));
        this.partitionServiceLock.lock();
        try {
            ClusterState clusterState = this.node.getClusterService().getClusterState();
            for (Member member : members) {
                boolean isThisNodeNewMaster;
                this.migrationManager.onMemberRemove(member);
                this.replicaManager.cancelReplicaSyncRequestsTo(member);
                Address formerMaster = this.latestMaster;
                this.latestMaster = this.node.getClusterService().getMasterAddress();
                if (!clusterState.isMigrationAllowed() && !clusterState.isPartitionPromotionAllowed()) continue;
                this.partitionStateManager.updateMemberGroupsSize();
                boolean bl = isThisNodeNewMaster = this.node.isMaster() && !this.node.getThisAddress().equals(formerMaster);
                if (isThisNodeNewMaster) {
                    assert (!this.shouldFetchPartitionTables);
                    this.shouldFetchPartitionTables = true;
                }
                if (!this.partitionStateManager.isAbsentInPartitionTable(member)) {
                    this.partitionStateManager.storeSnapshot(member.getUuid());
                    continue;
                }
                this.partitionStateManager.removeSnapshot(member.getUuid());
            }
            if (this.node.isMaster() && (clusterState.isMigrationAllowed() || clusterState.isPartitionPromotionAllowed())) {
                this.migrationManager.triggerControlTaskWithDelay();
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public void onClusterStateChange(ClusterState newState) {
        if (!newState.isMigrationAllowed()) {
            return;
        }
        if (!this.partitionStateManager.isInitialized()) {
            return;
        }
        if (!this.isLocalMemberMaster()) {
            return;
        }
        this.partitionServiceLock.lock();
        try {
            if (this.partitionStateManager.isInitialized() && this.migrationManager.shouldTriggerRepartitioningWhenClusterStateAllowsMigration()) {
                this.migrationManager.triggerControlTask();
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public PartitionRuntimeState createPartitionState() {
        if (!this.isFetchMostRecentPartitionTableTaskRequired()) {
            return this.createPartitionStateInternal();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionRuntimeState createPartitionStateInternal() {
        this.partitionServiceLock.lock();
        try {
            if (!this.partitionStateManager.isInitialized()) {
                PartitionRuntimeState partitionRuntimeState = null;
                return partitionRuntimeState;
            }
            List<MigrationInfo> completedMigrations = this.migrationManager.getCompletedMigrationsCopy();
            InternalPartition[] partitions = this.partitionStateManager.getPartitions();
            long stamp = this.partitionStateManager.getStamp();
            assert (PartitionStampUtil.calculateStamp(partitions) == stamp) : "Invalid partition stamp! Expected: " + PartitionStampUtil.calculateStamp(partitions) + ", Actual: " + stamp;
            PartitionRuntimeState state = new PartitionRuntimeState(partitions, completedMigrations, stamp);
            ArrayList<MigrationInfo> activeMigrations = new ArrayList<MigrationInfo>(this.migrationManager.getActiveMigrations());
            state.setActiveMigrations(activeMigrations);
            PartitionRuntimeState partitionRuntimeState = state;
            return partitionRuntimeState;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartitionRuntimeState createPromotionCommitPartitionState(Collection<MigrationInfo> migrationInfos) {
        this.partitionServiceLock.lock();
        try {
            if (!this.partitionStateManager.isInitialized()) {
                PartitionRuntimeState partitionRuntimeState = null;
                return partitionRuntimeState;
            }
            List<MigrationInfo> completedMigrations = this.migrationManager.getCompletedMigrationsCopy();
            InternalPartition[] partitions = this.partitionStateManager.getPartitionsCopy(false);
            for (MigrationInfo migrationInfo : migrationInfos) {
                int partitionId = migrationInfo.getPartitionId();
                InternalPartitionImpl partition = (InternalPartitionImpl)partitions[partitionId];
                MigrationManager.applyMigration(partition, migrationInfo);
                migrationInfo.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
            }
            long stamp = PartitionStampUtil.calculateStamp(partitions);
            PartitionRuntimeState partitionRuntimeState = new PartitionRuntimeState(partitions, completedMigrations, stamp);
            return partitionRuntimeState;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    void publishPartitionRuntimeState() {
        if (!this.partitionStateManager.isInitialized()) {
            return;
        }
        if (!this.isLocalMemberMaster()) {
            return;
        }
        if (!this.areMigrationTasksAllowed()) {
            return;
        }
        PartitionRuntimeState partitionState = this.createPartitionStateInternal();
        if (partitionState == null) {
            return;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Publishing partition state, stamp: " + partitionState.getStamp());
        }
        PartitionStateOperation op = new PartitionStateOperation(partitionState, false);
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        Set<Member> members = this.node.clusterService.getMembers();
        for (Member member : members) {
            if (member.localMember()) continue;
            try {
                operationService.send(op, member.getAddress());
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
    }

    void sendPartitionRuntimeState(Address target) {
        if (!this.isLocalMemberMaster()) {
            return;
        }
        assert (this.partitionStateManager.isInitialized());
        PartitionRuntimeState partitionState = this.createPartitionStateInternal();
        assert (partitionState != null);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Sending partition state, stamp: " + partitionState.getStamp() + ", to " + target);
        }
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        PartitionStateOperation op = new PartitionStateOperation(partitionState, true);
        operationService.invokeOnTarget("hz:core:partitionService", op, target);
    }

    void checkClusterPartitionRuntimeStates() {
        if (!this.partitionStateManager.isInitialized()) {
            return;
        }
        if (!this.isLocalMemberMaster()) {
            return;
        }
        if (!this.areMigrationTasksAllowed()) {
            return;
        }
        long stamp = this.getPartitionStateStamp();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Checking partition state, stamp: " + stamp);
        }
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        Set<Member> members = this.node.clusterService.getMembers();
        for (Member member : members) {
            if (member.localMember()) continue;
            PartitionStateCheckOperation op = new PartitionStateCheckOperation(stamp);
            InvocationFuture future = operationService.invokeOnTarget("hz:core:partitionService", op, member.getAddress());
            future.whenCompleteAsync((response, throwable) -> {
                if (throwable == null) {
                    if (!Boolean.TRUE.equals(response)) {
                        this.logger.fine(member + " has a stale partition state. Will send the most recent partition state now.");
                        this.sendPartitionRuntimeState(member.getAddress());
                    }
                } else {
                    this.logger.fine("Failure while checking partition state on " + member, (Throwable)throwable);
                    this.sendPartitionRuntimeState(member.getAddress());
                }
            }, this.internalAsyncExecutor);
        }
    }

    public boolean processPartitionRuntimeState(PartitionRuntimeState partitionState) {
        if (!this.node.getNodeExtension().isStartCompleted()) {
            this.logger.warning("Ignoring received partition table, startup is not completed yet. Sender: " + partitionState.getMaster());
            return false;
        }
        return this.applyPartitionRuntimeState(partitionState);
    }

    public boolean applyPartitionRuntimeState(PartitionRuntimeState partitionState) {
        Address sender = partitionState.getMaster();
        if (!this.validateSenderIsMaster(sender, "partition table update")) {
            return false;
        }
        assert (PartitionStampUtil.calculateStamp(partitionState.getPartitions()) == partitionState.getStamp()) : "Invalid partition stamp! Expected: " + PartitionStampUtil.calculateStamp(partitionState.getPartitions()) + ", Actual: " + partitionState.getStamp();
        return this.applyNewPartitionTable(partitionState.getPartitions(), partitionState.getCompletedMigrations(), sender);
    }

    private boolean validateSenderIsMaster(Address sender, String messageType) {
        Address thisAddress = this.node.getThisAddress();
        if (thisAddress.equals(this.latestMaster) && !thisAddress.equals(sender)) {
            this.logger.warning("This is the master node and received " + messageType + " from " + sender + ". Ignoring incoming state! ");
            return false;
        }
        if (!this.isMemberMaster(sender)) {
            if (this.node.clusterService.getMember(sender) == null) {
                this.logger.severe("Received " + messageType + " from an unknown member! => Sender: " + sender + "! ");
            } else {
                this.logger.warning("Received " + messageType + ", but its sender doesn't seem to be master! => Sender: " + sender + "! (Ignore if master node has changed recently.)");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyNewPartitionTable(InternalPartition[] partitions, Collection<MigrationInfo> completedMigrations, Address sender) {
        this.partitionServiceLock.lock();
        try {
            this.requestMemberListUpdateIfUnknownMembersFound(sender, partitions);
            boolean bl = this.updatePartitionsAndFinalizeMigrations(partitions, completedMigrations, sender);
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private void requestMemberListUpdateIfUnknownMembersFound(Address sender, InternalPartition[] partitions) {
        ClusterServiceImpl clusterService = this.node.clusterService;
        ClusterState clusterState = clusterService.getClusterState();
        HashSet<PartitionReplica> unknownReplicas = new HashSet<PartitionReplica>();
        for (InternalPartition partition : partitions) {
            for (int index = 0; index < 7; ++index) {
                PartitionReplica replica = partition.getReplica(index);
                if (replica == null || this.node.clusterService.getMember(replica.address(), replica.uuid()) != null || !clusterState.isJoinAllowed() && clusterService.isMissingMember(replica.address(), replica.uuid())) continue;
                unknownReplicas.add(replica);
            }
        }
        if (!unknownReplicas.isEmpty()) {
            Address masterAddress;
            if (this.logger.isWarningEnabled()) {
                StringBuilder s = new StringBuilder("Following unknown addresses are found in partition table").append(" sent from master[").append(sender).append("].").append(" (Probably they have recently joined or left the cluster.)").append(" {");
                for (PartitionReplica replica : unknownReplicas) {
                    s.append("\n\t").append(replica);
                }
                s.append("\n}");
                this.logger.warning(s.toString());
            }
            if ((masterAddress = this.node.getClusterService().getMasterAddress()) != null && !masterAddress.equals(this.node.getThisAddress())) {
                this.nodeEngine.getOperationService().send(new TriggerMemberListPublishOp(), masterAddress);
            }
        }
    }

    private boolean updatePartitionsAndFinalizeMigrations(InternalPartition[] partitions, Collection<MigrationInfo> completedMigrations, Address sender) {
        boolean applied = false;
        boolean accepted = false;
        PartitionIdSet changedOwnerPartitions = new PartitionIdSet(this.partitionCount);
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            InternalPartition newPartition = partitions[partitionId];
            InternalPartitionImpl currentPartition = this.partitionStateManager.getPartitionImpl(partitionId);
            int currentVersion = currentPartition.version();
            int newVersion = newPartition.version();
            if (newVersion < currentVersion) {
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest("Already applied partition update. partitionId=" + partitionId + ", local version: " + currentVersion + ", master version: " + newVersion + ", master: " + sender);
                continue;
            }
            if (newVersion == currentVersion) {
                if (!currentPartition.equals(newPartition)) {
                    throw new IllegalStateException("Partition updates are diverged! Local: " + currentPartition + ", Received: " + newPartition);
                }
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Already applied partition update. partitionId=" + partitionId + ", version: " + currentVersion + ", master: " + sender);
                }
                accepted = true;
                continue;
            }
            applied = true;
            accepted = true;
            if (!currentPartition.setReplicasAndVersion(newPartition)) continue;
            changedOwnerPartitions.add(partitionId);
        }
        for (MigrationInfo migration : completedMigrations) {
            boolean added = this.migrationManager.addCompletedMigration(migration);
            if (!added) continue;
            this.migrationManager.scheduleActiveMigrationFinalization(migration);
        }
        this.partitionStateManager.partitionOwnersChanged(changedOwnerPartitions);
        if (this.logger.isFineEnabled()) {
            if (applied) {
                this.logger.fine("Applied partition state update with stamp: " + PartitionStampUtil.calculateStamp(partitions) + ", Local stamp is: " + this.partitionStateManager.getStamp());
            } else {
                this.logger.fine("Already applied partition state update with stamp: " + PartitionStampUtil.calculateStamp(partitions) + ", Local stamp is: " + this.partitionStateManager.getStamp());
            }
        }
        this.migrationManager.retainCompletedMigrations(completedMigrations);
        if (!this.partitionStateManager.setInitialized()) {
            this.node.getNodeExtension().onPartitionStateChange();
        }
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyCompletedMigrations(Collection<MigrationInfo> migrations, Address sender) {
        if (!this.validateSenderIsMaster(sender, "completed migrations")) {
            return false;
        }
        this.partitionServiceLock.lock();
        try {
            if (!this.partitionStateManager.isInitialized()) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Cannot apply completed migrations until partition table is initialized. Completed migrations: " + migrations);
                }
                boolean bl = false;
                return bl;
            }
            if (this.isLocalMemberMaster()) {
                boolean bl = true;
                return bl;
            }
            boolean appliedAllMigrations = true;
            for (MigrationInfo migration : migrations) {
                InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(migration.getPartitionId());
                int currentVersion = partition.version();
                if (migration.getFinalPartitionVersion() <= currentVersion) {
                    if (!this.logger.isFinestEnabled()) continue;
                    this.logger.finest("Already applied " + migration + ". Local version: " + currentVersion + ", Commit version: " + migration.getFinalPartitionVersion() + " Master: " + sender);
                    continue;
                }
                if (migration.getInitialPartitionVersion() != currentVersion) {
                    this.logger.warning("Cannot apply migration commit: " + migration + ". Expected version: " + migration.getInitialPartitionVersion() + ", current version: " + currentVersion + ", final version: " + migration.getFinalPartitionVersion() + ", Master: " + sender);
                    appliedAllMigrations = false;
                    break;
                }
                boolean added = this.migrationManager.addCompletedMigration(migration);
                assert (added) : "Migration: " + migration;
                if (migration.getStatus() == MigrationInfo.MigrationStatus.SUCCESS) {
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine("Applying completed migration " + migration);
                    }
                    MigrationManager.applyMigration(partition, migration);
                } else {
                    int increment = migration.getPartitionVersionIncrement();
                    this.partitionStateManager.incrementPartitionVersion(partition.getPartitionId(), increment);
                }
                this.migrationManager.scheduleActiveMigrationFinalization(migration);
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Applied completed migrations with partition state stamp: " + this.partitionStateManager.getStamp());
            }
            this.migrationManager.retainCompletedMigrations(migrations);
            this.node.getNodeExtension().onPartitionStateChange();
            boolean bl = appliedAllMigrations;
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public IPartition[] getPartitions() {
        IPartition[] result = new IPartition[this.partitionCount];
        System.arraycopy(this.partitionStateManager.getPartitions(), 0, result, 0, this.partitionCount);
        return result;
    }

    @Override
    public InternalPartition[] getInternalPartitions() {
        return this.partitionStateManager.getPartitions();
    }

    @Override
    public InternalPartition getPartition(int partitionId) {
        return this.getPartition(partitionId, true);
    }

    @Override
    public InternalPartition getPartition(int partitionId, boolean triggerOwnerAssignment) {
        InternalPartitionImpl p = this.partitionStateManager.getPartitionImpl(partitionId);
        if (triggerOwnerAssignment && p.getOwnerReplicaOrNull() == null) {
            this.getPartitionOwner(partitionId);
        }
        return p;
    }

    @Override
    public boolean onShutdown(long timeout, TimeUnit unit) {
        if (!this.node.getClusterService().isJoined()) {
            return true;
        }
        if (this.node.isLiteMember()) {
            return true;
        }
        CountDownLatch latch = this.getShutdownLatch();
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        long timeoutMillis = unit.toMillis(timeout);
        long awaitStep = Math.min(1000L, timeoutMillis);
        try {
            do {
                Address masterAddress;
                if ((masterAddress = this.nodeEngine.getMasterAddress()) == null) {
                    this.logger.warning("Safe shutdown failed, master member is not known!");
                    return false;
                }
                if (this.node.getThisAddress().equals(masterAddress)) {
                    this.onShutdownRequest(this.node.getLocalMember());
                } else {
                    UUID memberUuid = this.node.getLocalMember().getUuid();
                    operationService.send(new ShutdownRequestOperation(memberUuid), masterAddress);
                }
                if (!latch.await(awaitStep, TimeUnit.MILLISECONDS)) continue;
                return true;
            } while ((timeoutMillis -= awaitStep) > 0L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.info("Safe shutdown is interrupted!");
        }
        return false;
    }

    private CountDownLatch getShutdownLatch() {
        CountDownLatch latch = this.shutdownLatchRef.get();
        if (latch == null && !this.shutdownLatchRef.compareAndSet(null, latch = new CountDownLatch(1))) {
            latch = this.shutdownLatchRef.get();
        }
        return latch;
    }

    public void onShutdownRequest(Member member) {
        if (this.partitionServiceLock.tryLock()) {
            try {
                this.migrationManager.onShutdownRequest(member);
            }
            finally {
                this.partitionServiceLock.unlock();
            }
        }
    }

    public void onShutdownResponse() {
        CountDownLatch latch = this.shutdownLatchRef.get();
        assert (latch != null);
        latch.countDown();
    }

    @Override
    public boolean isMemberStateSafe() {
        return this.partitionReplicaStateChecker.getPartitionServiceState() == PartitionServiceState.SAFE;
    }

    @Override
    public boolean isPartitionTableSafe() {
        return this.partitionReplicaStateChecker.getPartitionTableState() == PartitionServiceState.SAFE;
    }

    @Override
    public boolean hasOnGoingMigration() {
        return this.hasOnGoingMigrationLocal() || !this.isLocalMemberMaster() && this.partitionReplicaStateChecker.hasOnGoingMigrationMaster(Level.FINEST);
    }

    @Override
    public boolean hasOnGoingMigrationLocal() {
        return this.migrationManager.hasOnGoingMigration();
    }

    @Override
    public final int getPartitionId(@Nonnull Data key) {
        return HashUtil.hashToIndex(key.getPartitionHash(), this.partitionCount);
    }

    @Override
    public final int getPartitionId(@Nonnull Object key) {
        return this.getPartitionId(this.nodeEngine.toData(key));
    }

    @Override
    public final int getPartitionCount() {
        return this.partitionCount;
    }

    public long getPartitionMigrationTimeout() {
        return this.partitionMigrationTimeout;
    }

    @Override
    public PartitionReplicaVersionManager getPartitionReplicaVersionManager() {
        return this.replicaManager;
    }

    @Override
    public Map<Address, List<Integer>> getMemberPartitionsMap() {
        Collection<Member> dataMembers = this.node.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        int dataMembersSize = dataMembers.size();
        int partitionsPerMember = dataMembersSize > 0 ? (int)Math.ceil((float)this.partitionCount / (float)dataMembersSize) : 0;
        Map<Address, List<Integer>> memberPartitions = MapUtil.createHashMap(dataMembersSize);
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            Address owner = this.getPartitionOwnerOrWait(partitionId);
            List ownedPartitions = memberPartitions.computeIfAbsent(owner, k -> new ArrayList(partitionsPerMember));
            ownedPartitions.add(partitionId);
        }
        return memberPartitions;
    }

    @Override
    public List<Integer> getMemberPartitions(Address target) {
        LinkedList<Integer> ownedPartitions = new LinkedList<Integer>();
        for (int i = 0; i < this.partitionCount; ++i) {
            Address owner = this.getPartitionOwner(i);
            if (!target.equals(owner)) continue;
            ownedPartitions.add(i);
        }
        return ownedPartitions;
    }

    @Override
    public List<Integer> getMemberPartitionsIfAssigned(Address target) {
        if (!this.partitionStateManager.isInitialized()) {
            return Collections.emptyList();
        }
        return this.getMemberPartitions(target);
    }

    @Override
    public void reset() {
        this.partitionServiceLock.lock();
        try {
            this.shouldFetchPartitionTables = false;
            this.replicaManager.reset();
            this.partitionStateManager.reset();
            this.migrationManager.reset();
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public void pauseMigration() {
        this.migrationManager.pauseMigration();
    }

    @Override
    public void resumeMigration() {
        this.migrationManager.resumeMigration();
    }

    public boolean areMigrationTasksAllowed() {
        return this.migrationManager.areMigrationTasksAllowed();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.logger.finest("Shutting down the partition service");
        this.migrationManager.stop();
        this.reset();
    }

    @Override
    @Probe(name="migrationQueueSize")
    public long getMigrationQueueSize() {
        return this.migrationManager.getMigrationQueueSize();
    }

    @Override
    public PartitionServiceProxy getPartitionServiceProxy() {
        return this.proxy;
    }

    @Override
    public UUID addMigrationListener(MigrationListener listener) {
        return this.partitionEventManager.addMigrationListener(listener);
    }

    @Override
    public CompletableFuture<UUID> addMigrationListenerAsync(MigrationListener migrationListener) {
        return this.partitionEventManager.addMigrationListenerAsync(migrationListener);
    }

    @Override
    public UUID addLocalMigrationListener(MigrationListener migrationListener) {
        return this.partitionEventManager.addLocalMigrationListener(migrationListener);
    }

    @Override
    public boolean removeMigrationListener(UUID registrationId) {
        return this.partitionEventManager.removeMigrationListener(registrationId);
    }

    @Override
    public CompletableFuture<Boolean> removeMigrationListenerAsync(UUID registrationId) {
        return this.partitionEventManager.removeMigrationListenerAsync(registrationId);
    }

    @Override
    public UUID addPartitionLostListener(PartitionLostListener listener) {
        return this.partitionEventManager.addPartitionLostListener(listener);
    }

    @Override
    public CompletableFuture<UUID> addPartitionLostListenerAsync(PartitionLostListener listener) {
        return this.partitionEventManager.addPartitionLostListenerAsync(listener);
    }

    @Override
    public UUID addLocalPartitionLostListener(PartitionLostListener listener) {
        return this.partitionEventManager.addLocalPartitionLostListener(listener);
    }

    @Override
    public boolean removePartitionLostListener(UUID registrationId) {
        return this.partitionEventManager.removePartitionLostListener(registrationId);
    }

    @Override
    public CompletableFuture<Boolean> removePartitionLostListenerAsync(UUID registrationId) {
        return this.partitionEventManager.removePartitionLostListenerAsync(registrationId);
    }

    @Override
    public void dispatchEvent(PartitionEvent event, PartitionEventListener<PartitionEvent> partitionEventListener) {
        partitionEventListener.onEvent(event);
    }

    @Override
    public boolean isPartitionOwner(int partitionId) {
        InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(partitionId);
        return partition.isLocal();
    }

    @Override
    public long getPartitionStateStamp() {
        return this.partitionStateManager.getStamp();
    }

    @Override
    public void onPartitionLost(IPartitionLostEvent event) {
        this.partitionEventManager.onPartitionLost(event);
    }

    public void setMigrationInterceptor(MigrationInterceptor listener) {
        this.migrationManager.setMigrationInterceptor(listener);
    }

    public MigrationInterceptor getMigrationInterceptor() {
        return this.migrationManager.getMigrationInterceptor();
    }

    public void resetMigrationInterceptor() {
        this.migrationManager.resetMigrationInterceptor();
    }

    public List<ReplicaFragmentSyncInfo> getOngoingReplicaSyncRequests() {
        return this.replicaManager.getOngoingReplicaSyncRequests();
    }

    public List<ScheduledEntry<ReplicaFragmentSyncInfo, Void>> getScheduledReplicaSyncRequests() {
        return this.replicaManager.getScheduledReplicaSyncRequests();
    }

    public PartitionStateManager getPartitionStateManager() {
        return this.partitionStateManager;
    }

    public MigrationManager getMigrationManager() {
        return this.migrationManager;
    }

    public PartitionReplicaManager getReplicaManager() {
        return this.replicaManager;
    }

    @Override
    public PartitionReplicaStateChecker getPartitionReplicaStateChecker() {
        return this.partitionReplicaStateChecker;
    }

    public PartitionEventManager getPartitionEventManager() {
        return this.partitionEventManager;
    }

    boolean isFetchMostRecentPartitionTableTaskRequired() {
        return this.shouldFetchPartitionTables;
    }

    boolean scheduleFetchMostRecentPartitionTableTaskIfRequired() {
        this.partitionServiceLock.lock();
        try {
            if (this.shouldFetchPartitionTables) {
                this.migrationManager.schedule(new FetchMostRecentPartitionTableTask());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    public void replaceMember(Member oldMember, Member newMember) {
        this.partitionServiceLock.lock();
        try {
            this.partitionStateManager.replaceMember(oldMember, newMember);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public PartitionTableView createPartitionTableView() {
        this.partitionServiceLock.lock();
        try {
            PartitionTableView partitionTableView = this.partitionStateManager.getPartitionTable();
            return partitionTableView;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public PartitionTableView getLeftMemberSnapshot(UUID uuid) {
        return this.partitionStateManager.getSnapshot(uuid);
    }

    public boolean isLocalMemberMaster() {
        return this.isMemberMaster(this.node.getThisAddress());
    }

    public boolean isMemberMaster(Address address) {
        if (address == null) {
            return false;
        }
        Address master = this.latestMaster;
        ClusterServiceImpl clusterService = this.node.getClusterService();
        if (master == null && clusterService.getSize() == 1) {
            master = clusterService.getMasterAddress();
        }
        return address.equals(master) && address.equals(clusterService.getMasterAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitMigrationOnDestination(MigrationInfo migration, Address sender) {
        this.partitionServiceLock.lock();
        try {
            if (!this.validateSenderIsMaster(sender, "migration commit")) {
                boolean bl = false;
                return bl;
            }
            InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(migration.getPartitionId());
            int currentVersion = partition.version();
            int initialVersion = migration.getInitialPartitionVersion();
            int finalVersion = migration.getFinalPartitionVersion();
            if (finalVersion == currentVersion) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Already applied migration commit. Version: " + currentVersion + ", Master: " + sender);
                }
                boolean bl = true;
                return bl;
            }
            if (finalVersion < currentVersion) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Already applied migration commit. Local version: " + currentVersion + ", Master version: " + finalVersion + " Master: " + sender);
                }
                boolean bl = false;
                return bl;
            }
            if (initialVersion != currentVersion) {
                throw new IllegalStateException("Invalid migration commit! Expected version: " + initialVersion + ", current version: " + currentVersion + ", Master: " + sender);
            }
            MigrationInfo activeMigration = this.migrationManager.getActiveMigration(migration.getPartitionId());
            assert (migration.equals(activeMigration)) : "Committed migration: " + migration + ", Active migration: " + activeMigration;
            boolean added = this.migrationManager.addCompletedMigration(migration);
            assert (added) : "Could not add completed migration on destination: " + migration;
            MigrationManager.applyMigration(partition, migration);
            assert (partition.version() == finalVersion) : "Current: " + partition.version() + ", Expected: " + finalVersion;
            activeMigration.setStatus(migration.getStatus());
            this.migrationManager.finalizeMigration(migration);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Committed " + migration + " on destination with partition version: " + finalVersion);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    public String toString() {
        return "InternalPartitionService {stamp: " + this.getPartitionStateStamp() + ", migrationQ: " + this.getMigrationQueueSize() + "}";
    }

    private class FetchMostRecentPartitionTableTask
    implements MigrationRunnable {
        private final Address thisAddress;
        private InternalPartition[] latestPartitions;
        private boolean initialized;

        private FetchMostRecentPartitionTableTask() {
            this.thisAddress = InternalPartitionServiceImpl.this.node.getThisAddress();
            this.initialized = InternalPartitionServiceImpl.this.partitionStateManager.isInitialized();
        }

        @Override
        public void run() {
            ClusterState clusterState = InternalPartitionServiceImpl.this.node.getClusterService().getClusterState();
            if (!clusterState.isMigrationAllowed() && !clusterState.isPartitionPromotionAllowed()) {
                InternalPartitionServiceImpl.this.logger.fine("No need to fetch the latest partition table. Cluster state does not allow to modify partition table.");
                InternalPartitionServiceImpl.this.shouldFetchPartitionTables = false;
                return;
            }
            this.syncWithPartitionThreads();
            InternalPartitionServiceImpl.this.logger.info("Fetching partition tables from cluster to determine the most recent one... Local stamp: " + InternalPartitionServiceImpl.this.partitionStateManager.getStamp());
            this.latestPartitions = InternalPartitionServiceImpl.this.partitionStateManager.getPartitionsCopy(true);
            HashSet<MigrationInfo> allCompletedMigrations = new HashSet<MigrationInfo>();
            HashSet<MigrationInfo> allActiveMigrations = new HashSet<MigrationInfo>();
            this.collectAndProcessResults(allCompletedMigrations, allActiveMigrations);
            InternalPartitionServiceImpl.this.logger.info("Most recent partition table is determined.");
            this.processNewState(allCompletedMigrations, allActiveMigrations);
            InternalPartitionServiceImpl.this.publishPartitionRuntimeState();
        }

        private Future<PartitionRuntimeState> fetchPartitionState(Member m) {
            return InternalPartitionServiceImpl.this.nodeEngine.getOperationService().invokeOnTarget("hz:core:partitionService", new FetchPartitionStateOperation(), m.getAddress());
        }

        private void collectAndProcessResults(Collection<MigrationInfo> allCompletedMigrations, Collection<MigrationInfo> allActiveMigrations) {
            Collection<Member> members = ((InternalPartitionServiceImpl)InternalPartitionServiceImpl.this).node.clusterService.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR);
            HashMap<Member, Future<PartitionRuntimeState>> futures = new HashMap<Member, Future<PartitionRuntimeState>>();
            for (Member member : members) {
                Future<PartitionRuntimeState> future = this.fetchPartitionState(member);
                futures.put(member, future);
            }
            while (!futures.isEmpty()) {
                Iterator<Map.Entry<Member, Future<PartitionRuntimeState>>> iter = futures.entrySet().iterator();
                while (iter.hasNext()) {
                    PartitionRuntimeState state = this.collectNextPartitionState(iter);
                    if (state == null) continue;
                    for (InternalPartition partition : state.getPartitions()) {
                        int partitionId = partition.getPartitionId();
                        InternalPartition latestPartition = this.latestPartitions[partitionId];
                        if (latestPartition.version() < partition.version()) {
                            this.latestPartitions[partitionId] = partition;
                            this.initialized = true;
                            continue;
                        }
                        if (latestPartition.version() != partition.version() || latestPartition.equals(partition)) continue;
                        InternalPartitionServiceImpl.this.logger.warning("Issue while determining latest partition... Latest: " + latestPartition + ", Received: " + partition);
                    }
                    allCompletedMigrations.addAll(state.getCompletedMigrations());
                    if (state.getActiveMigrations() == null) continue;
                    allActiveMigrations.addAll(state.getActiveMigrations());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PartitionRuntimeState collectNextPartitionState(Iterator<Map.Entry<Member, Future<PartitionRuntimeState>>> iter) {
            Map.Entry<Member, Future<PartitionRuntimeState>> next = iter.next();
            Member member = next.getKey();
            Future<PartitionRuntimeState> future = next.getValue();
            boolean collectedState = true;
            try {
                PartitionRuntimeState state = future.get(5L, TimeUnit.SECONDS);
                if (state == null) {
                    InternalPartitionServiceImpl.this.logger.fine("Received NULL partition state from " + member);
                } else {
                    InternalPartitionServiceImpl.this.logger.fine("Received partition state version from " + member);
                }
                PartitionRuntimeState partitionRuntimeState = state;
                return partitionRuntimeState;
            }
            catch (InterruptedException e) {
                InternalPartitionServiceImpl.this.logger.fine("FetchMostRecentPartitionTableTask is interrupted.");
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                collectedState = false;
                next.setValue(this.fetchPartitionState(member));
            }
            catch (Exception e) {
                Level level = Level.SEVERE;
                if (e instanceof MemberLeftException || e.getCause() instanceof TargetNotMemberException) {
                    level = Level.FINE;
                }
                InternalPartitionServiceImpl.this.logger.log(level, "Failed to fetch partition table from " + member, e);
            }
            finally {
                if (collectedState) {
                    iter.remove();
                }
            }
            return null;
        }

        private void processNewState(Collection<MigrationInfo> allCompletedMigrations, Collection<MigrationInfo> allActiveMigrations) {
            InternalPartitionServiceImpl.this.partitionServiceLock.lock();
            try {
                this.processMigrations(allCompletedMigrations, allActiveMigrations);
                if (this.initialized) {
                    for (MigrationInfo migration : allCompletedMigrations) {
                        if (migration.getStatus() != MigrationInfo.MigrationStatus.FAILED) continue;
                        int partitionId = migration.getPartitionId();
                        InternalPartition partition = this.latestPartitions[partitionId];
                        this.latestPartitions[partitionId] = new ReadonlyInternalPartition(partition.getReplicasCopy(), partitionId, migration.getFinalPartitionVersion());
                    }
                    InternalPartitionServiceImpl.this.logger.info("Applying the most recent of partition state...");
                    InternalPartitionServiceImpl.this.applyNewPartitionTable(this.latestPartitions, allCompletedMigrations, this.thisAddress);
                }
                InternalPartitionServiceImpl.this.shouldFetchPartitionTables = false;
            }
            catch (Throwable rethrowed) {
                String lineSeparator = System.lineSeparator();
                StringBuilder sb = new StringBuilder().append("latestPartitions:").append(lineSeparator).append(StringUtil.toString(this.latestPartitions)).append(lineSeparator).append("allCompletedMigrations:").append(lineSeparator).append(StringUtil.toString(allCompletedMigrations)).append(lineSeparator).append("allActiveMigrations:").append(lineSeparator).append(StringUtil.toString(allActiveMigrations)).append(lineSeparator).append(rethrowed);
                InternalPartitionServiceImpl.this.logger.warning(sb.toString());
                throw rethrowed;
            }
            finally {
                InternalPartitionServiceImpl.this.partitionServiceLock.unlock();
            }
        }

        private void processMigrations(Collection<MigrationInfo> allCompletedMigrations, Collection<MigrationInfo> allActiveMigrations) {
            allCompletedMigrations.addAll(InternalPartitionServiceImpl.this.migrationManager.getCompletedMigrationsCopy());
            allActiveMigrations.addAll(InternalPartitionServiceImpl.this.migrationManager.getActiveMigrations());
            for (MigrationInfo migration : allActiveMigrations) {
                if (!allCompletedMigrations.add(migration)) continue;
                InternalPartitionServiceImpl.this.logger.info("Marking active migration " + migration + " as " + (Object)((Object)MigrationInfo.MigrationStatus.FAILED));
                migration.setStatus(MigrationInfo.MigrationStatus.FAILED);
                migration.setPartitionVersionIncrement(migration.getPartitionVersionIncrement() + 1);
            }
        }

        private void syncWithPartitionThreads() {
            OperationExecutor opExecutor = InternalPartitionServiceImpl.this.nodeEngine.getOperationService().getOperationExecutor();
            CountDownLatch latch = new CountDownLatch(opExecutor.getPartitionThreadCount());
            opExecutor.executeOnPartitionThreads(new PartitionThreadBarrierTask(latch));
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                InternalPartitionServiceImpl.this.logger.warning(e);
                Thread.currentThread().interrupt();
            }
        }

        private final class PartitionThreadBarrierTask
        implements Runnable,
        UrgentSystemOperation {
            private final CountDownLatch latch;

            private PartitionThreadBarrierTask(CountDownLatch latch) {
                this.latch = latch;
            }

            @Override
            public void run() {
                this.latch.countDown();
            }
        }
    }
}

