/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.PermissionConfig;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.json.internal.JsonSerializable;
import java.util.HashSet;
import java.util.Set;

public class PermissionConfigDTO
implements JsonSerializable {
    private PermissionConfig permissionConfig;

    public PermissionConfigDTO() {
    }

    public PermissionConfigDTO(PermissionConfig permissionConfig) {
        this.permissionConfig = permissionConfig;
    }

    @Override
    public JsonObject toJson() {
        Set<String> actions;
        JsonObject object = new JsonObject();
        object.add("permissionType", this.permissionConfig.getType().getNodeName());
        object.add("name", this.permissionConfig.getName());
        if (StringUtil.isNullOrEmptyAfterTrim(this.permissionConfig.getPrincipal())) {
            object.add("principal", "*");
        } else {
            object.add("principal", this.permissionConfig.getPrincipal());
        }
        Set<String> endpoints = this.permissionConfig.getEndpoints();
        if (endpoints != null) {
            JsonArray endpointsArray = new JsonArray();
            for (String endpoint : endpoints) {
                endpointsArray.add(endpoint);
            }
            object.add("endpoints", endpointsArray);
        }
        if ((actions = this.permissionConfig.getActions()) != null) {
            JsonArray actionsArray = new JsonArray();
            for (String action : actions) {
                actionsArray.add(action);
            }
            object.add("actions", actionsArray);
        }
        return object;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonValue actionsVal;
        this.permissionConfig = new PermissionConfig();
        this.permissionConfig.setType(PermissionConfig.PermissionType.getType(json.getString("permissionType", null)));
        this.permissionConfig.setName(json.get("name").asString());
        this.permissionConfig.setPrincipal(json.getString("principal", "*"));
        JsonValue endpointsVal = json.get("endpoints");
        if (endpointsVal != null) {
            HashSet<String> endpoints = new HashSet<String>();
            for (JsonValue endpoint : endpointsVal.asArray().values()) {
                endpoints.add(endpoint.asString());
            }
            this.permissionConfig.setEndpoints(endpoints);
        }
        if ((actionsVal = json.get("actions")) != null) {
            HashSet<String> actions = new HashSet<String>();
            for (JsonValue action : actionsVal.asArray().values()) {
                actions.add(action.asString());
            }
            this.permissionConfig.setActions(actions);
        }
    }

    public PermissionConfig getPermissionConfig() {
        return this.permissionConfig;
    }
}

