/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.LinkedList;
import name.fraser.neil.plaintext.diff_match_patch;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.GridTab;
import org.compiere.model.MField;
import org.compiere.util.Env;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;

@Form
public class CompareFieldSuggestion
extends ADForm {
    private static final String NEW_VALUE_ATTR = "newValue";
    private static final long serialVersionUID = -100362034024824442L;
    private Grid grid;
    private ConfirmPanel confirmPanel;
    private Cell descriptionDiff;
    private Cell nameDiff;
    private Cell helpDiff;
    private Textbox nameTextbox;
    private Textbox descriptionTextbox;
    private Textbox helpTextbox;
    private MField field;
    private String AD_Language;
    private diff_match_patch diff;
    private Timer nameTimer;
    private Timer descriptionTimer;
    private Timer helpTimer;

    @Override
    protected void initForm() {
        this.setWidth("70%");
        this.setHeight("500px");
        this.setSizable(true);
        Vlayout layout = new Vlayout();
        layout.setHflex("1");
        layout.setVflex("1");
        this.appendChild((Component)layout);
        this.grid = new Grid();
        this.grid.setVflex(true);
        this.grid.setHflex("1");
        layout.appendChild((Component)this.grid);
        Div div = new Div();
        div.setSclass("dialog-footer");
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.setStyle("padding: 8px 16px;");
        this.confirmPanel.setHflex("1");
        this.confirmPanel.setVflex("min");
        div.appendChild((Component)this.confirmPanel);
        layout.appendChild((Component)div);
        this.confirmPanel.addActionListener(this);
        this.diff = new diff_match_patch();
        this.nameTimer = new Timer();
        this.nameTimer.setDelay(1000);
        this.nameTimer.setRepeats(false);
        this.appendChild((Component)this.nameTimer);
        this.nameTimer.stop();
        this.nameTimer.addEventListener("onTimer", (EventListener)this);
        this.descriptionTimer = new Timer();
        this.descriptionTimer.setDelay(1000);
        this.descriptionTimer.setRepeats(false);
        this.appendChild((Component)this.descriptionTimer);
        this.descriptionTimer.stop();
        this.descriptionTimer.addEventListener("onTimer", (EventListener)this);
        this.helpTimer = new Timer();
        this.helpTimer.setDelay(1000);
        this.helpTimer.setRepeats(false);
        this.appendChild((Component)this.helpTimer);
        this.helpTimer.stop();
        this.helpTimer.addEventListener("onTimer", (EventListener)this);
        this.renderGrid();
    }

    private void renderGrid() {
        Component c = SessionManager.getAppDesktop().getActiveWindow();
        ADWindow adwindow = ADWindow.findADWindow(c);
        GridTab gridTab = adwindow.getADWindowContent().getActiveGridTab();
        int AD_Field_ID = (Integer)gridTab.getValue("AD_Field_ID");
        this.field = new MField(Env.getCtx(), AD_Field_ID, null);
        this.AD_Language = (String)gridTab.getValue("AD_Language");
        Columns columns = new Columns();
        this.grid.appendChild((Component)columns);
        Column column = new Column();
        column.setWidth("100px");
        column.setLabel("");
        columns.appendChild((Component)column);
        column = new Column();
        column.setLabel("Original Text");
        column.setValign("top");
        columns.appendChild((Component)column);
        column = new Column();
        column.setLabel("Changed Text");
        column.setValign("top");
        columns.appendChild((Component)column);
        column = new Column();
        column.setLabel("Difference");
        column.setValign("top");
        columns.appendChild((Component)column);
        Rows rows = this.grid.newRows();
        Row row = rows.newRow();
        row.appendCellChild((Component)new Label("Name"));
        String original = this.field.get_Translation("Name", this.AD_Language);
        row.appendCellChild((Component)new Label(original));
        String changed = (String)gridTab.getValue("Name");
        this.nameTextbox = new Textbox(changed);
        row.appendCellChild((Component)this.nameTextbox);
        this.nameTextbox.addEventListener("onChange", (EventListener)this);
        this.nameTextbox.addEventListener("onChanging", (EventListener)this);
        this.nameTextbox.setMaxlength(60);
        this.nameTextbox.setHflex("1");
        Html html = this.diff(original, changed);
        this.nameDiff = new Cell();
        this.nameDiff.appendChild((Component)html);
        row.appendChild((Component)this.nameDiff);
        row = rows.newRow();
        row.appendCellChild((Component)new Label("Description"));
        original = this.field.get_Translation("Description", this.AD_Language);
        row.appendCellChild((Component)new Label(original));
        changed = (String)gridTab.getValue("Description");
        this.descriptionTextbox = new Textbox(changed);
        this.descriptionTextbox.setRows(4);
        row.appendCellChild((Component)this.descriptionTextbox);
        this.descriptionTextbox.addEventListener("onChange", (EventListener)this);
        this.descriptionTextbox.addEventListener("onChanging", (EventListener)this);
        this.descriptionTextbox.setMaxlength(255);
        this.descriptionTextbox.setMultiline(true);
        this.descriptionTextbox.setHflex("1");
        html = this.diff(original, changed);
        this.descriptionDiff = new Cell();
        this.descriptionDiff.appendChild((Component)html);
        row.appendChild((Component)this.descriptionDiff);
        row = rows.newRow();
        row.appendCellChild((Component)new Label("Help"));
        original = this.field.get_Translation("Help", this.AD_Language);
        row.appendCellChild((Component)new Label(original));
        changed = (String)gridTab.getValue("Help");
        this.helpTextbox = new Textbox(changed);
        this.helpTextbox.setRows(8);
        row.appendCellChild((Component)this.helpTextbox);
        this.helpTextbox.addEventListener("onChange", (EventListener)this);
        this.helpTextbox.addEventListener("onChanging", (EventListener)this);
        this.helpTextbox.setMaxlength(2000);
        this.helpTextbox.setMultiline(true);
        this.helpTextbox.setHflex("1");
        html = this.diff(original, changed);
        this.helpDiff = new Cell();
        this.helpDiff.appendChild((Component)html);
        row.appendChild((Component)this.helpDiff);
        this.addEventListener("onOK", this);
    }

    private Html diff(String original, String changed) {
        if (original == null) {
            original = "";
        }
        if (changed == null) {
            changed = "";
        }
        LinkedList<diff_match_patch.Diff> diffs = this.diff.diff_main(original, changed);
        this.diff.diff_cleanupSemantic(diffs);
        Html html = new Html(this.diff.diff_prettyHtml(diffs));
        return html;
    }

    @Override
    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.detach();
        } else if (event.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.applyChanges();
            this.detach();
        } else if (event.getTarget() == this.nameTextbox) {
            if (event.getName().equals("onChanging")) {
                InputEvent inputEvent = (InputEvent)event;
                this.nameTimer.setAttribute(NEW_VALUE_ATTR, (Object)inputEvent.getValue());
                if (this.nameTimer.isRunning()) {
                    return;
                }
                this.nameTimer.start();
            } else {
                this.onNameChanged(this.nameTextbox.getText());
                if (this.nameTimer.isRunning()) {
                    this.nameTimer.stop();
                }
            }
        } else if (event.getTarget() == this.descriptionTextbox) {
            if (event.getName().equals("onChanging")) {
                InputEvent inputEvent = (InputEvent)event;
                this.descriptionTimer.setAttribute(NEW_VALUE_ATTR, (Object)inputEvent.getValue());
                if (this.descriptionTimer.isRunning()) {
                    return;
                }
                this.descriptionTimer.start();
            } else {
                this.onDescriptionChanged(this.descriptionTextbox.getText());
                if (this.descriptionTimer.isRunning()) {
                    this.descriptionTimer.stop();
                }
            }
        } else if (event.getTarget() == this.helpTextbox) {
            if (event.getName().equals("onChanging")) {
                InputEvent inputEvent = (InputEvent)event;
                this.helpTimer.setAttribute(NEW_VALUE_ATTR, (Object)inputEvent.getValue());
                if (this.helpTimer.isRunning()) {
                    return;
                }
                this.helpTimer.start();
            } else {
                this.onHelpChanged(this.helpTextbox.getText());
                if (this.helpTimer.isRunning()) {
                    this.helpTimer.stop();
                }
            }
        } else if (event.getTarget() == this.nameTimer) {
            this.onNameChanged((String)this.nameTimer.removeAttribute(NEW_VALUE_ATTR));
        } else if (event.getTarget() == this.descriptionTimer) {
            this.onDescriptionChanged((String)this.descriptionTimer.removeAttribute(NEW_VALUE_ATTR));
        } else if (event.getTarget() == this.helpTimer) {
            this.onHelpChanged((String)this.helpTimer.removeAttribute(NEW_VALUE_ATTR));
        } else {
            super.onEvent(event);
        }
    }

    private void onHelpChanged(String text) {
        this.helpDiff.getChildren().clear();
        Html html = this.diff(this.field.get_Translation("Help", this.AD_Language), text);
        this.helpDiff.appendChild((Component)html);
    }

    private void onDescriptionChanged(String text) {
        this.descriptionDiff.getChildren().clear();
        Html html = this.diff(this.field.get_Translation("Description", this.AD_Language), text);
        this.descriptionDiff.appendChild((Component)html);
    }

    private void onNameChanged(String text) {
        this.nameDiff.getChildren().clear();
        Html html = this.diff(this.field.get_Translation("Name", this.AD_Language), text);
        this.nameDiff.appendChild((Component)html);
    }

    private void applyChanges() {
        Component c = SessionManager.getAppDesktop().getActiveWindow();
        ADWindow adwindow = ADWindow.findADWindow(c);
        GridTab gridTab = adwindow.getADWindowContent().getActiveGridTab();
        String name = this.nameTextbox.getText();
        gridTab.setValue("Name", (Object)name);
        String description = this.descriptionTextbox.getText();
        gridTab.setValue("Description", (Object)description);
        String help = this.helpTextbox.getText();
        gridTab.setValue("Help", (Object)help);
        gridTab.dataSave(false);
    }

    @Override
    public Window.Mode getWindowMode() {
        return Window.Mode.HIGHLIGHTED;
    }
}

