/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.utilities;

import com.sfcommerce.jpaymentcomponent.exceptions.ConfigNotInitializedException;
import com.sfcommerce.jpaymentcomponent.exceptions.IncorrectParametersException;
import com.sfcommerce.jpaymentcomponent.utilities.Config;

public class HttpHeader {
    private static final String CONTENT_LENGTH = "Content-length: ";
    private static final String CONTENT_TYPE = "Content-type: application/x-www-form-urlencoded";
    private static final String POST = "POST ";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization: Basic ";
    private static final String HOST = "Host: ";
    private static final String HTTP = " HTTP/";
    private static final String HTTP_DEFAULT_VERSION = "1.1";
    private static final String LF = "\n";

    public static String build(String aPaymentServerURL, Integer aPort, Integer aBufferLength) throws IncorrectParametersException, ConfigNotInitializedException {
        StringBuffer myHeader = null;
        if (aPaymentServerURL == null) {
            throw new IncorrectParametersException("  ERROR(67) Configuration file is not readable.");
        }
        if (aPort <= 0) {
            throw new IncorrectParametersException("  ERROR(65) Error reading the configuration file.");
        }
        int begIndex = aPaymentServerURL.indexOf("//");
        int endIndex = aPaymentServerURL.indexOf("/", begIndex += 2);
        myHeader = new StringBuffer(POST);
        myHeader.append(aPaymentServerURL.substring(endIndex));
        myHeader.append(HTTP);
        if (Config.getProperty("HTTPVersion") == null || Config.getProperty("HTTPVersion").length() == 0) {
            myHeader.append(HTTP_DEFAULT_VERSION);
        } else {
            myHeader.append(Config.getProperty("HTTPVersion"));
        }
        myHeader.append(LF);
        myHeader.append(HOST);
        myHeader.append(aPaymentServerURL.substring(begIndex, endIndex));
        myHeader.append(":");
        myHeader.append(aPort.toString());
        myHeader.append(LF);
        myHeader.append(CONTENT_TYPE);
        myHeader.append(LF);
        myHeader.append(CONTENT_LENGTH);
        myHeader.append(aBufferLength.toString());
        myHeader.append(LF);
        myHeader.append(LF);
        return myHeader.toString();
    }
}

