/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.base.sso.ISSOPrincipalService;
import org.adempiere.base.sso.SSOUtils;
import org.adempiere.eclipse.equinox.http.servlet.BridgeServlet;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;

public class BridgeFilter
extends BridgeServlet
implements Filter {
    private static final long serialVersionUID = 1309373924501049438L;
    protected static CLogger log = CLogger.getCLogger(BridgeFilter.class);
    private ServletConfigAdaptor servletConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletConfig = new ServletConfigAdaptor(filterConfig);
        super.init();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (SSOUtils.isResourceRequest((HttpServletRequest)req, (boolean)false)) {
            super.process(req, resp, chain);
            return;
        }
        boolean isRedirectToLoginOnError = false;
        boolean isSSOEnable = MSysConfig.getBooleanValue((String)"ENABLE_SSO_OSGI_CONSOLE", (boolean)false);
        if (isSSOEnable) {
            ISSOPrincipalService m_SSOPrincipal = null;
            try {
                m_SSOPrincipal = SSOUtils.getSSOPrincipalService();
                if (m_SSOPrincipal != null) {
                    if (m_SSOPrincipal.hasAuthenticationCode(req, resp)) {
                        String currentUri = req.getRequestURL().toString();
                        m_SSOPrincipal.getAuthenticationToken(req, resp, "SSO_MODE_OSGI");
                        if (!resp.isCommitted()) {
                            resp.sendRedirect(currentUri);
                        }
                    } else if (!m_SSOPrincipal.isAuthenticated(req, resp)) {
                        m_SSOPrincipal.redirectForAuthentication(req, resp, "SSO_MODE_OSGI");
                        return;
                    }
                }
            }
            catch (Throwable exc) {
                log.log(Level.SEVERE, "Exception while authenticating: ", exc);
                if (m_SSOPrincipal != null) {
                    m_SSOPrincipal.removePrincipalFromSession(req);
                }
                if (isRedirectToLoginOnError) {
                    resp.sendRedirect("osgi/system/console/bundles");
                } else {
                    resp.setStatus(500);
                    response.setContentType("text/html");
                    response.getWriter().append(SSOUtils.getCreateErrorResponce((String)exc.getLocalizedMessage()));
                }
                return;
            }
        }
        super.process(req, resp, chain);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    private static class ServletConfigAdaptor
    implements ServletConfig {
        private FilterConfig filterConfig;

        public ServletConfigAdaptor(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public String getInitParameter(String arg0) {
            return this.filterConfig.getInitParameter(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.filterConfig.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.filterConfig.getServletContext();
        }

        public String getServletName() {
            return this.filterConfig.getFilterName();
        }
    }
}

