/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class CopyColumnsFromTable
extends SvrProcess {
    private int p_target_AD_Table_ID = 0;
    private int p_source_AD_Table_ID = 0;
    private int m_count = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Table_ID")) {
                    this.p_source_AD_Table_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_target_AD_Table_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MTable targetTable;
        MColumn[] targetColumns;
        if (this.p_target_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_target_AD_Table_ID);
        }
        if (this.p_source_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_source_AD_Table_ID);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Source AD_Table_ID=" + this.p_source_AD_Table_ID + ", Target AD_Table_ID=" + this.p_target_AD_Table_ID);
        }
        if ((targetColumns = (targetTable = new MTable(this.getCtx(), this.p_target_AD_Table_ID, this.get_TrxName())).getColumns(true)).length > 0) {
            throw new AdempiereSystemError(Msg.getMsg((Properties)Env.getCtx(), (String)"ErrorCopyColumns"));
        }
        MTable sourceTable = new MTable(this.getCtx(), this.p_source_AD_Table_ID, this.get_TrxName());
        MColumn[] sourceColumns = sourceTable.getColumns(true);
        int i = 0;
        while (i < sourceColumns.length) {
            M_Element element;
            String targetColumnName;
            MColumn colTarget = new MColumn(targetTable);
            PO.copyValues((PO)sourceColumns[i], (PO)colTarget);
            colTarget.setAD_Table_ID(targetTable.getAD_Table_ID());
            colTarget.setEntityType(targetTable.getEntityType());
            if (sourceColumns[i].getColumnName().equals(sourceTable.getTableName() + "_ID")) {
                targetColumnName = new String(targetTable.getTableName() + "_ID");
                colTarget.setColumnName(targetColumnName);
                element = M_Element.get((Properties)this.getCtx(), (String)targetColumnName);
                if (element == null) {
                    element = new M_Element(this.getCtx(), targetColumnName, targetTable.getEntityType(), this.get_TrxName());
                    if (targetColumnName.equalsIgnoreCase(targetTable.getTableName() + "_ID")) {
                        element.setColumnName(targetTable.getTableName() + "_ID");
                        element.setName(targetTable.getName());
                        element.setPrintName(targetTable.getName());
                    }
                    element.saveEx(this.get_TrxName());
                }
                colTarget.setAD_Element_ID(element.getAD_Element_ID());
                colTarget.setName(targetTable.getName());
                colTarget.setDescription(targetTable.getDescription());
                colTarget.setHelp(targetTable.getHelp());
            }
            if (sourceColumns[i].getColumnName().equals(sourceTable.getTableName() + "_UU")) {
                targetColumnName = new String(targetTable.getTableName() + "_UU");
                colTarget.setColumnName(targetColumnName);
                element = M_Element.get((Properties)this.getCtx(), (String)targetColumnName);
                if (element == null) {
                    element = new M_Element(this.getCtx(), targetColumnName, targetTable.getEntityType(), this.get_TrxName());
                    if (targetColumnName.equalsIgnoreCase(targetTable.getTableName() + "_UU")) {
                        element.setColumnName(targetTable.getTableName() + "_UU");
                        element.setName(targetTable.getTableName() + "_UU");
                        element.setPrintName(targetTable.getTableName() + "_UU");
                    }
                    element.saveEx(this.get_TrxName());
                }
                colTarget.setAD_Element_ID(element.getAD_Element_ID());
                colTarget.setName(targetTable.getName());
                colTarget.setDescription(targetTable.getDescription());
                colTarget.setHelp(targetTable.getHelp());
            }
            colTarget.setIsActive(sourceColumns[i].isActive());
            colTarget.saveEx(this.get_TrxName());
            ++this.m_count;
            ++i;
        }
        return "#" + this.m_count;
    }
}

