/*
 (c) 2007 Google Inc.
 @author Doug Ricket, Bjorn Brala (port to v3), others,

 @fileoverview Marker manager is an interface between the map and the user,
 designed to manage adding and removing many points when the viewport changes.
 <br /><br />
 <b>How it Works</b>:<br/> 
 The MarkerManager places its markers onto a grid, similar to the map tiles.
 When the user moves the viewport, it computes which grid cells have
 entered or left the viewport, and shows or hides all the markers in those
 cells.
 (If the users scrolls the viewport beyond the markers that are loaded,
 no markers will be visible until the <code>EVENT_moveend</code> 
 triggers an update.)
 In practical consequences, this allows 10,000 markers to be distributed over
 a large area, and as long as only 100-200 are visible in any given viewport,
 the user will see good performance corresponding to the 100 visible markers,
 rather than poor performance corresponding to the total 10,000 markers.
 Note that some code is optimized for speed over space,
 with the goal of accommodating thousands of markers.
*/
function MarkerManager(a,c){var b=this;b.map_=a;b.mapZoom_=a.getZoom();b.projectionHelper_=new ProjectionHelperOverlay(a);google.maps.event.addListener(b.projectionHelper_,"ready",function(){b.projection_=this.getProjection();b.initialize(a,c)})}
MarkerManager.prototype.initialize=function(a,c){var b=this;c=c||{};b.tileSize_=MarkerManager.DEFAULT_TILE_SIZE_;var d=a.mapTypes,e=1,f;for(f in d)"object"===typeof a.mapTypes.get(f)&&"number"===typeof a.mapTypes.get(f).maxZoom&&(d=a.mapTypes.get(f).maxZoom,d>e&&(e=d));b.maxZoom_=c.maxZoom||19;b.trackMarkers_=c.trackMarkers;b.show_=c.show||!0;c="number"===typeof c.borderPadding?c.borderPadding:MarkerManager.DEFAULT_BORDER_PADDING_;b.swPadding_=new google.maps.Size(-c,c);b.nePadding_=new google.maps.Size(c,
-c);b.borderPadding_=c;b.gridWidth_={};b.grid_={};b.grid_[b.maxZoom_]={};b.numMarkers_={};b.numMarkers_[b.maxZoom_]=0;google.maps.event.addListener(a,"dragend",function(){b.onMapMoveEnd_()});google.maps.event.addListener(a,"idle",function(){b.onMapMoveEnd_()});google.maps.event.addListener(a,"zoom_changed",function(){b.onMapMoveEnd_()});b.removeOverlay_=function(a){a.setMap(null);b.shownMarkers_--};b.addOverlay_=function(a){b.show_&&(a.setMap(b.map_),b.shownMarkers_++)};b.resetManager_();b.shownMarkers_=
0;b.shownBounds_=b.getMapGridBounds_();google.maps.event.trigger(b,"loaded")};MarkerManager.DEFAULT_TILE_SIZE_=1024;MarkerManager.DEFAULT_BORDER_PADDING_=100;MarkerManager.MERCATOR_ZOOM_LEVEL_ZERO_RANGE=256;MarkerManager.prototype.resetManager_=function(){for(var a=MarkerManager.MERCATOR_ZOOM_LEVEL_ZERO_RANGE,c=0;c<=this.maxZoom_;++c)this.grid_[c]={},this.numMarkers_[c]=0,this.gridWidth_[c]=Math.ceil(a/this.tileSize_),a<<=1};
MarkerManager.prototype.clearMarkers=function(){this.processAll_(this.shownBounds_,this.removeOverlay_);this.resetManager_()};MarkerManager.prototype.getTilePoint_=function(a,c,b){a=this.projectionHelper_.LatLngToPixel(a,c);return new google.maps.Point(Math.floor((a.x+b.width)/this.tileSize_),Math.floor((a.y+b.height)/this.tileSize_))};
MarkerManager.prototype.addMarkerBatch_=function(a,c,b){var d=this,e=a.getPosition();a.MarkerManager_minZoom=c;this.trackMarkers_&&google.maps.event.addListener(a,"changed",function(a,b,c){d.onMarkerMoved_(a,b,c)});for(e=this.getTilePoint_(e,b,new google.maps.Size(0,0,0,0));b>=c;b--)this.getGridCellCreate_(e.x,e.y,b).push(a),e.x>>=1,e.y>>=1};
MarkerManager.prototype.isGridPointVisible_=function(a){var c=this.shownBounds_.minY<=a.y&&a.y<=this.shownBounds_.maxY,b=this.shownBounds_.minX,d=b<=a.x&&a.x<=this.shownBounds_.maxX;!d&&0>b&&(d=this.gridWidth_[this.shownBounds_.z],d=b+d<=a.x&&a.x<=d-1);return c&&d};
MarkerManager.prototype.onMarkerMoved_=function(a,c,b){var d=this.maxZoom_,e=!1;c=this.getTilePoint_(c,d,new google.maps.Size(0,0,0,0));for(b=this.getTilePoint_(b,d,new google.maps.Size(0,0,0,0));0<=d&&(c.x!==b.x||c.y!==b.y);){var f=this.getGridCellNoCreate_(c.x,c.y,d);f&&this.removeFromArray_(f,a)&&this.getGridCellCreate_(b.x,b.y,d).push(a);d===this.mapZoom_&&(this.isGridPointVisible_(c)?this.isGridPointVisible_(b)||(this.removeOverlay_(a),e=!0):this.isGridPointVisible_(b)&&(this.addOverlay_(a),
e=!0));c.x>>=1;c.y>>=1;b.x>>=1;b.y>>=1;--d}e&&this.notifyListeners_()};MarkerManager.prototype.removeMarker=function(a){var c=this.maxZoom_,b=!1,d=a.getPosition();for(d=this.getTilePoint_(d,c,new google.maps.Size(0,0,0,0));0<=c;){var e=this.getGridCellNoCreate_(d.x,d.y,c);e&&this.removeFromArray_(e,a);c===this.mapZoom_&&this.isGridPointVisible_(d)&&(this.removeOverlay_(a),b=!0);d.x>>=1;d.y>>=1;--c}b&&this.notifyListeners_();this.numMarkers_[a.MarkerManager_minZoom]--};
MarkerManager.prototype.addMarkers=function(a,c,b){b=this.getOptMaxZoom_(b);for(var d=a.length-1;0<=d;d--)this.addMarkerBatch_(a[d],c,b);this.numMarkers_[c]+=a.length};MarkerManager.prototype.getOptMaxZoom_=function(a){return a||this.maxZoom_};MarkerManager.prototype.getMarkerCount=function(a){for(var c=0,b=0;b<=a;b++)c+=this.numMarkers_[b];return c};
MarkerManager.prototype.getMarker=function(a,c,b){var d=new google.maps.LatLng(a,c),e=this.getTilePoint_(d,b,new google.maps.Size(0,0,0,0));d=new google.maps.Marker({position:d});b=this.getGridCellNoCreate_(e.x,e.y,b);if(void 0!==b)for(e=0;e<b.length;e++)a===b[e].getPosition().lat()&&c===b[e].getPosition().lng()&&(d=b[e]);return d};
MarkerManager.prototype.addMarker=function(a,c,b){b=this.getOptMaxZoom_(b);this.addMarkerBatch_(a,c,b);var d=this.getTilePoint_(a.getPosition(),this.mapZoom_,new google.maps.Size(0,0,0,0));this.isGridPointVisible_(d)&&c<=this.shownBounds_.z&&this.shownBounds_.z<=b&&(this.addOverlay_(a),this.notifyListeners_());this.numMarkers_[c]++};function GridBounds(a){this.minX=Math.min(a[0].x,a[1].x);this.maxX=Math.max(a[0].x,a[1].x);this.minY=Math.min(a[0].y,a[1].y);this.maxY=Math.max(a[0].y,a[1].y)}
GridBounds.prototype.equals=function(a){return this.maxX===a.maxX&&this.maxY===a.maxY&&this.minX===a.minX&&this.minY===a.minY?!0:!1};GridBounds.prototype.containsPoint=function(a){return this.minX<=a.x&&this.maxX>=a.x&&this.minY<=a.y&&this.maxY>=a.y};MarkerManager.prototype.getGridCellCreate_=function(a,c,b){var d=this.grid_[b];0>a&&(a+=this.gridWidth_[b]);b=d[a];return b?(a=b[c])?a:b[c]=[]:(b=d[a]=[],b[c]=[])};
MarkerManager.prototype.getGridCellNoCreate_=function(a,c,b){var d=this.grid_[b];0>a&&(a+=this.gridWidth_[b]);return(a=d[a])?a[c]:void 0};MarkerManager.prototype.getGridBounds_=function(a,c,b,d){c=Math.min(c,this.maxZoom_);var e=a.getSouthWest();a=a.getNorthEast();b=this.getTilePoint_(e,c,b);d=this.getTilePoint_(a,c,d);var f=this.gridWidth_[c];if(a.lng()<e.lng()||d.x<b.x)b.x-=f;d.x-b.x+1>=f&&(b.x=0,d.x=f-1);e=new GridBounds([b,d]);e.z=c;return e};
MarkerManager.prototype.getMapGridBounds_=function(){return this.getGridBounds_(this.map_.getBounds(),this.mapZoom_,this.swPadding_,this.nePadding_)};MarkerManager.prototype.onMapMoveEnd_=function(){this.objectSetTimeout_(this,this.updateMarkers_,0)};MarkerManager.prototype.objectSetTimeout_=function(a,c,b){return window.setTimeout(function(){c.call(a)},b)};MarkerManager.prototype.visible=function(){return this.show_?!0:!1};MarkerManager.prototype.isHidden=function(){return!this.show_};
MarkerManager.prototype.show=function(){this.show_=!0;this.refresh()};MarkerManager.prototype.hide=function(){this.show_=!1;this.refresh()};MarkerManager.prototype.toggle=function(){this.show_=!this.show_;this.refresh()};MarkerManager.prototype.refresh=function(){0<this.shownMarkers_&&this.processAll_(this.shownBounds_,this.removeOverlay_);this.show_&&this.processAll_(this.shownBounds_,this.addOverlay_);this.notifyListeners_()};
MarkerManager.prototype.updateMarkers_=function(){this.mapZoom_=this.map_.getZoom();var a=this.getMapGridBounds_();a.equals(this.shownBounds_)&&a.z===this.shownBounds_.z||(a.z!==this.shownBounds_.z?(this.processAll_(this.shownBounds_,this.removeOverlay_),this.show_&&this.processAll_(a,this.addOverlay_)):(this.rectangleDiff_(this.shownBounds_,a,this.removeCellMarkers_),this.show_&&this.rectangleDiff_(a,this.shownBounds_,this.addCellMarkers_)),this.shownBounds_=a,this.notifyListeners_())};
MarkerManager.prototype.notifyListeners_=function(){google.maps.event.trigger(this,"changed",this.shownBounds_,this.shownMarkers_)};MarkerManager.prototype.processAll_=function(a,c){for(var b=a.minX;b<=a.maxX;b++)for(var d=a.minY;d<=a.maxY;d++)this.processCellMarkers_(b,d,a.z,c)};MarkerManager.prototype.processCellMarkers_=function(a,c,b,d){if(a=this.getGridCellNoCreate_(a,c,b))for(c=a.length-1;0<=c;c--)d(a[c])};
MarkerManager.prototype.removeCellMarkers_=function(a,c,b){this.processCellMarkers_(a,c,b,this.removeOverlay_)};MarkerManager.prototype.addCellMarkers_=function(a,c,b){this.processCellMarkers_(a,c,b,this.addOverlay_)};MarkerManager.prototype.rectangleDiff_=function(a,c,b){var d=this;d.rectangleDiffCoords_(a,c,function(c,f){b.apply(d,[c,f,a.z])})};
MarkerManager.prototype.rectangleDiffCoords_=function(a,c,b){var d=a.minX,e=a.minY,f=a.maxX;a=a.maxY;var l=c.minX,k=c.minY,m=c.maxX;c=c.maxY;var h,g;for(h=d;h<=f;h++){for(g=e;g<=a&&g<k;g++)b(h,g);for(g=Math.max(c+1,e);g<=a;g++)b(h,g)}for(g=Math.max(e,k);g<=Math.min(a,c);g++){for(h=Math.min(f+1,l)-1;h>=d;h--)b(h,g);for(h=Math.max(d,m+1);h<=f;h++)b(h,g)}};MarkerManager.prototype.removeFromArray_=function(a,c,b){for(var d=0,e=0;e<a.length;++e)if(a[e]===c||b&&a[e]===c)a.splice(e--,1),d++;return d};
function ProjectionHelperOverlay(a){this.setMap(a);this._map=a;this._X0=this._Y0=this._X1=this._Y1=this._zoom=-1}ProjectionHelperOverlay.prototype=new google.maps.OverlayView;ProjectionHelperOverlay.prototype.LngToX_=function(a){return 1+a/180};ProjectionHelperOverlay.prototype.LatToY_=function(a){a=Math.sin(a*Math.PI/180);return 1-.5/Math.PI*Math.log((1+a)/(1-a))};
ProjectionHelperOverlay.prototype.LatLngToPixel=function(a,c){this.getProjection().fromLatLngToDivPixel(a);return{x:~~(.5+this.LngToX_(a.lng())*(2<<c+6)),y:~~(.5+this.LatToY_(a.lat())*(2<<c+6))}};ProjectionHelperOverlay.prototype.draw=function(){this.ready||(this.ready=!0,google.maps.event.trigger(this,"ready"))};
