/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps.event;

import java.util.Map;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.LatLngBounds;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;

public class MapMoveEvent
extends Event {
    private final LatLng _latLng;
    private final LatLngBounds _bounds;

    public static final MapMoveEvent getMapMoveEvent(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)request);
        }
        Map data = request.getData();
        if (data == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{data, request});
        }
        double lat = ((Number)data.get("lat")).doubleValue();
        double lng = ((Number)data.get("lng")).doubleValue();
        double swlat = ((Number)data.get("swlat")).doubleValue();
        double swlng = ((Number)data.get("swlng")).doubleValue();
        double nelat = ((Number)data.get("nelat")).doubleValue();
        double nelng = ((Number)data.get("nelng")).doubleValue();
        return new MapMoveEvent(request.getCommand(), comp, new LatLng(lat, lng), new LatLngBounds(new LatLng(swlat, swlng), new LatLng(nelat, nelng)));
    }

    public MapMoveEvent(String name, Component target, LatLng latLng, LatLngBounds bounds) {
        super(name, target);
        this._latLng = latLng;
        this._bounds = bounds;
    }

    public MapMoveEvent(String name, Component target, double lat, double lng, double swlat, double swlng, double nelat, double nelng) {
        this(name, target, new LatLng(lat, lng), new LatLngBounds(new LatLng(swlat, swlng), new LatLng(nelat, nelng)));
    }

    public LatLng getLatLng() {
        return this._latLng;
    }

    public double getLat() {
        return this._latLng.getLatitude();
    }

    public double getLng() {
        return this._latLng.getLongitude();
    }

    public LatLngBounds getBounds() {
        return this._bounds;
    }

    public double getSwLat() {
        return this._bounds.getSouthWest().getLatitude();
    }

    public double getSwLng() {
        return this._bounds.getSouthWest().getLongitude();
    }

    public double getNeLat() {
        return this._bounds.getNorthEast().getLatitude();
    }

    public double getNeLng() {
        return this._bounds.getNorthEast().getLongitude();
    }
}

