/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.CalendarModel;
import org.zkoss.calendar.event.CalendarDataEvent;
import org.zkoss.calendar.event.CalendarDataListener;
import org.zkoss.io.Serializables;

public abstract class AbstractCalendarModel
implements CalendarModel,
Serializable {
    private static final long serialVersionUID = 20090317164525L;
    private transient List<CalendarDataListener> _listeners = new LinkedList<CalendarDataListener>();

    protected void fireEvent(int type, Date begin, Date end) {
        this.fireEvent(type, begin, end, null);
    }

    protected void fireEvent(int type, CalendarEvent e) {
        this.fireEvent(type, e, null);
    }

    protected void fireEvent(int type, Date begin, Date end, TimeZone timezone) {
        CalendarDataEvent evt = new CalendarDataEvent(this, type, begin, end, timezone);
        Iterator<CalendarDataListener> it = this._listeners.iterator();
        while (it.hasNext()) {
            it.next().onChange(evt);
        }
    }

    protected void fireEvent(int type, CalendarEvent e, TimeZone timezone) {
        CalendarDataEvent evt = new CalendarDataEvent(this, type, e, timezone);
        Iterator<CalendarDataListener> it = this._listeners.iterator();
        while (it.hasNext()) {
            it.next().onChange(evt);
        }
    }

    public void addCalendarDataListener(CalendarDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    public void removeCalendarDataListener(CalendarDataListener l) {
        this._listeners.remove(l);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<CalendarDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }
}

