/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.I_C_Currency;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.ConversionRateHelper;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

public class MatchInv2ndAcctSchemaTest
extends AbstractTestCase {
    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_1() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product1 = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MProduct product2 = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal usdToEur = new BigDecimal(31.526248754713);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, usdToEur);
        BigDecimal eurToUsd = cr.getDivideRate();
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur1 = new BigDecimal(1);
            BigDecimal qtyOrdered1 = new BigDecimal(2400);
            MOrderLine orderLine1 = this.createPurchaseOrderLine(order, 10, product1, qtyOrdered1, priceInEur1);
            BigDecimal priceInEur2 = new BigDecimal(2);
            BigDecimal qtyOrdered2 = new BigDecimal(2400);
            MOrderLine orderLine2 = this.createPurchaseOrderLine(order, 20, product2, qtyOrdered2, priceInEur2);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced1 = new BigDecimal(2400);
            MInvoiceLine invoiceLine1 = this.createAPInvoiceLine(invoice, orderLine1, qtyInvoiced1);
            BigDecimal qtyInvoiced2 = new BigDecimal(2400);
            MInvoiceLine invoiceLine2 = this.createAPInvoiceLine(invoice, orderLine2, qtyInvoiced2);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInvoice creditMemo = this.createAPCreditMemo(order, currentDate);
            BigDecimal qtyCredited1 = new BigDecimal(100);
            MInvoiceLine creditMemoLine1 = this.createAPCreditMemoLine(creditMemo, orderLine1, qtyCredited1);
            BigDecimal qtyCredited2 = new BigDecimal(100);
            MInvoiceLine creditMemoLine2 = this.createAPCreditMemoLine(creditMemo, orderLine2, qtyCredited2);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyInvoiced1.doubleValue(), qtyCredited1.doubleValue()));
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine1);
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine1);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine1);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, creditMemoLine1);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced2.doubleValue(), qtyCredited2.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine2);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine2);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine2);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, creditMemoLine2);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_2() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.CHEMICAL_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(31.526248754713);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(33.75);
            BigDecimal qtyOrdered = new BigDecimal(10);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInOut receipt1 = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(5);
            MInOutLine receiptLine1 = this.createMMReceiptLine(receipt1, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt1);
            this.postDocument((PO)receipt1);
            MInvoice invoice1 = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced = new BigDecimal(6);
            MInvoiceLine invoiceLine1 = this.createAPInvoiceLine(invoice1, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine1);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine1);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInvoice creditMemo = this.createAPCreditMemo(order, currentDate);
            BigDecimal qtyCredited = new BigDecimal(1);
            MInvoiceLine creditMemoLine = this.createAPCreditMemoLine(creditMemo, orderLine, qtyCredited);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced.doubleValue(), qtyCredited.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine1);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine1);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInOut receipt2 = this.createMMReceipt(order, currentDate);
            qtyDelivered = new BigDecimal(5);
            MInOutLine receiptLine2 = this.createMMReceiptLine(receipt2, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt2);
            this.postDocument((PO)receipt2);
            MInvoice invoice2 = this.createAPInvoice(order, currentDate);
            qtyInvoiced = new BigDecimal(5);
            MInvoiceLine invoiceLine2 = this.createAPInvoiceLine(invoice2, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_3() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.WOOD_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Purchase GBP " + System.currentTimeMillis());
        MCurrency britishPound = MCurrency.get((int)DictionaryIDs.C_Currency.GBP.id);
        priceList.setC_Currency_ID(britishPound.getC_Currency_ID());
        priceList.setPricePrecision(britishPound.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.PURCHASE_2001.id);
        plv.setValidFrom(date1);
        plv.saveEx();
        BigDecimal priceInPound = new BigDecimal(0.3023);
        MProductPrice pp = new MProductPrice(plv, product.getM_Product_ID(), priceInPound, priceInPound, Env.ZERO);
        pp.saveEx();
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        BigDecimal usdToPound1 = new BigDecimal(0.88917098794);
        MConversionRate crUsd1 = this.createConversionRate(britishPound.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, usdToPound1, false);
        BigDecimal poundToUsd1 = crUsd1.getMultiplyRate();
        BigDecimal usdToPound2 = new BigDecimal(0.84225);
        MConversionRate crUsd2 = this.createConversionRate(britishPound.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, usdToPound2, false);
        BigDecimal poundToUsd2 = crUsd2.getMultiplyRate();
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal poundToEuro1 = new BigDecimal(34.7186);
        MConversionRate crEur1 = this.createConversionRate(britishPound.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date1, poundToEuro1, true);
        BigDecimal poundToEuro2 = new BigDecimal(37.1828);
        MConversionRate crEur2 = this.createConversionRate(britishPound.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date2, poundToEuro2, true);
        try {
            MOrder order = this.createPurchaseOrder(bpartner, date1, priceList.getM_PriceList_ID(), C_ConversionType_ID);
            BigDecimal qtyOrdered = new BigDecimal(3);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInPound);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, date1);
            BigDecimal qtyInvoiced = new BigDecimal(3);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt = this.createMMReceipt(order, date2);
            BigDecimal qtyDelivered = Env.ONE;
            MInOutLine receiptLine = this.createMMReceiptLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, poundToEuro2, matchQty, receiptLine);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, poundToEuro1, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, poundToUsd2, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, poundToUsd1, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInvoice creditMemo = this.createAPCreditMemo(order, date2);
            BigDecimal qtyCredited = new BigDecimal(2);
            MInvoiceLine creditMemoLine = this.createAPCreditMemoLine(creditMemo, orderLine, qtyCredited);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced.doubleValue(), qtyCredited.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, poundToEuro1, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(euro, poundToEuro2, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, poundToUsd1, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(usd, poundToUsd2, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(crUsd1);
            this.deleteConversionRate(crUsd2);
            this.deleteConversionRate(crEur1);
            this.deleteConversionRate(crEur2);
            pp.deleteEx(true);
            plv.deleteEx(true);
            priceList.deleteEx(true);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_4() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.CHEMICAL_INC.id);
        MProduct product1 = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MProduct product2 = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id);
        MProduct product3 = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.PLUM_TREE.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -2);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date2 = new Timestamp(cal.getTimeInMillis());
        Timestamp date3 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30.212666962751);
        MConversionRate cr1 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(31.526248754713);
        MConversionRate cr2 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        BigDecimal eurToUsd3 = new BigDecimal(29.326631220545);
        MConversionRate cr3 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date3, eurToUsd3, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur1 = new BigDecimal(3.0);
            BigDecimal qtyOrdered1 = new BigDecimal(1000);
            MOrderLine orderLine1 = this.createPurchaseOrderLine(order, 10, product1, qtyOrdered1, priceInEur1);
            BigDecimal priceInEur2 = new BigDecimal(2.7);
            BigDecimal qtyOrdered2 = new BigDecimal(1000);
            MOrderLine orderLine2 = this.createPurchaseOrderLine(order, 20, product2, qtyOrdered2, priceInEur2);
            BigDecimal priceInEur3 = new BigDecimal(3.15);
            BigDecimal qtyOrdered3 = new BigDecimal(1000);
            MOrderLine orderLine3 = this.createPurchaseOrderLine(order, 30, product3, qtyOrdered3, priceInEur3);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, date1);
            BigDecimal qtyInvoiced1 = qtyOrdered1;
            MInvoiceLine invoiceLine1 = this.createAPInvoiceLine(invoice, orderLine1, qtyInvoiced1);
            BigDecimal qtyInvoiced2 = qtyOrdered2;
            MInvoiceLine invoiceLine2 = this.createAPInvoiceLine(invoice, orderLine2, qtyInvoiced2);
            BigDecimal qtyInvoiced3 = qtyOrdered3;
            MInvoiceLine invoiceLine3 = this.createAPInvoiceLine(invoice, orderLine3, qtyInvoiced3);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt = this.createMMReceipt(order, date2);
            BigDecimal qtyDelivered1 = new BigDecimal(800);
            MInOutLine receiptLine1 = this.createMMReceiptLine(receipt, orderLine1, qtyDelivered1);
            BigDecimal qtyDelivered2 = new BigDecimal(700);
            MInOutLine receiptLine2 = this.createMMReceiptLine(receipt, orderLine2, qtyDelivered2);
            BigDecimal qtyDelivered3 = new BigDecimal(1000);
            MInOutLine receiptLine3 = this.createMMReceiptLine(receipt, orderLine3, qtyDelivered3);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered1.doubleValue(), qtyInvoiced1.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine1);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd2, matchQty, receiptLine1);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered2.doubleValue(), qtyInvoiced2.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd2, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine3.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered3.doubleValue(), qtyInvoiced3.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine3);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine3);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd2, matchQty, receiptLine3);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine3);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInvoice creditMemo = this.createAPCreditMemo(order, date3);
            BigDecimal qtyCredited1 = new BigDecimal(200);
            MInvoiceLine creditMemoLine1 = this.createAPCreditMemoLine(creditMemo, orderLine1, qtyCredited1);
            BigDecimal qtyCredited2 = new BigDecimal(300);
            MInvoiceLine creditMemoLine2 = this.createAPCreditMemoLine(creditMemo, orderLine2, qtyCredited2);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine1.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced1.doubleValue(), qtyCredited1.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine1);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine1);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine1);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd3, matchQty, creditMemoLine1);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced2.doubleValue(), qtyCredited2.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine2);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine2);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine2);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd3, matchQty, creditMemoLine2);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
            this.deleteConversionRate(cr3);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_5() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.WOOD_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.870771861909);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.1875);
            BigDecimal qtyOrdered = new BigDecimal(2);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced = new BigDecimal(2);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(1);
            MInOutLine receiptLine = this.createMMReceiptLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInvoice creditMemo = this.createAPCreditMemo(order, currentDate);
            BigDecimal qtyCredited = new BigDecimal(1);
            MInvoiceLine creditMemoLine = this.createAPCreditMemoLine(creditMemo, orderLine, qtyCredited);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced.doubleValue(), qtyCredited.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_6() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.870771861909);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.1875);
            BigDecimal qtyOrdered = new BigDecimal(200);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced = new BigDecimal(200);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(100);
            MInOutLine receiptLine = this.createMMReceiptLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInvoice creditMemo = this.createAPCreditMemo(order, currentDate);
            BigDecimal qtyCredited = new BigDecimal(100);
            MInvoiceLine creditMemoLine = this.createAPCreditMemoLine(creditMemo, orderLine, qtyCredited);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced.doubleValue(), qtyCredited.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_7() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.CHEMICAL_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.870771861909);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.3742);
            BigDecimal qtyOrdered = new BigDecimal(45);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced = new BigDecimal(45);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(1);
            MInOutLine receiptLine = this.createMMReceiptLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInvoice creditMemo = this.createAPCreditMemo(order, currentDate);
            BigDecimal qtyCredited = new BigDecimal(44);
            MInvoiceLine creditMemoLine = this.createAPCreditMemoLine(creditMemo, orderLine, qtyCredited);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced.doubleValue(), qtyCredited.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testCreditMemoPosting_8() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.WOOD_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.870771861909);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.1875);
            BigDecimal qtyOrdered = new BigDecimal(2);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced = new BigDecimal(2);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt1 = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(1);
            MInOutLine receiptLine = this.createMMReceiptLine(receipt1, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt1);
            this.postDocument((PO)receipt1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInOut receipt2 = this.createMMReceipt(order, currentDate);
            qtyDelivered = new BigDecimal(1);
            receiptLine = this.createMMReceiptLine(receipt2, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt2);
            this.postDocument((PO)receipt2);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            this.reverseDocument((PO)receipt2);
            MInOut receipt3 = new MInOut(Env.getCtx(), receipt2.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)receipt3);
            ArrayList<MMatchInv> miList0 = new ArrayList<MMatchInv>();
            MMatchInv[] mMatchInvArray = miList;
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                mi.load(this.getTrxName(), new String[0]);
                miList0.add(new MMatchInv(Env.getCtx(), mi.getReversal_ID(), this.getTrxName()));
                ++n2;
            }
            MMatchInv[] miList2 = new MMatchInv[miList0.size()];
            ArrayList<PostingLine> notInvoicedReceiptsLineList2 = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList2 = new ArrayList<PostingLine>();
            for (PostingLine notInvoicedReceiptsLine : notInvoicedReceiptsLineList) {
                notInvoicedReceiptsLineList2.add(new PostingLine(notInvoicedReceiptsLine.currency, notInvoicedReceiptsLine.amtAcctCr, notInvoicedReceiptsLine.amtAcctDr));
            }
            for (PostingLine inventoryClearingLine : inventoryClearingLineList) {
                inventoryClearingLineList2.add(new PostingLine(inventoryClearingLine.currency, inventoryClearingLine.amtAcctCr, inventoryClearingLine.amtAcctDr));
            }
            this.testMatchInvoicePosting(ass, miList0.toArray(miList2), notInvoicedReceiptsLineList2, inventoryClearingLineList2);
            MInvoice creditMemo = this.createAPCreditMemo(order, currentDate);
            BigDecimal qtyCredited = new BigDecimal(1);
            MInvoiceLine creditMemoLine = this.createAPCreditMemoLine(creditMemo, orderLine, qtyCredited);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyInvoiced.doubleValue(), qtyCredited.doubleValue()));
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, creditMemoLine);
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            inventoryClearingLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatReceiptPosting_1() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.CHEMICAL_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.870771861909);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.3742);
            BigDecimal qtyOrdered = new BigDecimal(1200);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice1 = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced1 = new BigDecimal(1156);
            MInvoiceLine invoiceLine1 = this.createAPInvoiceLine(invoice1, orderLine, qtyInvoiced1);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MInvoice invoice2 = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced2 = new BigDecimal(44);
            MInvoiceLine invoiceLine2 = this.createAPInvoiceLine(invoice2, orderLine, qtyInvoiced2);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MInOut receipt = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(1200);
            MInOutLine receiptLine = this.createMMReceiptLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced1.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced2.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatReceiptPosting_2() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.WOOD_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30.870771861909);
        MConversionRate cr1 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(31.326259863856);
        MConversionRate cr2 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.3742);
            BigDecimal qtyOrdered = new BigDecimal(1200);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, date1);
            BigDecimal qtyInvoiced = new BigDecimal(1200);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt1 = this.createMMReceipt(order, date1);
            BigDecimal qtyDelivered1 = new BigDecimal(1156);
            MInOutLine receiptLine1 = this.createMMReceiptLine(receipt1, orderLine, qtyDelivered1);
            this.completeDocument((PO)receipt1);
            this.postDocument((PO)receipt1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered1.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine1);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd1, matchQty, receiptLine1);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInOut receipt2 = this.createMMReceipt(order, date2);
            BigDecimal qtyDelivered2 = new BigDecimal(44);
            MInOutLine receiptLine2 = this.createMMReceiptLine(receipt2, orderLine, qtyDelivered2);
            this.completeDocument((PO)receipt2);
            this.postDocument((PO)receipt2);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered2.doubleValue(), qtyInvoiced.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd2, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatReceiptPosting_3() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.870771861909);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.1875);
            BigDecimal qtyOrdered = new BigDecimal(2);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced = new BigDecimal(2);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt1 = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered1 = new BigDecimal(1);
            MInOutLine receiptLine1 = this.createMMReceiptLine(receipt1, orderLine, qtyDelivered1);
            this.completeDocument((PO)receipt1);
            this.postDocument((PO)receipt1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered1.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine1);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine1);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInOut receipt2 = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered2 = new BigDecimal(1);
            MInOutLine receiptLine2 = this.createMMReceiptLine(receipt2, orderLine, qtyDelivered2);
            this.completeDocument((PO)receipt2);
            this.postDocument((PO)receipt2);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered2.doubleValue(), qtyInvoiced.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            this.reverseDocument((PO)receipt2);
            MInOut receipt3 = new MInOut(Env.getCtx(), receipt2.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)receipt3);
            ArrayList<MMatchInv> miList0 = new ArrayList<MMatchInv>();
            MMatchInv[] mMatchInvArray = miList;
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                mi.load(this.getTrxName(), new String[0]);
                miList0.add(new MMatchInv(Env.getCtx(), mi.getReversal_ID(), this.getTrxName()));
                ++n2;
            }
            MMatchInv[] miList2 = new MMatchInv[miList0.size()];
            ArrayList<PostingLine> notInvoicedReceiptsLineList2 = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList2 = new ArrayList<PostingLine>();
            for (PostingLine notInvoicedReceiptsLine : notInvoicedReceiptsLineList) {
                notInvoicedReceiptsLineList2.add(new PostingLine(notInvoicedReceiptsLine.currency, notInvoicedReceiptsLine.amtAcctCr, notInvoicedReceiptsLine.amtAcctDr));
            }
            for (PostingLine inventoryClearingLine : inventoryClearingLineList) {
                inventoryClearingLineList2.add(new PostingLine(inventoryClearingLine.currency, inventoryClearingLine.amtAcctCr, inventoryClearingLine.amtAcctDr));
            }
            this.testMatchInvoicePosting(ass, miList0.toArray(miList2), notInvoicedReceiptsLineList2, inventoryClearingLineList2);
            MInOut receipt4 = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered4 = new BigDecimal(1);
            MInOutLine receiptLine4 = this.createMMReceiptLine(receipt4, orderLine, qtyDelivered4);
            this.completeDocument((PO)receipt4);
            this.postDocument((PO)receipt4);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine4.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered4.doubleValue(), qtyInvoiced.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine4);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd, matchQty, receiptLine4);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatReceiptPosting_4() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.WOOD_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30.870771861909);
        MConversionRate cr1 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(31.326259863856);
        MConversionRate cr2 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MOrder order = this.createPurchaseOrder(bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal priceInEur = new BigDecimal(0.1875);
            BigDecimal qtyOrdered = new BigDecimal(2);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInEur);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, date1);
            BigDecimal qtyInvoiced = new BigDecimal(2);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt1 = this.createMMReceipt(order, date1);
            BigDecimal qtyDelivered1 = new BigDecimal(1);
            MInOutLine receiptLine1 = this.createMMReceiptLine(receipt1, orderLine, qtyDelivered1);
            this.completeDocument((PO)receipt1);
            this.postDocument((PO)receipt1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered1.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine1);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd1, matchQty, receiptLine1);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInOut receipt2 = this.createMMReceipt(order, date1);
            BigDecimal qtyDelivered2 = new BigDecimal(1);
            MInOutLine receiptLine2 = this.createMMReceiptLine(receipt2, orderLine, qtyDelivered2);
            this.completeDocument((PO)receipt2);
            this.postDocument((PO)receipt2);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered2.doubleValue(), qtyInvoiced.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd1, matchQty, receiptLine2);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            this.reverseDocument((PO)receipt2);
            MInOut receipt3 = new MInOut(Env.getCtx(), receipt2.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)receipt3);
            ArrayList<MMatchInv> miList0 = new ArrayList<MMatchInv>();
            MMatchInv[] mMatchInvArray = miList;
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                mi.load(this.getTrxName(), new String[0]);
                miList0.add(new MMatchInv(Env.getCtx(), mi.getReversal_ID(), this.getTrxName()));
                ++n2;
            }
            MMatchInv[] miList2 = new MMatchInv[miList0.size()];
            ArrayList<PostingLine> notInvoicedReceiptsLineList2 = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList2 = new ArrayList<PostingLine>();
            for (PostingLine notInvoicedReceiptsLine : notInvoicedReceiptsLineList) {
                notInvoicedReceiptsLineList2.add(new PostingLine(notInvoicedReceiptsLine.currency, notInvoicedReceiptsLine.amtAcctCr, notInvoicedReceiptsLine.amtAcctDr));
            }
            for (PostingLine inventoryClearingLine : inventoryClearingLineList) {
                inventoryClearingLineList2.add(new PostingLine(inventoryClearingLine.currency, inventoryClearingLine.amtAcctCr, inventoryClearingLine.amtAcctDr));
            }
            this.testMatchInvoicePosting(ass, miList0.toArray(miList2), notInvoicedReceiptsLineList2, inventoryClearingLineList2);
            MInOut receipt4 = this.createMMReceipt(order, date2);
            BigDecimal qtyDelivered4 = new BigDecimal(1);
            MInOutLine receiptLine4 = this.createMMReceiptLine(receipt4, orderLine, qtyDelivered4);
            this.completeDocument((PO)receipt4);
            this.postDocument((PO)receipt4);
            miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine4.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered4.doubleValue(), qtyInvoiced.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, Env.ONE, matchQty, receiptLine4);
            accountedAmtCr = this.getAccountedAmount(euro, Env.ONE, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, eurToUsd2, matchQty, receiptLine4);
            accountedAmtCr = this.getAccountedAmount(usd, eurToUsd1, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            inventoryClearingLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatReceiptPosting_5() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.CHEMICAL_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Purchase GBP " + System.currentTimeMillis());
        MCurrency britishPound = MCurrency.get((int)DictionaryIDs.C_Currency.GBP.id);
        priceList.setC_Currency_ID(britishPound.getC_Currency_ID());
        priceList.setPricePrecision(britishPound.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.PURCHASE_2001.id);
        plv.setValidFrom(currentDate);
        plv.saveEx();
        BigDecimal priceInPound = new BigDecimal(23.32);
        MProductPrice pp = new MProductPrice(plv, product.getM_Product_ID(), priceInPound, priceInPound, Env.ZERO);
        pp.saveEx();
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        BigDecimal poundToUsd = new BigDecimal(0.676234);
        MConversionRate crUsd = this.createConversionRate(britishPound.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, currentDate, poundToUsd);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal poundToEuro = new BigDecimal(22.5062);
        MConversionRate crEur = this.createConversionRate(britishPound.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, poundToEuro);
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, priceList.getM_PriceList_ID(), C_ConversionType_ID);
            BigDecimal qtyOrdered = new BigDecimal(500);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInPound);
            this.completeDocument((PO)order);
            MInOut receipt = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered = new BigDecimal(500);
            MInOutLine receiptLine = this.createMMReceiptLine(receipt, orderLine, qtyDelivered);
            this.completeDocument((PO)receipt);
            this.postDocument((PO)receipt);
            MInvoice invoice1 = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced1 = new BigDecimal(250);
            MInvoiceLine invoiceLine1 = this.createAPInvoiceLine(invoice1, orderLine, qtyInvoiced1);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced1.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, poundToEuro, matchQty, receiptLine);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, poundToEuro, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, poundToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, poundToUsd, matchQty, invoiceLine1);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            MInvoice invoice2 = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced2 = new BigDecimal(250);
            MInvoiceLine invoiceLine2 = this.createAPInvoiceLine(invoice2, orderLine, qtyInvoiced2);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine2.get_ID(), (String)this.getTrxName());
            notInvoicedReceiptsLineList = new ArrayList();
            inventoryClearingLineList = new ArrayList();
            matchQty = new BigDecimal(Math.min(qtyDelivered.doubleValue(), qtyInvoiced2.doubleValue()));
            accountedAmtDr = this.getAccountedAmount(euro, poundToEuro, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(euro, poundToEuro, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(euro.getStdPrecision(), RoundingMode.HALF_UP);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, Env.ZERO, currBalAmt));
            accountedAmtDr = this.getAccountedAmount(usd, poundToUsd, matchQty, receiptLine);
            accountedAmtCr = this.getAccountedAmount(usd, poundToUsd, matchQty, invoiceLine2);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, Env.ZERO, currBalAmt));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(crUsd);
            this.deleteConversionRate(crEur);
            pp.deleteEx(true);
            plv.deleteEx(true);
            priceList.deleteEx(true);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testMatReceiptPostingWithDiffCurrencyPrecision() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.CHEMICAL_INC.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Purchase JPY " + System.currentTimeMillis());
        MCurrency japaneseYen = MCurrency.get((int)DictionaryIDs.C_Currency.JPY.id);
        priceList.setC_Currency_ID(japaneseYen.getC_Currency_ID());
        priceList.setPricePrecision(japaneseYen.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.PURCHASE_2001.id);
        plv.setValidFrom(currentDate);
        plv.saveEx();
        BigDecimal priceInYen = new BigDecimal(65);
        MProductPrice pp = new MProductPrice(plv, product.getM_Product_ID(), priceInYen, priceInYen, Env.ZERO);
        pp.saveEx();
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        BigDecimal yenToUsd = new BigDecimal(0.00956427);
        MConversionRate crUsd = this.createConversionRate(japaneseYen.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, currentDate, yenToUsd);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal yenToEuro = new BigDecimal(0.29);
        MConversionRate crEur = this.createConversionRate(japaneseYen.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, currentDate, yenToEuro);
        try {
            MOrder order = this.createPurchaseOrder(bpartner, currentDate, priceList.getM_PriceList_ID(), C_ConversionType_ID);
            BigDecimal qtyOrdered = new BigDecimal(5);
            MOrderLine orderLine = this.createPurchaseOrderLine(order, 10, product, qtyOrdered, priceInYen);
            this.completeDocument((PO)order);
            MInvoice invoice = this.createAPInvoice(order, currentDate);
            BigDecimal qtyInvoiced = new BigDecimal(5);
            MInvoiceLine invoiceLine = this.createAPInvoiceLine(invoice, orderLine, qtyInvoiced);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInOut receipt1 = this.createMMReceipt(order, currentDate);
            BigDecimal qtyDelivered1 = new BigDecimal(5);
            MInOutLine receiptLine1 = this.createMMReceiptLine(receipt1, orderLine, qtyDelivered1);
            this.completeDocument((PO)receipt1);
            this.postDocument((PO)receipt1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MMatchInv[] miList = MMatchInv.getInOutLine((Properties)Env.getCtx(), (int)receiptLine1.get_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> notInvoicedReceiptsLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList = new ArrayList<PostingLine>();
            BigDecimal matchQty = new BigDecimal(Math.min(qtyDelivered1.doubleValue(), qtyInvoiced.doubleValue()));
            BigDecimal accountedAmtDr = this.getAccountedAmount(euro, yenToEuro, matchQty, receiptLine1);
            BigDecimal accountedAmtCr = this.getAccountedAmount(euro, yenToEuro, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(euro, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(euro, Env.ZERO, accountedAmtCr));
            accountedAmtDr = this.getAccountedAmount(usd, yenToUsd, matchQty, receiptLine1);
            accountedAmtCr = this.getAccountedAmount(usd, yenToUsd, matchQty, invoiceLine);
            notInvoicedReceiptsLineList.add(new PostingLine(usd, accountedAmtDr, Env.ZERO));
            inventoryClearingLineList.add(new PostingLine(usd, Env.ZERO, accountedAmtCr));
            this.testMatchInvoicePosting(ass, miList, notInvoicedReceiptsLineList, inventoryClearingLineList);
            this.reverseDocument((PO)receipt1);
            MInOut receipt2 = new MInOut(Env.getCtx(), receipt1.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)receipt2);
            ArrayList<MMatchInv> miList0 = new ArrayList<MMatchInv>();
            MMatchInv[] mMatchInvArray = miList;
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                mi.load(this.getTrxName(), new String[0]);
                miList0.add(new MMatchInv(Env.getCtx(), mi.getReversal_ID(), this.getTrxName()));
                ++n2;
            }
            MMatchInv[] miList2 = new MMatchInv[miList0.size()];
            ArrayList<PostingLine> notInvoicedReceiptsLineList2 = new ArrayList<PostingLine>();
            ArrayList<PostingLine> inventoryClearingLineList2 = new ArrayList<PostingLine>();
            for (PostingLine notInvoicedReceiptsLine : notInvoicedReceiptsLineList) {
                notInvoicedReceiptsLineList2.add(new PostingLine(notInvoicedReceiptsLine.currency, notInvoicedReceiptsLine.amtAcctCr, notInvoicedReceiptsLine.amtAcctDr));
            }
            for (PostingLine inventoryClearingLine : inventoryClearingLineList) {
                inventoryClearingLineList2.add(new PostingLine(inventoryClearingLine.currency, inventoryClearingLine.amtAcctCr, inventoryClearingLine.amtAcctDr));
            }
            this.testMatchInvoicePosting(ass, miList0.toArray(miList2), notInvoicedReceiptsLineList2, inventoryClearingLineList2);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(crUsd);
            this.deleteConversionRate(crEur);
            pp.deleteEx(true);
            plv.deleteEx(true);
            priceList.deleteEx(true);
        }
    }

    private MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate) {
        return this.createConversionRate(C_Currency_ID, C_Currency_ID_To, C_ConversionType_ID, date, rate, true);
    }

    private MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate, boolean isMultiplyRate) {
        return ConversionRateHelper.createConversionRate(C_Currency_ID, C_Currency_ID_To, C_ConversionType_ID, date, rate, isMultiplyRate);
    }

    private void deleteConversionRate(MConversionRate cr) {
        ConversionRateHelper.deleteConversionRate(cr);
    }

    private MOrder createPurchaseOrder(MBPartner bpartner, Timestamp date, int M_PriceList_ID, int C_ConversionType_ID) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDateOrdered(date);
        order.setDateAcct(date);
        order.setM_PriceList_ID(M_PriceList_ID);
        order.setC_ConversionType_ID(C_ConversionType_ID);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        return order;
    }

    private MOrderLine createPurchaseOrderLine(MOrder order, int line, MProduct product, BigDecimal qty, BigDecimal price) {
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(line);
        orderLine.setProduct(product);
        orderLine.setQty(qty);
        orderLine.setPrice(price);
        orderLine.saveEx();
        return orderLine;
    }

    private void completeDocument(PO po) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)"CO");
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"CO", (Object)docStatus, (String)("CO != " + docStatus));
    }

    private void reverseDocument(PO po) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)"RC");
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"RE", (Object)docStatus, (String)("RE != " + docStatus));
    }

    private void postDocument(PO po) {
        if (!po.get_ValueAsBoolean("Posted")) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)po.getAD_Client_ID(), (int)po.get_Table_ID(), (int)po.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)po.get_ValueAsBoolean("Posted"));
    }

    private MInvoice createAPInvoice(MOrder order, Timestamp date) {
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setOrder(order);
        invoice.setDateAcct(date);
        invoice.setSalesRep_ID(order.getSalesRep_ID());
        invoice.setC_BPartner_ID(order.getBill_BPartner_ID());
        invoice.setC_BPartner_Location_ID(order.getBill_Location_ID());
        invoice.setAD_User_ID(order.getBill_User_ID());
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        return invoice;
    }

    private MInvoiceLine createAPInvoiceLine(MInvoice invoice, MOrderLine orderLine, BigDecimal qty) {
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setC_OrderLine_ID(orderLine.get_ID());
        invoiceLine.setLine(orderLine.getLine());
        invoiceLine.setProduct(orderLine.getProduct());
        invoiceLine.setQty(qty);
        invoiceLine.setPrice(orderLine.getPriceActual());
        invoiceLine.saveEx();
        return invoiceLine;
    }

    private MInvoice createAPCreditMemo(MOrder order, Timestamp date) {
        MInvoice creditMemo = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        creditMemo.setOrder(order);
        creditMemo.setDateAcct(date);
        creditMemo.setSalesRep_ID(order.getSalesRep_ID());
        creditMemo.setC_BPartner_ID(order.getBill_BPartner_ID());
        creditMemo.setC_BPartner_Location_ID(order.getBill_Location_ID());
        creditMemo.setAD_User_ID(order.getBill_User_ID());
        creditMemo.setC_DocTypeTarget_ID("APC");
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        return creditMemo;
    }

    private MInvoiceLine createAPCreditMemoLine(MInvoice creditMemo, MOrderLine orderLine, BigDecimal qty) {
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setC_OrderLine_ID(orderLine.get_ID());
        creditMemoLine.setLine(orderLine.getLine());
        creditMemoLine.setProduct(orderLine.getProduct());
        creditMemoLine.setQty(qty);
        creditMemoLine.setPrice(orderLine.getPriceActual());
        creditMemoLine.saveEx();
        return creditMemoLine;
    }

    private MInOut createMMReceipt(MOrder order, Timestamp date) {
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, date);
        receipt.saveEx();
        return receipt;
    }

    private MInOutLine createMMReceiptLine(MInOut receipt, MOrderLine orderLine, BigDecimal qty) {
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(orderLine.getLine());
        receiptLine.setProduct(orderLine.getProduct());
        receiptLine.setQty(qty);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        return receiptLine;
    }

    private void testMatchInvoicePosting(MAcctSchema[] ass, MMatchInv[] miList, ArrayList<PostingLine> notInvoicedReceiptsLineList, ArrayList<PostingLine> inventoryClearingLineList) {
        Assertions.assertTrue((miList.length > 0 ? 1 : 0) != 0);
        if (notInvoicedReceiptsLineList == null) {
            notInvoicedReceiptsLineList = new ArrayList();
        }
        if (inventoryClearingLineList == null) {
            inventoryClearingLineList = new ArrayList();
        }
        HashMap<Integer, BigDecimal> totalNIRAmtByCurrencyId = new HashMap<Integer, BigDecimal>();
        for (PostingLine notInvoicedReceiptsLine : notInvoicedReceiptsLineList) {
            BigDecimal totalAmt = (BigDecimal)totalNIRAmtByCurrencyId.get(notInvoicedReceiptsLine.currency.get_ID());
            if (totalAmt == null) {
                totalAmt = Env.ZERO;
            }
            totalAmt = totalAmt.add(notInvoicedReceiptsLine.amtAcctDr).subtract(notInvoicedReceiptsLine.amtAcctCr);
            totalNIRAmtByCurrencyId.put(notInvoicedReceiptsLine.currency.get_ID(), totalAmt);
        }
        HashMap<Integer, BigDecimal> totalInvClrAmtByCurrencyId = new HashMap<Integer, BigDecimal>();
        for (PostingLine inventoryClearingLine : inventoryClearingLineList) {
            BigDecimal totalAmt = (BigDecimal)totalInvClrAmtByCurrencyId.get(inventoryClearingLine.currency.get_ID());
            if (totalAmt == null) {
                totalAmt = Env.ZERO;
            }
            totalAmt = totalAmt.add(inventoryClearingLine.amtAcctDr).subtract(inventoryClearingLine.amtAcctCr);
            totalInvClrAmtByCurrencyId.put(inventoryClearingLine.currency.get_ID(), totalAmt);
        }
        MMatchInv[] mMatchInvArray = miList;
        int n = miList.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchInv mi = mMatchInvArray[n2];
            this.postDocument((PO)mi);
            MAcctSchema[] mAcctSchemaArray = ass;
            int n3 = ass.length;
            int n4 = 0;
            while (n4 < n3) {
                MAcctSchema as = mAcctSchemaArray[n4];
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
                MAccount acctNIR = doc.getAccount(51, as);
                ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
                MAccount acctInvClr = pc.getAccount(10, as);
                BigDecimal totalNIRAmtAcct = Env.ZERO;
                BigDecimal totalInvClrAmtAcct = Env.ZERO;
                Query query = MFactAcct.createRecordIdQuery((int)472, (int)mi.get_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
                List factAccts = query.list();
                for (MFactAcct fa : factAccts) {
                    if (acctNIR.getAccount_ID() == fa.getAccount_ID()) {
                        totalNIRAmtAcct = totalNIRAmtAcct.add(fa.getAmtAcctDr()).subtract(fa.getAmtAcctCr());
                        continue;
                    }
                    if (acctInvClr.getAccount_ID() != fa.getAccount_ID()) continue;
                    totalInvClrAmtAcct = totalInvClrAmtAcct.add(fa.getAmtAcctDr()).subtract(fa.getAmtAcctCr());
                }
                BigDecimal totalAmtExpected = (BigDecimal)totalNIRAmtByCurrencyId.get(as.getC_Currency_ID());
                if (totalAmtExpected != null && totalAmtExpected.compareTo(totalNIRAmtAcct) == 0) {
                    totalNIRAmtByCurrencyId.remove(as.getC_Currency_ID());
                }
                if ((totalAmtExpected = (BigDecimal)totalInvClrAmtByCurrencyId.get(as.getC_Currency_ID())) != null && totalAmtExpected.compareTo(totalInvClrAmtAcct) == 0) {
                    totalInvClrAmtByCurrencyId.remove(as.getC_Currency_ID());
                }
                ++n4;
            }
            ++n2;
        }
        Assertions.assertTrue((boolean)totalNIRAmtByCurrencyId.isEmpty(), (String)totalNIRAmtByCurrencyId.toString());
        Assertions.assertTrue((boolean)totalInvClrAmtByCurrencyId.isEmpty(), (String)totalInvClrAmtByCurrencyId.toString());
    }

    private BigDecimal getSourceAmount(I_C_Currency currency, BigDecimal price, BigDecimal qty) {
        return price.multiply(qty).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
    }

    private BigDecimal getAccountedAmount(MCurrency currency, BigDecimal multiplyRate, BigDecimal miQty, MInOutLine iol) {
        BigDecimal sourceAmt = this.getSourceAmount(iol.getParent().getC_Order().getC_Currency(), iol.getC_OrderLine().getPriceActual(), iol.getMovementQty());
        BigDecimal accountedAmt = sourceAmt.multiply(multiplyRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
        BigDecimal multiplier = miQty.divide(iol.getMovementQty(), 12, RoundingMode.HALF_UP);
        return accountedAmt.multiply(multiplier).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
    }

    private BigDecimal getAccountedAmount(MCurrency currency, BigDecimal multiplyRate, BigDecimal miQty, MInvoiceLine il) {
        BigDecimal sourceAmt = this.getSourceAmount(il.getParent().getC_Order().getC_Currency(), il.getC_OrderLine().getPriceActual(), il.getQtyInvoiced());
        BigDecimal accountedAmt = sourceAmt.multiply(multiplyRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
        BigDecimal multiplier = miQty.divide(il.getQtyInvoiced(), 12, RoundingMode.HALF_UP);
        return accountedAmt.multiply(multiplier).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
    }

    private class PostingLine {
        private MCurrency currency;
        private BigDecimal amtAcctDr;
        private BigDecimal amtAcctCr;

        private PostingLine(MCurrency currency, BigDecimal amtAcctDr, BigDecimal amtAcctCr) {
            this.currency = currency;
            this.amtAcctDr = amtAcctDr;
            this.amtAcctCr = amtAcctCr;
        }

        public String toString() {
            return this.currency.toString() + ", " + String.valueOf(this.amtAcctDr) + ", " + String.valueOf(this.amtAcctCr) + "\n";
        }
    }
}

