/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class GetBOMFunctionsTest
extends AbstractTestCase {
    private static final int PRODUCT_PRICE_PATIOSET_STANDARD_2003 = 200084;

    @Test
    public void test_getBOMFunctions() throws Exception {
        String trxName = this.getTrxName();
        BigDecimal price = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bompricestd(145, 104) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(500.0).compareTo(price) == 0 ? 1 : 0) != 0, (String)"Unexpected direct bompricestd");
        price = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bompricelist(145, 104) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(520.0).compareTo(price) == 0 ? 1 : 0) != 0, (String)"Unexpected direct bompricelist");
        price = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bompricelimit(145, 104) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(496.0).compareTo(price) == 0 ? 1 : 0) != 0, (String)"Unexpected direct bompricelimit");
        MProductPrice productPrice = new MProductPrice(Env.getCtx(), 200084, trxName);
        productPrice.setIsActive(false);
        productPrice.saveEx();
        price = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bompricestd(145, 104) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(225.0).compareTo(price) == 0 ? 1 : 0) != 0, (String)"Unexpected indirect bompricestd");
        price = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bompricelist(145, 104) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(220.0).compareTo(price) == 0 ? 1 : 0) != 0, (String)"Unexpected indirect bompricelist");
        price = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bompricelimit(145, 104) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(180.0).compareTo(price) == 0 ? 1 : 0) != 0, (String)"Unexpected indirect bompricelimit");
        BigDecimal qty = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bomqtyavailable(145, 103, 0) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(0.0).compareTo(qty) == 0 ? 1 : 0) != 0, (String)"Unexpected direct bomqtyavailable");
        qty = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bomqtyonhand(145, 103, 0) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(0.0).compareTo(qty) == 0 ? 1 : 0) != 0, (String)"Unexpected direct bomqtyonhand");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.PATIOSET.id, trxName);
        product.setIsStocked(false);
        product.saveEx();
        qty = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bomqtyavailable(145, 103, 0) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(12.0).compareTo(qty) == 0 ? 1 : 0) != 0, (String)"Unexpected indirect bomqtyavailable");
        qty = DB.getSQLValueBDEx((String)trxName, (String)"SELECT bomqtyonhand(145, 103, 0) FROM Dual", (Object[])new Object[0]);
        Assertions.assertTrue((BigDecimal.valueOf(12.0).compareTo(qty) == 0 ? 1 : 0) != 0, (String)"Unexpected indirect bomqtyonhand");
    }
}

