/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Separator
extends XulElement {
    private String _orient = "horizontal";
    private String _spacing;
    private boolean _bar;

    public Separator() {
    }

    public Separator(String orient) {
        this.setOrient(orient);
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public boolean isBar() {
        return this._bar;
    }

    public void setBar(boolean bar) {
        if (this._bar != bar) {
            this._bar = bar;
            this.smartUpdate("bar", this._bar);
        }
    }

    public String getSpacing() {
        return this._spacing;
    }

    public void setSpacing(String spacing) {
        if (spacing != null) {
            spacing = spacing.length() == 0 ? null : spacing.trim();
        }
        if (!Objects.equals((Object)this._spacing, (Object)spacing)) {
            this._spacing = spacing;
            this.smartUpdate("spacing", this._spacing);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-separator" : this._zclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "spacing", this._spacing);
        this.render(renderer, "orient", this._orient);
        this.render(renderer, "bar", this._bar);
    }

    public boolean isChildable() {
        return false;
    }
}

