/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.event.GroupsDataEvent;
import org.zkoss.zul.event.GroupsDataListener;
import org.zkoss.zul.ext.GroupingInfo;
import org.zkoss.zul.ext.GroupsSelectableModel;
import org.zkoss.zul.ext.GroupsSortableModel;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;
import org.zkoss.zul.impl.GroupsListModelExt;

public class GroupsListModel<D, G, F>
extends AbstractListModel<Object>
implements GroupsSelectableModel<Object> {
    protected GroupsModel<D, G, F> _model;
    private transient int _size;
    private transient int[] _gpofs;
    private transient boolean[] _gpfts;
    private transient boolean[] _gpopens;
    private transient GroupsDataListener _listener;
    private transient List<int[]> _gpinfo;

    public static <D, G, F> GroupsListModel<D, G, F> toListModel(GroupsModel<D, G, F> model) {
        if (model instanceof GroupsSortableModel) {
            return new GroupsListModelExt<D, G, F>(model);
        }
        return new GroupsListModel<D, G, F>(model);
    }

    protected GroupsListModel(GroupsModel<D, G, F> model) {
        this._model = model;
        this.init();
    }

    void init() {
        int groupCount = this._model.getGroupCount();
        this._gpofs = new int[groupCount];
        this._gpfts = new boolean[groupCount];
        this._gpopens = new boolean[groupCount];
        this._size = 0;
        for (int j = 0; j < groupCount; ++j) {
            this._gpofs[j] = this._size;
            this._gpopens[j] = this._model.isGroupOpened(j);
            this._size += 1 + (this._gpopens[j] ? this._model.getChildCount(j) : 0);
            this._gpfts[j] = this._model.hasGroupfoot(j);
            if (!this._gpfts[j]) continue;
            ++this._size;
        }
        if (this._listener == null) {
            this._listener = new DataListener();
            this._model.addGroupsDataListener(this._listener);
        }
    }

    public void cleanInternalListener() {
        if (this._model != null && this._listener != null) {
            this._model.removeGroupsDataListener(this._listener);
        }
    }

    public List<int[]> getGroupsInfos() {
        this._gpinfo = new LinkedList<int[]>();
        for (int j = 0; j < this._gpofs.length; ++j) {
            int offset1 = this._gpofs[j];
            int offset2 = this.getNextOffset(j);
            this._gpinfo.add(new int[]{offset1, offset2 - offset1, this.hasGroupfoot(j) ? offset2 - 1 : -1});
        }
        return this._gpinfo;
    }

    public int getGroupOffset(int groupIndex) {
        return this._gpofs[groupIndex];
    }

    public GroupsModel<D, G, F> getGroupsModel() {
        return this._model;
    }

    int getGroupCount() {
        return this._gpofs.length;
    }

    int getChildCount(int groupIndex) {
        int v = this.getNextOffset(groupIndex) - this._gpofs[groupIndex] - 1;
        return this._gpfts[groupIndex] ? v - 1 : v;
    }

    boolean hasGroupfoot(int groupIndex) {
        return this._gpfts[groupIndex];
    }

    private int getNextOffset(int groupIndex) {
        return groupIndex >= this._gpofs.length - 1 ? this._size : this._gpofs[groupIndex + 1];
    }

    public GroupingInfo getDataInfo(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Not in 0.." + this._size + ": " + index);
        }
        int gi = Arrays.binarySearch(this._gpofs, index);
        if (gi >= 0) {
            return new GroupDataInfo(0, gi, 0, this._gpopens[gi]);
        }
        gi = -gi - 2;
        int ofs = index - this._gpofs[gi] - 1;
        if (this._gpfts[gi] && ofs >= this.getNextOffset(gi) - this._gpofs[gi] - 2) {
            return new GroupDataInfo(1, gi, 0, this._gpopens[gi]);
        }
        return new GroupDataInfo(2, gi, ofs, this._gpopens[gi]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this._model.equals(o instanceof GroupsListModel ? ((GroupsListModel)((Object)o))._model : o);
    }

    public int hashCode() {
        return this._model.hashCode();
    }

    public String toString() {
        return Objects.toString(this._model);
    }

    @Override
    public Object getElementAt(int index) {
        GroupingInfo info = this.getDataInfo(index);
        if (info.getType() == 0) {
            return this._model.getGroup(info.getGroupIndex());
        }
        if (info.getType() == 1) {
            return this._model.getGroupfoot(info.getGroupIndex());
        }
        return this._model.getChild(info.getGroupIndex(), info.getOffset());
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public Set<Object> getSelection() {
        if (this._model instanceof Selectable) {
            return ((Selectable)((Object)this._model)).getSelection();
        }
        return super.getSelection();
    }

    @Override
    public void setSelection(Collection<?> selection) {
        if (this._model instanceof Selectable) {
            ((Selectable)((Object)this._model)).setSelection(selection);
        } else {
            super.setSelection(selection);
        }
    }

    @Override
    public boolean isSelected(Object obj) {
        if (this._model instanceof Selectable) {
            return ((Selectable)((Object)this._model)).isSelected(obj);
        }
        return super.isSelected(obj);
    }

    @Override
    public boolean isSelectionEmpty() {
        if (this._model instanceof Selectable) {
            return ((Selectable)((Object)this._model)).isSelectionEmpty();
        }
        return super.isSelectionEmpty();
    }

    @Override
    public boolean addToSelection(Object obj) {
        if (this._model instanceof Selectable) {
            return ((Selectable)((Object)this._model)).addToSelection(obj);
        }
        return super.addToSelection(obj);
    }

    @Override
    public boolean removeFromSelection(Object obj) {
        if (this._model instanceof Selectable) {
            return ((Selectable)((Object)this._model)).removeFromSelection(obj);
        }
        return super.removeFromSelection(obj);
    }

    @Override
    public void clearSelection() {
        if (this._model instanceof Selectable) {
            ((Selectable)((Object)this._model)).clearSelection();
        } else {
            super.clearSelection();
        }
    }

    @Override
    public boolean isMultiple() {
        if (this._model instanceof Selectable) {
            return ((Selectable)((Object)this._model)).isMultiple();
        }
        return super.isMultiple();
    }

    @Override
    public void setMultiple(boolean multiple) {
        if (this._model instanceof Selectable) {
            ((Selectable)((Object)this._model)).setMultiple(multiple);
        } else {
            super.setMultiple(multiple);
        }
    }

    @Override
    public SelectionControl getSelectionControl() {
        if (this._model instanceof GroupsSelectableModel) {
            return ((GroupsSelectableModel)((Object)this._model)).getSelectionControl();
        }
        return super.getSelectionControl();
    }

    @Override
    public void setSelectionControl(SelectionControl ctrl) {
        if (this._model instanceof GroupsSelectableModel) {
            ((GroupsSelectableModel)((Object)this._model)).setSelectionControl(ctrl);
        } else {
            super.setSelectionControl(ctrl);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this._model.removeGroupsDataListener(this._listener);
        try {
            s.defaultWriteObject();
        }
        finally {
            this._model.addGroupsDataListener(this._listener);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    @Override
    public Object clone() {
        GroupsListModel clone = (GroupsListModel)super.clone();
        clone._listener = null;
        return clone;
    }

    @Override
    public void setGroupSelectable(boolean groupSelectable) {
        if (this._model instanceof GroupsSelectableModel) {
            ((GroupsSelectableModel)((Object)this._model)).setGroupSelectable(groupSelectable);
        }
    }

    @Override
    public boolean isGroupSelectable() {
        if (this._model instanceof GroupsSelectableModel) {
            return ((GroupsSelectableModel)((Object)this._model)).isGroupSelectable();
        }
        return false;
    }

    public static class GroupDataInfo
    implements GroupingInfo {
        public static final byte GROUP = 0;
        public static final byte GROUPFOOT = 1;
        public static final byte ELEMENT = 2;
        private int _groupIndex;
        private int _offset;
        private byte _type;
        private boolean _open;

        private GroupDataInfo(byte type, int groupIndex, int offset, boolean open) {
            this._type = type;
            this._groupIndex = groupIndex;
            this._offset = offset;
            this._open = open;
        }

        @Override
        public int getType() {
            return this._type;
        }

        @Override
        public int getGroupIndex() {
            return this._groupIndex;
        }

        @Override
        public int getOffset() {
            return this._offset;
        }

        @Override
        public boolean isOpen() {
            return this._open;
        }
    }

    private class DataListener
    implements GroupsDataListener {
        private DataListener() {
        }

        @Override
        public void onChange(GroupsDataEvent event) {
            int type = event.getType();
            int j0 = event.getIndex0();
            int j1 = event.getIndex1();
            switch (type) {
                case 0: 
                case 1: 
                case 2: {
                    int gi = event.getGroupIndex();
                    if (gi < 0 || gi >= GroupsListModel.this._gpofs.length) {
                        throw new IndexOutOfBoundsException("Group index not in 0.." + GroupsListModel.this.getGroupCount() + ", " + gi);
                    }
                    int ofs = GroupsListModel.this._gpofs[gi] + 1;
                    int n = j0 = j0 >= 0 ? j0 + ofs : ofs;
                    if (j1 >= 0) {
                        j1 += ofs;
                    } else {
                        j1 = GroupsListModel.this.getNextOffset(gi) - 1;
                        if (GroupsListModel.this._gpfts[gi]) {
                            --j1;
                        }
                    }
                    GroupsListModel.this.init();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    type -= 4;
                    if (j0 >= 0) {
                        if (j0 >= GroupsListModel.this._gpofs.length) {
                            throw new IndexOutOfBoundsException("Group index not in 0.." + GroupsListModel.this.getGroupCount() + ", " + j0);
                        }
                        j0 = GroupsListModel.this._gpofs[j0];
                    }
                    if (j1 >= 0) {
                        if (j1 >= GroupsListModel.this._gpofs.length) {
                            throw new IndexOutOfBoundsException("Group index not in 0.." + GroupsListModel.this.getGroupCount() + ", " + j1);
                        }
                        j1 = GroupsListModel.this.getNextOffset(j1) - 1;
                    }
                    GroupsListModel.this.init();
                    break;
                }
                case 8: {
                    type = 4;
                    break;
                }
                case 9: {
                    type = 6;
                    break;
                }
                case 10: {
                    int index = event.getGroupIndex();
                    if (event.getModel().getChildCount(index) <= 0) {
                        return;
                    }
                    GroupsListModel.this.init();
                    boolean open = GroupsListModel.this._gpopens[index];
                    type = open ? 1 : 2;
                    j1 = j0 = GroupsListModel.this._gpofs[index] + 1;
                    break;
                }
                case 11: {
                    type = 11;
                    break;
                }
                case 12: {
                    type = 12;
                    break;
                }
                default: {
                    GroupsListModel.this.init();
                }
            }
            GroupsListModel.this.fireEvent(type, j0, j1);
        }
    }
}

