/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zul.impl.XulElement;

public class Html
extends XulElement {
    private String _content = "";

    public Html() {
    }

    public Html(String content) {
        this._content = content != null ? content : "";
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content == null) {
            content = "";
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.smartUpdate("content", this.getContent());
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        String cnt = this.getContent();
        if (cnt.length() > 0) {
            HtmlPageRenders.RenderContext rc = HtmlPageRenders.getRenderContext(null);
            if (rc != null) {
                Writer cwout = rc.temp;
                cwout.write("<div id=\"");
                cwout.write(this.getUuid());
                cwout.write("\" style=\"display:none\">");
                cwout.write(cnt);
                cwout.write("</div>\n");
                if (!rc.included) {
                    cnt = null;
                }
            }
            if (cnt == null) {
                renderer.render("content", (Object)new JavaScriptValue("zk('" + this.getUuid() + "').detachChildren()"));
            } else {
                this.render(renderer, "content", cnt);
            }
        }
    }

    protected boolean isChildable() {
        return false;
    }
}

