/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.User;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.felix.webconsole.WebConsoleSecurityProvider2;
import org.apache.felix.webconsole.internal.servlet.BasicWebConsoleSecurityProvider;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

final class OsgiManagerHttpContext
implements HttpContext {
    private final HttpContext base;
    private final ServiceTracker<WebConsoleSecurityProvider, WebConsoleSecurityProvider> tracker;
    private final String realm;

    OsgiManagerHttpContext(HttpService httpService, ServiceTracker<WebConsoleSecurityProvider, WebConsoleSecurityProvider> tracker, String realm) {
        this.tracker = tracker;
        this.realm = realm;
        this.base = httpService.createDefaultHttpContext();
    }

    public String getMimeType(String name) {
        return this.base.getMimeType(name);
    }

    public URL getResource(String name) {
        URL url = this.base.getResource(name);
        if (url == null && name.endsWith("/")) {
            return this.base.getResource(name.substring(0, name.length() - 1));
        }
        return url;
    }

    public boolean handleSecurity(final HttpServletRequest request, HttpServletResponse response) {
        final WebConsoleSecurityProvider provider = (WebConsoleSecurityProvider)this.tracker.getService();
        boolean result = provider instanceof WebConsoleSecurityProvider2 ? ((WebConsoleSecurityProvider2)provider).authenticate(request, response) : this.handleSecurity(provider, request, response);
        if (result) {
            request.setAttribute(User.USER_ATTRIBUTE, (Object)new User(){

                @Override
                public boolean authorize(String role) {
                    Object user = this.getUserObject();
                    if (user == null) {
                        return false;
                    }
                    if (provider == null) {
                        return true;
                    }
                    return provider.authorize(this.getUserObject(), role);
                }

                @Override
                public Object getUserObject() {
                    return request.getAttribute("org.apache.felix.webconsole.user");
                }
            });
        }
        return result;
    }

    private boolean handleSecurity(WebConsoleSecurityProvider provider, HttpServletRequest request, HttpServletResponse response) {
        int blank;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase("Basic")) {
                try {
                    byte[][] userPass = BasicWebConsoleSecurityProvider.base64Decode(authInfo);
                    String username = BasicWebConsoleSecurityProvider.toString(userPass[0]);
                    if (this.authenticate(provider, username, userPass[1])) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        request.setAttribute("org.apache.felix.webconsole.user", (Object)username);
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean authenticate(WebConsoleSecurityProvider provider, String username, byte[] password) {
        if (provider != null) {
            return provider.authenticate(username, BasicWebConsoleSecurityProvider.toString(password)) != null;
        }
        return false;
    }
}

