/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.generator;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.generator.FrameGenerator;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class DataGenerator
extends FrameGenerator {
    private final boolean useDirectByteBuffers;

    public DataGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        super(bufferPool);
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, long streamId, Frame frame, Consumer<Throwable> fail) {
        DataFrame dataFrame = (DataFrame)frame;
        return this.generateDataFrame(accumulator, dataFrame);
    }

    private int generateDataFrame(ByteBufferPool.Accumulator accumulator, DataFrame frame) {
        ByteBuffer data = frame.getByteBuffer();
        int dataLength = data.remaining();
        int headerLength = VarLenInt.length(FrameType.DATA.type()) + VarLenInt.length(dataLength);
        RetainableByteBuffer header = this.getByteBufferPool().acquire(headerLength, this.useDirectByteBuffers);
        ByteBuffer byteBuffer = header.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode(byteBuffer, FrameType.DATA.type());
        VarLenInt.encode(byteBuffer, dataLength);
        byteBuffer.flip();
        accumulator.append(header);
        accumulator.append(RetainableByteBuffer.wrap((ByteBuffer)data));
        return headerLength + dataLength;
    }
}

