/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Names {
    private static final Set<String> _reves;

    private Names() {
    }

    public static final Set<String> getReservedNames() {
        return _reves;
    }

    public static final boolean isValid(String name) {
        if (Names.isReserved(name)) {
            return false;
        }
        int j = name.length();
        while (--j >= 0) {
            char cc = name.charAt(j);
            if (cc >= '0' && cc <= '9' || cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc == '_') continue;
            return false;
        }
        return true;
    }

    public static final boolean isReserved(String name) {
        return _reves.contains(name);
    }

    static {
        HashSet<String> reves = new HashSet<String>();
        String[] rs = new String[]{"arg", "desktop", "event", "page", "self", "session", "spaceOwner"};
        int j = rs.length;
        while (--j >= 0) {
            reves.add(rs[j]);
        }
        _reves = Collections.unmodifiableSet(reves);
    }
}

