/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.impl.MultiComposer;
import org.zkoss.zk.ui.impl.UiEngineImpl;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.FullComposer;

class CreateInfo {
    final Execution exec;
    final Page page;
    final UiFactory uf;
    private List<Composer> _composers;
    private List<Composer> _composerExts;
    private Composer _syscomposer;

    CreateInfo(UiFactory uf, Execution exec, Page page, Composer composer) {
        this.exec = exec;
        this.page = page;
        this.uf = uf;
        if (composer instanceof FullComposer) {
            this.pushFullComposer(composer);
        } else {
            this._syscomposer = composer;
        }
    }

    void pushFullComposer(Composer composer) {
        assert (composer instanceof FullComposer);
        if (this._composers == null) {
            this._composers = new LinkedList<Composer>();
        }
        this._composers.add(0, composer);
        if (composer instanceof ComposerExt) {
            if (this._composerExts == null) {
                this._composerExts = new LinkedList<Composer>();
            }
            this._composerExts.add(0, composer);
        }
    }

    void popFullComposer() {
        Composer o = this._composers.remove(0);
        if (this._composers.isEmpty()) {
            this._composers = null;
        }
        if (o instanceof ComposerExt) {
            this._composerExts.remove(0);
            if (this._composerExts.isEmpty()) {
                this._composerExts = null;
            }
        }
    }

    private static boolean beforeInvoke(Composer composer, boolean bRoot) {
        return !bRoot && composer instanceof MultiComposer && ((MultiComposer)composer).setFullComposerOnly(true);
    }

    private static void afterInvoke(Composer composer, boolean bRoot, boolean old) {
        if (!bRoot && composer instanceof MultiComposer) {
            ((MultiComposer)composer).setFullComposerOnly(old);
        }
    }

    void doAfterCompose(Component comp, boolean bRoot) throws Exception {
        if (this._composers != null) {
            for (Composer composer : this._composers) {
                boolean old = CreateInfo.beforeInvoke(composer, bRoot);
                composer.doAfterCompose(comp);
                CreateInfo.afterInvoke(composer, bRoot, old);
            }
        }
        if (bRoot && this._syscomposer != null) {
            this._syscomposer.doAfterCompose(comp);
        }
    }

    ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo, boolean bRoot) throws Exception {
        if (this._composerExts != null) {
            for (Composer composer : this._composerExts) {
                boolean old = CreateInfo.beforeInvoke(composer, bRoot);
                compInfo = ((ComposerExt)((Object)composer)).doBeforeCompose(page, parent, compInfo);
                CreateInfo.afterInvoke(composer, bRoot, old);
                if (compInfo != null) continue;
                return null;
            }
        }
        if (bRoot && this._syscomposer instanceof ComposerExt) {
            compInfo = ((ComposerExt)((Object)this._syscomposer)).doBeforeCompose(page, parent, compInfo);
        }
        return compInfo;
    }

    void doBeforeComposeChildren(Component comp, boolean bRoot) throws Exception {
        if (this._composerExts != null) {
            for (Composer composer : this._composerExts) {
                boolean old = CreateInfo.beforeInvoke(composer, bRoot);
                UiEngineImpl.doBeforeComposeChildren((ComposerExt)((Object)composer), comp);
                CreateInfo.afterInvoke(composer, bRoot, old);
            }
        }
        if (bRoot && this._syscomposer instanceof ComposerExt) {
            UiEngineImpl.doBeforeComposeChildren((ComposerExt)((Object)this._syscomposer), comp);
        }
    }

    boolean doCatch(Throwable ex, boolean bRoot) {
        if (this._composerExts != null) {
            for (Composer composer : this._composerExts) {
                boolean old = CreateInfo.beforeInvoke(composer, bRoot);
                try {
                    boolean ret = ((ComposerExt)((Object)composer)).doCatch(ex);
                    CreateInfo.afterInvoke(composer, bRoot, old);
                    if (!ret) continue;
                    return true;
                }
                catch (Throwable t) {
                    UiEngineImpl.log.error("Failed to invoke doCatch for " + composer, t);
                }
            }
        }
        if (bRoot && this._syscomposer instanceof ComposerExt) {
            try {
                return ((ComposerExt)((Object)this._syscomposer)).doCatch(ex);
            }
            catch (Throwable t) {
                UiEngineImpl.log.error("Failed to invoke doCatch for " + this._syscomposer, t);
            }
        }
        return false;
    }

    void doFinally(boolean bRoot) throws Exception {
        if (this._composerExts != null) {
            for (Composer composer : this._composerExts) {
                boolean old = CreateInfo.beforeInvoke(composer, bRoot);
                ((ComposerExt)((Object)composer)).doFinally();
                CreateInfo.afterInvoke(composer, bRoot, old);
            }
        }
        if (bRoot && this._syscomposer instanceof ComposerExt) {
            ((ComposerExt)((Object)this._syscomposer)).doFinally();
        }
    }
}

