/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.Messages;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.SimpleDateConstraint;
import org.zkoss.zul.ext.Constrainted;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public class Calendar
extends XulElement
implements Constrainted {
    private ZonedDateTime _value;
    private TimeZone _defaultTzone = TimeZones.getCurrent();
    private boolean _weekOfYear;
    private boolean _showTodayLink = false;
    private String _todayLinkLabel = Messages.get((int)MZul.CALENDAR_TODAY);
    private SimpleDateConstraint _constraint;
    private String _name;

    public Calendar() {
        this((ZonedDateTime)null);
    }

    public Calendar(Date value) {
        this(value == null ? null : ZonedDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault()));
    }

    public Calendar(ZonedDateTime value) {
        this._value = value != null ? value : ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
    }

    public Calendar(LocalDateTime value) {
        this(value == null ? null : value.atZone(ZoneId.systemDefault()));
    }

    public Calendar(LocalDate value) {
        this(value == null ? null : value.atStartOfDay(ZoneId.systemDefault()));
    }

    public void setWeekOfYear(boolean weekOfYear) {
        if (this._weekOfYear != weekOfYear) {
            this._weekOfYear = weekOfYear;
            this.smartUpdate("weekOfYear", this._weekOfYear);
        }
    }

    public boolean isWeekOfYear() {
        return this._weekOfYear;
    }

    public Date getValue() {
        return Date.from(this._value.toInstant());
    }

    public void setValue(Date value) {
        this.setValueInZonedDateTime(value == null ? null : ZonedDateTime.ofInstant(value.toInstant(), this._value.getZone()));
    }

    public ZonedDateTime getValueInZonedDateTime() {
        return this._value;
    }

    public void setValueInZonedDateTime(ZonedDateTime value) {
        if (value == null) {
            value = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
        }
        if (!value.equals(this._value)) {
            this._value = value;
            this.smartUpdate("value", this.getValue());
        }
    }

    public LocalDateTime getValueInLocalDateTime() {
        return this.getValueInZonedDateTime().toLocalDateTime();
    }

    public void setValueInLocalDateTime(LocalDateTime value) {
        this.setValueInZonedDateTime(value == null ? null : value.atZone(this._value.getZone()));
    }

    public LocalDate getValueInLocalDate() {
        return this.getValueInZonedDateTime().toLocalDate();
    }

    public void setValueInLocalDate(LocalDate value) {
        this.setValueInZonedDateTime(value == null ? null : value.atStartOfDay(this._value.getZone()));
    }

    public LocalTime getValueInLocalTime() {
        return this.getValueInZonedDateTime().toLocalTime();
    }

    public void setValueInLocalTime(LocalTime value) throws WrongValueException {
        throw new UnsupportedOperationException("need date");
    }

    private DateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd", Locales.getCurrent());
        df.setTimeZone(TimeZones.getCurrent());
        return df;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public boolean getShowTodayLink() {
        return this._showTodayLink;
    }

    public void setShowTodayLink(boolean showTodayLink) {
        if (this._showTodayLink != showTodayLink) {
            this._showTodayLink = showTodayLink;
            this.smartUpdate("showTodayLink", this._showTodayLink);
        }
    }

    public String getTodayLinkLabel() {
        return this._todayLinkLabel;
    }

    public void setTodayLinkLabel(String todayLinkLabel) {
        if (!Objects.equals((Object)this._todayLinkLabel, (Object)todayLinkLabel)) {
            this._todayLinkLabel = todayLinkLabel;
            this.smartUpdate("todayLinkLabel", todayLinkLabel);
        }
    }

    public void setConstraint(String constr) {
        if (constr != null) {
            this.setConstraint(new SimpleDateConstraint(constr));
        }
    }

    @Override
    public void setConstraint(Constraint constr) {
        if (!Objects.equals((Object)this._constraint, (Object)constr)) {
            this._constraint = (SimpleDateConstraint)constr;
            this.smartUpdate("constraint", new JavaScriptValue(this._constraint.getClientConstraint()));
        }
    }

    @Override
    public Constraint getConstraint() {
        return this._constraint;
    }

    public String getZclass() {
        return this._zclass == null ? "z-calendar" : this._zclass;
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onChange")) {
            Map data = request.getData();
            Date value = (Date)data.get("value");
            ZonedDateTime zonedValue = ZonedDateTime.ofInstant(value.toInstant(), this._value.getZone());
            if (Objects.equals((Object)this._value, (Object)zonedValue)) {
                return;
            }
            this._value = zonedValue;
            InputEvent evt = new InputEvent(cmd, (Component)this, this.getDateFormat().format(value), (Object)value, AuRequests.getBoolean((Map)data, (String)"bySelectBack"), AuRequests.getInt((Map)data, (String)"start", (int)0));
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._name != null) {
            this.render(renderer, "name", this._name);
        }
        this.render(renderer, "defaultTzone", this._defaultTzone.getID());
        this.render(renderer, "weekOfYear", this._weekOfYear);
        this.render(renderer, "value", this.getValue());
        this.render(renderer, "showTodayLink", this._showTodayLink);
        this.render(renderer, "todayLinkLabel", this._todayLinkLabel);
        if (this._constraint != null) {
            this.render(renderer, "constraint", new JavaScriptValue(this._constraint.getClientConstraint()));
        }
    }

    static {
        Calendar.addClientEvent(Calendar.class, (String)"onChange", (int)16385);
        Calendar.addClientEvent(Calendar.class, (String)"onWeekClick", (int)16384);
    }
}

