/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.adinterface;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.ecs.Element;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.h1;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.style;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MOrg;
import org.compiere.model.MQuery;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class ReportEngineEx {
    private static final CLogger log = CLogger.getCLogger(ReportEngineEx.class);

    public static boolean createEXCEL_HTML(ReportEngine re, Properties m_ctx, File file, boolean onlyTable, Language language) {
        try {
            Language lang = language;
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            FileWriter fw = new FileWriter(file, false);
            return ReportEngineEx.createEXCEL_HTML(re, m_ctx, new BufferedWriter(fw), onlyTable, lang);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
        }
        return false;
    }

    public static boolean createEXCEL_HTML_wr(ReportEngine re, Properties m_ctx, Writer wr, boolean onlyTable, Language language) {
        try {
            Language lang = language;
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            return ReportEngineEx.createEXCEL_HTML(re, m_ctx, new BufferedWriter(wr), onlyTable, lang);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
            return false;
        }
    }

    public static boolean createEXCEL_HTML(ReportEngine re, Properties m_ctx, Writer writer, boolean onlyTable, Language language) {
        PrintData m_printData = re.getPrintData();
        MPrintFormat m_printFormat = re.getPrintFormat();
        MQuery m_query = re.getQuery();
        try {
            table table2 = new table();
            int row = -1;
            while (row < m_printData.getRowCount()) {
                tr tr2 = new tr();
                table2.addElement((Element)tr2);
                if (row != -1) {
                    m_printData.setRowIndex(row);
                }
                int col = 0;
                while (col < m_printFormat.getItemCount()) {
                    MPrintFormatItem item = m_printFormat.getItem(col);
                    if (item.isPrinted()) {
                        if (row == -1) {
                            th th2 = new th();
                            tr2.addElement((Element)th2);
                            th2.addElement(Util.maskHTML((String)item.getPrintName(language)));
                            th2.setClass("xl_head");
                        } else {
                            td td2 = new td();
                            tr2.addElement((Element)td2);
                            Object obj = m_printData.getNodeByPrintFormatItem(item);
                            if (obj == null) {
                                td2.addElement("&nbsp;");
                            } else if (obj instanceof PrintDataElement) {
                                String value = ((PrintDataElement)obj).getValueDisplay(null);
                                int displayType = ((PrintDataElement)obj).getDisplayType();
                                if (((PrintDataElement)obj).isNumeric()) {
                                    if (displayType == 11) {
                                        td2.addAttribute("x:num", value);
                                        td2.addElement(Util.maskHTML((String)value));
                                    } else if (displayType == 29) {
                                        td2.addAttribute("x:num", value);
                                        td2.addElement(Util.maskHTML((String)value));
                                    } else if (displayType == 12) {
                                        td2.addAttribute("x:num", value);
                                        td2.addElement(Util.maskHTML((String)value));
                                    } else if (displayType == 37) {
                                        td2.addAttribute("x:num", "");
                                        td2.addAttribute("u1:num", value);
                                        td2.setClass("xl25");
                                        td2.addElement(Util.maskHTML((String)value));
                                    } else {
                                        td2.addElement(Util.maskHTML((String)value));
                                    }
                                } else if (((PrintDataElement)obj).isDate()) {
                                    if (displayType == 15) {
                                        td2.setClass("xl24");
                                        td2.addElement(Util.maskHTML((String)value));
                                    } else if (displayType == 16) {
                                        td2.setClass("xl26");
                                        td2.addElement(Util.maskHTML((String)value));
                                    } else {
                                        td2.addElement(Util.maskHTML((String)value));
                                    }
                                } else {
                                    td2.addElement(Util.maskHTML((String)value));
                                }
                            } else if (!(obj instanceof PrintData)) {
                                log.log(Level.SEVERE, "createHTML - Element not PrintData(Element) " + String.valueOf(obj.getClass()));
                            }
                        }
                    }
                    ++col;
                }
                ++row;
            }
            table table1 = new table();
            table1.setBorder(0).setCols(10).setCellPadding(0).setCellSpacing(2);
            table1.addElement((Element)new tr().addElement(new td().setColSpan(10).addElement((Element)new h1(re.getName())).setStyle("border:none;")));
            String tmp = Msg.getElement((Properties)m_ctx, (String)"AD_Org_ID") + ": ";
            MOrg o = MOrg.get((Properties)m_ctx, (int)Env.getAD_Org_ID((Properties)m_ctx));
            tmp = tmp + o.getName();
            tr tr1 = new tr();
            tr1.addElement(new td().addElement(tmp).setColSpan(10).setStyle("border:none;"));
            table1.addElement((Element)tr1);
            SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)15);
            String dateData = Msg.getElement((Properties)m_ctx, (String)"DateReport") + ": " + dateFormat.format(new Date());
            tr1 = new tr();
            tr1.addElement(new td().addElement(dateData).setColSpan(10).setStyle("border:none;"));
            table1.addElement((Element)tr1);
            int r = 0;
            while (r < m_query.getRestrictionCount()) {
                tr1 = new tr();
                td td1 = new td().addElement((Element)new i(m_query.getInfoName(r)));
                td1.addElement("   " + m_query.getInfoOperator(r) + "   " + m_query.getInfoDisplayAll(r)).setColSpan(10);
                td1.setStyle("border:none;");
                tr1.addElement((Element)td1);
                table1.addElement((Element)tr1);
                ++r;
            }
            tr1 = new tr();
            tr1.addElement(new td().addElement("&nbsp;").setColSpan(10).setStyle("border:none;height:20px;"));
            table1.addElement((Element)tr1);
            PrintWriter w = new PrintWriter(writer);
            if (onlyTable) {
                table2.output(w);
            } else {
                XhtmlDocument doc = new XhtmlDocument();
                String st = "<!--table \t{mso-displayed-decimal-separator:\".\"; \tmso-displayed-thousand-separator:\" \";} @page \t{margin:.98in .79in .98in .79in; \tmso-header-margin:.5in; \tmso-footer-margin:.5in;} tr \t{mso-height-source:auto;} col \t{mso-width-source:auto;} br \t{mso-data-placement:same-cell;} .style0 \t{mso-number-format:General; \ttext-align:general; \tvertical-align:bottom; \twhite-space:nowrap; \tmso-rotate:0; \tmso-background-source:auto; \tmso-pattern:auto; \tcolor:windowtext; \tfont-size:10.0pt; \tfont-weight:400; \tfont-style:normal; \ttext-decoration:none; \tfont-family:Arial; \tmso-generic-font-family:auto; \tmso-font-charset:238; \tborder:none; \tmso-protection:locked visible; \tmso-style-name:Normalny; \tmso-style-id:0;} td \t{mso-style-parent:style0; \tpadding-top:1px; \tpadding-right:1px; \tpadding-left:1px; \tmso-ignore:padding; \tcolor:windowtext; \tfont-size:10.0pt; \tfont-weight:400; \tfont-style:normal; \ttext-decoration:none; \tfont-family:Arial; \tmso-generic-font-family:auto; \tmso-font-charset:238; \tmso-number-format:General; \ttext-align:general; \tvertical-align:bottom; border:.5pt solid #a0a0a0; \tmso-background-source:auto; \tmso-pattern:auto; \tmso-protection:locked visible; \twhite-space:nowrap; \tmso-rotate:0;} .xl24 {mso-style-parent:style0; mso-number-format:\"Short Date\";} .xl25 {mso-style-parent:style0; mso-number-format:Fixed;} .xl26 {mso-style-parent:style0; mso-number-format:\"yy\\/mm\\/dd\\ h\\:mm\\;\\@\";} .xl_head {text-align:center; mso-style-parent:style0; font-weight:700; font-family:Arial, sans-serif; mso-font-charset:238; border:.5pt solid windowtext; background:silver; mso-pattern:auto none;} -->  ";
                doc.appendHead((Element)new style().addElement(st));
                doc.appendBody((Element)table1);
                doc.appendBody((Element)table2);
                doc.output(w);
            }
            w.flush();
            w.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "createHTML(w)", (Throwable)e);
        }
        return false;
    }
}

