/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Menu;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menuseparator;
import org.zkoss.zul.impl.XulElement;

public class Menubar
extends XulElement {
    private boolean _autodrop;
    private String _orient = "horizontal";
    private boolean _scrollable = false;

    public Menubar() {
    }

    public Menubar(String orient) {
        this();
        this.setOrient(orient);
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public boolean isScrollable() {
        return this._scrollable;
    }

    public void setScrollable(boolean scrollable) {
        if (this.isHorizontal() && this._scrollable != scrollable) {
            this._scrollable = scrollable;
            this.smartUpdate("scrollable", scrollable);
        }
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("autodrop", autodrop);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-menubar" : this._zclass;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Menu || child instanceof Menuitem || child instanceof Menuseparator)) {
            throw new UiException("Unsupported child for menubar: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "autodrop", this._autodrop);
        if ("vertical".equals(this.getOrient())) {
            this.render(renderer, "orient", this._orient);
        }
        if (this.isHorizontal() && this._scrollable) {
            this.render(renderer, "scrollable", this._scrollable);
        }
    }
}

