/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.openxml4j.opc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.zkoss.poi.openxml4j.exceptions.InvalidFormatException;
import org.zkoss.poi.openxml4j.exceptions.InvalidOperationException;
import org.zkoss.poi.openxml4j.exceptions.OpenXML4JException;
import org.zkoss.poi.openxml4j.opc.OPCPackage;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackagePartName;
import org.zkoss.poi.openxml4j.opc.ZipPackage;
import org.zkoss.poi.openxml4j.opc.internal.marshallers.ZipPartMarshaller;

public class ZipPackagePart
extends PackagePart {
    private ZipEntry zipEntry;

    public ZipPackagePart(OPCPackage container, PackagePartName partName, String contentType) throws InvalidFormatException {
        super(container, partName, contentType);
    }

    public ZipPackagePart(OPCPackage container, ZipEntry zipEntry, PackagePartName partName, String contentType) throws InvalidFormatException {
        super(container, partName, contentType);
        this.zipEntry = zipEntry;
    }

    public ZipEntry getZipArchive() {
        return this.zipEntry;
    }

    @Override
    protected InputStream getInputStreamImpl() throws IOException {
        return ((ZipPackage)this._container).getZipArchive().getInputStream(this.zipEntry);
    }

    @Override
    protected OutputStream getOutputStreamImpl() {
        return null;
    }

    @Override
    public boolean save(OutputStream os) throws OpenXML4JException {
        return new ZipPartMarshaller().marshall(this, os);
    }

    @Override
    public boolean load(InputStream ios) {
        throw new InvalidOperationException("Method not implemented !");
    }

    @Override
    public void close() {
        throw new InvalidOperationException("Method not implemented !");
    }

    @Override
    public void flush() {
        throw new InvalidOperationException("Method not implemented !");
    }
}

