/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPie3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractCategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFPie3DChartData
implements CategoryData {
    private CTPie3DChart ctPie3DChart;
    private List<CategoryDataSerie> series = new ArrayList<CategoryDataSerie>();

    public XSSFPie3DChartData() {
    }

    public XSSFPie3DChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTPie3DChart[] plotCharts = plotArea.getPie3DChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctPie3DChart = plotCharts[0];
        }
        if (this.ctPie3DChart != null) {
            CTPieSer[] bsers = this.ctPie3DChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTPieSer ser = bsers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                XSSFChartAxDataSource cats = new XSSFChartAxDataSource(ser.getCat());
                XSSFChartNumDataSource vals = new XSSFChartNumDataSource(ser.getVal());
                this.addSerie(title, cats, vals);
            }
        }
    }

    @Override
    public CategoryDataSerie addSerie(ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("Pie data source must be numeric.");
        }
        int numOfSeries = this.series.size();
        Serie newSerie = new Serie(numOfSeries, numOfSeries, title, cats, vals);
        this.series.add(newSerie);
        return newSerie;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctPie3DChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctPie3DChart = plotArea.addNewPie3DChart();
            this.ctPie3DChart.addNewVaryColors().setVal(true);
            for (CategoryDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctPie3DChart);
            }
        }
    }

    @Override
    public List<? extends CategoryDataSerie> getSeries() {
        return this.series;
    }

    static class Serie
    extends AbstractCategoryDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
            super(id, order, title, cats, vals);
        }

        protected void addToChart(CTPie3DChart ctPie3DChart) {
            CTPieSer pieSer = ctPie3DChart.addNewSer();
            pieSer.addNewIdx().setVal((long)this.id);
            pieSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = pieSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.categories != null && this.categories.getPointCount() > 0) {
                CTAxDataSource cats = pieSer.addNewCat();
                XSSFChartUtil.buildAxDataSource(cats, this.categories);
            }
            CTNumDataSource vals = pieSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }
    }
}

