


zss.Row = zk.$extends(zk.Widget, {
	widgetName: 'Row',
	$o: zk.$void, 
	$init: function (sheet, block, row, src) {
		this.$supers(zss.Row, '$init', []); 
		
		this.sheet = sheet; 
		this.block = block;
		
		this.r = row;
		
		this.cells = [];
		this.wrapedCells = [];

		this._updateCacheSrc(src);
	},
	
	_updateCacheSrc: function (src) {
		this.src = src;
		this.zsh = src.getRowHeightId(this.r); 
	},
	bind_: function (desktop, skipper, after) {
		this.$supers(zss.Row, 'bind_', arguments);
	},
	unbind_: function () {
		delete this.cells;
		this.r = this.zsh = null;
		this.$supers(zss.Row, 'unbind_', arguments);
	},
	updateAutoHeightDirty: function (oldCellHeight, newCellHeight) {
		
	},
	processCellAutoHeight: function (cell) {
		
	},
	addAutoHeightCell: function (cell) {
		
	},
	removeAutoHeightCell: function (cell) {
		
	},
	
	appendCell: function (cell, ignoreDom) {
		this.appendChild(cell, ignoreDom);
		this.cells.push(cell);
	},
	
	insertCell: function (index, cell, ignoreDom) {
		var cells = this.cells,
			sibling = cells[index];
		this.insertBefore(cell, sibling, ignoreDom);
		cells.splice(index, 0, cell);
	},
	redraw: function (out) {
		out.push(this.getHtmlPrologHalf())
		var cells = this.cells,
			size = cells.length;
		for (var i = 0; i < size; i++) {
			var cell = cells[i];
			cell.redraw(out);
		}
		out.push(this.getHtmlEpilogHalf());
	},
	getHtmlPrologHalf: function () {
		return '<div id="' + this.uuid + '" class="' + this.getZclass() + '" zs.t="SRow">';
	},
	getHtmlEpilogHalf: function () {
		return '</div>';
	},
	
	getZclass: function () {
		var cls = 'zsrow',
			hId = this.zsh;
		return hId ? cls + ' zsh' + hId : 'zsrow';
	},
	
	getCell: function (col) {
		var size = this.cells.length,
			i = 0;
		
		for (i = 0; i < size; i++) {
			if (this.cells[i].c == col) return this.cells[i];
		}
		return null;
	},
	
	getCellAt: function (index) {
		return this.cells[index];
	},
	
	removeLeftCell: function (size) {
		var cells = this.cells;
		var beforeSize = cells.length;
		while (size--) {
			if (!cells.length)
				return;
			cells.shift().detach();
		}
	},
	
	removeRightCell: function (size) {
		var cells = this.cells;
		while (size--) {
			if (!cells.length)
				return;
			cells.pop().detach();
		}
	},
	
	appendZSW: function (index, zsw) {
		var cell = this.cells[index];
		cell.appendZSW(zsw);
	},
	
	appendZSH: function (zsh) {
		if (zsh) {
			this.zsh = zsh;
			jq(this.$n()).addClass("zsh" + zsh);
			var size = this.cells.length;
			for (var i = 0; i < size; i++)
				this.cells[i].appendZSH(zsh);	
		}
	},
	
	insertNewCell: function (index, size) {
		var sheet = this.sheet,
			ctrl,
			cells = this.cells,
			col;
		
		if (index > cells.length) return;
		
		
		
		
		var tempcell = index == 0 ? null : cells[index - 1];
		col = index == 0 ? cells[0].c :(tempcell.c + 1);
		
		var block = this.block,
			src = this.src,
			r = this.r;
		
		for (var i = 0; i < size; i++) {
			var c = col + i;
			
			
			
			ctrl = new zss.Cell(sheet, block, r, c, src);
			ctrl._justCopied = true; 
			
			
			if (tempcell) {
				if (tempcell.overflowed) ctrl.overlapBy = tempcell;
				else if(tempcell.overlapBy) ctrl.overlapBy = tempcell.overlapBy;
			}
			this.insertCell(index + i, ctrl);
		}
		this.shiftCellInfo(index + size, col + size);
	},
	
	shiftCellInfo: function (index, newcol) {
		var cells = this.cells,
			size = cells.length,
			j = 0;
		for(var i = index; i < size; i++)
			cells[i].resetColumnIndex(newcol+(j++));
	},
	
	resetRowIndex: function (newrow) {
		this.r = newrow;
		var cells = this.cells,
			i = cells.length;
		while (i--)
			cells[i].resetRowIndex(newrow);
	},
	
	removeCell: function (index, size) {
		var ctrl,
			cells = this.cells,
			col;
		
		if (index > cells.length) return;
		if (index == cells.length)
			col = cells[index - 1].c + 1 ;
		else
			col = cells[index].c;

		var rem = cells.slice(index, index + size),
			tail = cells.slice(index + size, cells.length);
		cells.length = index;
		cells.push.apply(cells, tail);
		
		var cell = rem.pop();
		for (;cell ; cell = rem.pop()) {
			cell.detach();
		}
			
		this.shiftCellInfo(index, col);
	},
	getHeight: function(){
		return this.sheet.custRowHeight._getCustomizedSize(this.r);
	},
	doMouseMove_: function(evt) {
		var sheet = this.sheet,
			mx = evt.pageX,
			my = evt.pageY,
			position = zss.SSheetCtrl._calCellPos(sheet, mx, my),
			row = position[0],
			column = position[1],
			cell = sheet.getCell(row, column);

		
		if (cell.isMerged()) {
			cell = sheet.getCell(cell.mert,cell.merl);
		}

		if (cell) {
			var $anchor = jq(cell.comp).find('a');
			if ($anchor.length > 0) {
				var anchor = $anchor[0];
				if(zkS.isOverlapByPoint(anchor, mx, my)) {
					this._cursor = 'pointer';
					jq(this.$n()).css('cursor', 'pointer');
					return;
				}
			} 
		}
		
		if (this._cursor) {
			this._cursor = null;
			jq(this.$n()).css('cursor', '');
		}
	}
}, {
	
	copyCells: function (srcRow, destRow) {
		var cells = srcRow.cells;
			size = cells.length,
			r = destRow.r,
			html = '';
		for (var i = 0; i < size; i++) {
			var srcCell = cells[i],
				c = srcCell.c,
				src = srcCell.src,
				block = srcCell.block,
				sht = srcCell.sheet,
				newCell = new zss.Cell(sht, block, r, c, src);
			newCell._justCopied = true;
			html += newCell.getHtml();
			destRow.appendCell(newCell);
		}
		return html;
	}
});
