
(function () {


zss.DeferLoader = zk.$extends(zk.Object, {
	_deferTime: 500,
	
	_extraSize: 3000,
	
	_loadRow: 60,
	
	_loadCol: 40,
	$init: function (sheet) {
		this.sheet = sheet;
		this._wgt = sheet._wgt;
	},
	asyncRun: function () {
		if (this._timeoutId) {
			clearTimeout(this._timeoutId);
			this._timeoutId = null;
		}

		var sf = this;
		if (this.shallLoad()) {
			if (this.shallLoadNow()) {
				this._timeoutId = null;
				var wgt = sf._wgt,
					maxRow = wgt.getMaxRows(),
					maxCol = wgt.getMaxColumns(),
					preloadRow = wgt.getPreloadRowSize(),
					preloadCol = wgt.getPreloadColumnSize(),
					ar = wgt._cacheCtrl.getSelectedSheet(),
					rect = ar.rect,
					dir = this.sheet.sp.getDirection(),
					top = -1,
					left = -1,
					right = -1,
					bottom = -1;
				if (dir == 'south') {
					left = rect.left;
					right = rect.right;
					top = rect.bottom + 1;
					if (top >= maxRow) 
						return;
					bottom = top + (preloadRow > 0 ? preloadRow : this._loadRow);
					if (bottom >= maxRow)
						bottom = maxRow - 1;
				} else if (dir == 'north') {
					left = rect.left;
					right = rect.right;
					bottom = rect.top - 1;
					if (bottom < 0)
						return;
					top = bottom - (preloadRow > 0 ? preloadRow : this._loadRow);
					if (top < 0)
						top = 0;
				} else if (dir == 'east') {
					top = rect.top;
					bottom = rect.bottom;
					left = rect.right + 1;
					if (left >= maxCol)
						return;
					right = left + (preloadCol > 0 ? preloadCol : this._loadCol);
					if (right >= maxCol)
						right = maxCol - 1;
				} else if (dir == 'west') {
					top = rect.top;
					bottom = rect.bottom;
					right = rect.left - 1;
					if (right < 0)
						return;
					left = right - (preloadCol > 0 ? preloadCol : this._loadCol);
					if (left < 0)
						left = 0;
				}
				if (top >= 0 && left >= 0 && right >= 0 && bottom >=0)
					wgt.fetchActiveRange(top, left, right, bottom);
			} else {
				this._timeoutId = setTimeout(function () {
					sf.asyncRun();
				}, this._deferTime)
			}
		}
	},
	
	shallLoad: function (dir) {
		var wgt = this._wgt,
			sheet = this.sheet,
			activeBlock = sheet.activeBlock;
		if (activeBlock.loadstate == zss.MainBlockCtrl.LOADING) {
			return;
		}
		dir = dir || this.sheet.sp.getDirection();
		var vrng = activeBlock.range,
			maxRow = wgt.getMaxRows() - 1,
			maxCol = wgt.getMaxColumns() - 1,
			ar = wgt._cacheCtrl.getSelectedSheet();
		if (!ar) return false; 
		var	rect = ar.rect,
			size = ((rect.right - rect.left + 1) * (rect.bottom - vrng.bottom + 1));
		switch (dir) {
		case 'south':
			var rbtm = rect.bottom;
			if (rbtm >= maxRow)
				return false;
			var width = rect.right - rect.left + 1,
				size = width * (rbtm - vrng.bottom + 1);
			return size < this._extraSize;
		case 'east':
			var rright = rect.right;
			if (rright >= maxCol)
				return false;
			var height = rect.bottom - rect.top + 1,
				size = (height * (rect.right - vrng.right + 1));
			return size < this._extraSize;
		case 'north':
			var rtop = rect.top
			if (!rtop)
				return false;
			var	width = rect.right - rect.left + 1,
				size = width * (vrng.top - rtop + 1);
			return size < this._extraSize;
		case 'west':
			var rleft = rect.left;
			if (!rleft)
				return false;
			var hgh = rect.bottom - rect.top + 1,
				size = hgh * (vrng.left - rleft + 1);
			return size < this._extraSize;
		}
	},
	
	shallLoadNow: function () {
		return this.sheet.activeBlock.loadstate == zss.MainBlockCtrl.IDLE;
		
	}
});
})();