/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UnlockedCellsHelper
implements Serializable {
    private static final long serialVersionUID = -48813257946884503L;
    int _defaultSize;
    private List<UnlockedCellInfo> _infos;

    public UnlockedCellsHelper(List<UnlockedCellInfo> infos) {
        this._infos = infos;
    }

    public List<UnlockedCellInfo> getInfos() {
        return new ArrayList<UnlockedCellInfo>(this._infos);
    }

    public boolean isUnlocked(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new UnlockedCellInfoComparator());
        return j >= 0 ? true : this._isUnlocked(-j - 1 - 1, cellIndex);
    }

    public int getNextUnlocked(int start) {
        int j = this.getListIndex(start);
        if (j < 0) {
            if ((j = -j - 1) >= this._infos.size()) {
                return -1;
            }
            UnlockedCellInfo info = this._infos.get(j);
            return info.start;
        }
        UnlockedCellInfo info = this._infos.get(j);
        if (start >= info.end) {
            if (++j >= this._infos.size()) {
                return -1;
            }
            info = this._infos.get(j);
            return info.start;
        }
        return start + 1;
    }

    public int getPrevUnlocked(int start) {
        int j = this.getListIndex(start);
        if (j < 0) {
            if ((j = -j - 1 - 1) < 0) {
                return -1;
            }
            UnlockedCellInfo info = this._infos.get(j);
            return info.end;
        }
        UnlockedCellInfo info = this._infos.get(j);
        if (start <= info.start) {
            if (--j < 0) {
                return -1;
            }
            info = this._infos.get(j);
            return info.end;
        }
        return start - 1;
    }

    private boolean _isUnlocked(int listIndex, int cellIndex) {
        if (listIndex < 0 || listIndex >= this._infos.size()) {
            return false;
        }
        UnlockedCellInfo info = this._infos.get(listIndex);
        return info.isUnlocked(cellIndex);
    }

    private int getListIndex(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new UnlockedCellInfoComparator());
        return j >= 0 || !this._isUnlocked(-j - 1 - 1, cellIndex) ? j : -j - 1 - 1;
    }

    public UnlockedCellInfo getInfo(int cellIndex) {
        int j = this.getListIndex(cellIndex);
        return j < 0 ? null : this._infos.get(j);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (UnlockedCellInfo info : this._infos) {
            sb.append("[");
            sb.append(info.start).append(", ");
            sb.append(info.end);
            sb.append("],");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class UnlockedCellInfoComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -1290415509269113184L;

        private UnlockedCellInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i1 = o1 instanceof UnlockedCellInfo ? ((UnlockedCellInfo)o1).start : (Integer)o1;
            int i2 = o2 instanceof UnlockedCellInfo ? ((UnlockedCellInfo)o2).start : (Integer)o2;
            return i1 - i2;
        }
    }

    public static class UnlockedCellInfo {
        public int start;
        public int end;

        public UnlockedCellInfo(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public void shift(int offset) {
            this.start += offset;
            this.end += offset;
        }

        public boolean isUnlocked(int cellIndex) {
            return this.start <= cellIndex && cellIndex <= this.end;
        }
    }
}

