/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.model.impl;

import io.keikai.api.impl.RangeImpl;
import io.keikai.api.model.CellData;
import io.keikai.model.SCell;
import io.keikai.model.SSheet;
import io.keikai.range.SRange;
import java.io.Serializable;
import java.util.Date;

public class CellDataImpl
implements CellData,
Serializable {
    private static final long serialVersionUID = -1618615187748044449L;
    private RangeImpl _range;
    private SCell _cell;
    private boolean _cellInit;

    public CellDataImpl(RangeImpl range) {
        this._range = range;
    }

    @Override
    public int getRow() {
        return this._range.getRow();
    }

    @Override
    public int getColumn() {
        return this._range.getColumn();
    }

    private void initCell() {
        if (this._cellInit) {
            return;
        }
        this._cellInit = true;
        SRange x = this._range.getNative();
        SSheet sheet = x.getSheet();
        this._cell = sheet.getCell(x.getRow(), x.getColumn());
    }

    @Override
    public CellData.CellType getResultType() {
        CellData.CellType type = this.getType();
        if (type != CellData.CellType.FORMULA) {
            return type;
        }
        return this.toCellType(this._cell.getFormulaResultType());
    }

    private CellData.CellType toCellType(SCell.CellType type) {
        switch (type) {
            case BLANK: {
                return CellData.CellType.BLANK;
            }
            case BOOLEAN: {
                return CellData.CellType.BOOLEAN;
            }
            case ERROR: {
                return CellData.CellType.ERROR;
            }
            case FORMULA: {
                return CellData.CellType.FORMULA;
            }
            case NUMBER: {
                return CellData.CellType.NUMERIC;
            }
            case STRING: {
                return CellData.CellType.STRING;
            }
        }
        return CellData.CellType.BLANK;
    }

    @Override
    public CellData.CellType getType() {
        this.initCell();
        if (this._cell.isNull()) {
            return CellData.CellType.BLANK;
        }
        CellData.CellType type = this.toCellType(this._cell.getType());
        if (this._cell.isFormulaParsingError()) {
            return CellData.CellType.ERROR;
        }
        return type;
    }

    @Override
    public Object getValue() {
        return this._range.getCellValue();
    }

    @Override
    public String getFormatText() {
        return this._range.getCellFormatText();
    }

    @Override
    public String getEditText() {
        return this._range.getCellEditText();
    }

    @Override
    public void setValue(Object value) {
        this._range.setCellValue(value);
    }

    @Override
    public void setEditText(String editText) {
        this._range.setCellEditText(editText);
    }

    @Override
    public boolean validateEditText(String editText) {
        return this._range.getNative().validate(editText) == null;
    }

    @Override
    public boolean isBlank() {
        return this.getType() == CellData.CellType.BLANK;
    }

    @Override
    public boolean isFormula() {
        return this.getType() == CellData.CellType.FORMULA;
    }

    @Override
    public Double getDoubleValue() {
        this.initCell();
        if (CellData.CellType.BLANK.equals((Object)this.getType())) {
            return null;
        }
        return (double)this._cell.getNumberValue();
    }

    @Override
    public Date getDateValue() {
        this.initCell();
        if (CellData.CellType.BLANK.equals((Object)this.getType())) {
            return null;
        }
        return this._cell.getDateValue();
    }

    @Override
    public String getStringValue() {
        this.initCell();
        if (CellData.CellType.BLANK.equals((Object)this.getType())) {
            return null;
        }
        return this._cell.getStringValue();
    }

    @Override
    public String getFormulaValue() {
        this.initCell();
        if (CellData.CellType.BLANK.equals((Object)this.getType())) {
            return null;
        }
        return this._cell.getFormulaValue();
    }

    @Override
    public Boolean getBooleanValue() {
        this.initCell();
        if (CellData.CellType.BLANK.equals((Object)this.getType())) {
            return null;
        }
        return this._cell.getBooleanValue();
    }

    @Override
    public void setRichText(String htmlString) {
        this._range.setCellRichText(htmlString);
    }

    @Override
    public String getRichText() {
        return this._range.getCellRichText();
    }
}

