/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.model.SSheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AuDataUtil;
import io.keikai.ui.impl.HeaderPositionHelper;
import io.keikai.ui.impl.JSONObj;
import io.keikai.ui.impl.MergeMatrixHelper;
import io.keikai.ui.sys.FreezeInfoLoader;
import io.keikai.ui.sys.SpreadsheetCtrl;
import io.keikai.ui.sys.SpreadsheetInCtrl;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class CellFetchCommandHelper
implements Serializable {
    private static final long serialVersionUID = -8772574024823251988L;
    private static final Logger log = Logger.getLogger(CellFetchCommandHelper.class.getName());
    private Spreadsheet _spreadsheet;
    private SpreadsheetCtrl _ctrl;
    HeaderPositionHelper _rowHelper;
    HeaderPositionHelper _colHelper;
    private MergeMatrixHelper _mergeMatrix;
    private boolean _hidecolhead;
    private boolean _hiderowhead;
    private int _lastleft;
    private int _lastright;
    private int _lasttop;
    private int _lastbottom;
    private int _loadedLeft;
    private int _loadedRight;
    private int _loadedTop;
    private int _loadedBottom;

    private void responseDataBlock(String postfix, String token, String sheetid, String result) {
        this._spreadsheet.smartUpdate((String)(postfix != null ? "dataBlockUpdate" + postfix : "dataBlockUpdate"), new String[]{token, sheetid, result});
    }

    protected void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        Map data = request.getData();
        if (data == null || data.size() != 26) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        this._spreadsheet = (Spreadsheet)comp;
        if (this._spreadsheet.isInvalidated()) {
            return;
        }
        SSheet selSheet = this._spreadsheet.getSelectedSSheet();
        String sheetId = (String)data.get("sheetId");
        if (selSheet == null || !sheetId.equals(selSheet.getId())) {
            return;
        }
        this._ctrl = (SpreadsheetCtrl)this._spreadsheet.getExtraCtrl();
        this._hidecolhead = this._spreadsheet.isHidecolumnhead();
        this._hiderowhead = this._spreadsheet.isHiderowhead();
        String token = (String)data.get("token");
        this._rowHelper = this._ctrl.getRowPositionHelper(sheetId);
        this._colHelper = this._ctrl.getColumnPositionHelper(sheetId);
        SSheet sheet = this._spreadsheet.getSelectedSSheet();
        if (!sheet.getId().equals(sheetId)) {
            return;
        }
        this._mergeMatrix = this._ctrl.getMergeMatrixHelper(sheet);
        String type = (String)data.get("type");
        String direction = (String)data.get("direction");
        int dpWidth = AuDataUtil.getInt(data, "dpWidth");
        int dpHeight = AuDataUtil.getInt(data, "dpHeight");
        int viewWidth = AuDataUtil.getInt(data, "viewWidth");
        int viewHeight = AuDataUtil.getInt(data, "viewHeight");
        int blockLeft = (Integer)data.get("blockLeft");
        int blockTop = (Integer)data.get("blockTop");
        int blockRight = (Integer)data.get("blockRight");
        int blockBottom = (Integer)data.get("blockBottom");
        int fetchLeft = (Integer)data.get("fetchLeft");
        int fetchTop = (Integer)data.get("fetchTop");
        int fetchWidth = (Integer)data.get("fetchWidth");
        int fetchHeight = (Integer)data.get("fetchHeight");
        int visibleLeft = (Integer)data.get("rangeLeft");
        int visibleTop = (Integer)data.get("rangeTop");
        int visibleRight = (Integer)data.get("rangeRight");
        int visibleBottom = (Integer)data.get("rangeBottom");
        int cacheLeft = (Integer)data.get("arLeft");
        int cacheTop = (Integer)data.get("arTop");
        int cacheRight = (Integer)data.get("arRight");
        int cacheBottom = (Integer)data.get("arBottom");
        int cacheRangeFetchTopHeight = (Integer)data.get("arFetchTopHeight");
        int cacheRangeFetchBtmHeight = (Integer)data.get("arFetchBtmHeight");
        this._loadedLeft = visibleLeft;
        this._loadedTop = visibleTop;
        this._loadedRight = visibleRight;
        this._loadedBottom = visibleBottom;
        try {
            if ("jump".equals(type)) {
                String result = null;
                if ("east".equals(direction)) {
                    result = this.jump("E", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else if ("south".equals(direction)) {
                    result = this.jump("S", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else if ("west".equals(direction)) {
                    result = this.jump("W", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else if ("north".equals(direction)) {
                    result = this.jump("N", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else if ("westnorth".equals(direction)) {
                    result = this.jump("WN", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else if ("eastnorth".equals(direction)) {
                    result = this.jump("EN", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else if ("westsouth".equals(direction)) {
                    result = this.jump("WS", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else if ("eastsouth".equals(direction)) {
                    result = this.jump("ES", (Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, fetchLeft, fetchTop, visibleLeft, visibleTop, visibleRight, visibleBottom);
                } else {
                    throw new UiException("Unknow direction:" + direction);
                }
                this.responseDataBlock("Jump", token, sheetId, result);
            } else if ("neighbor".equals(type)) {
                if ("east".equals(direction)) {
                    LoadResult result;
                    int right = blockRight + fetchWidth;
                    right = this._mergeMatrix.getRightConnectedColumn(right, blockTop, blockBottom);
                    int bottom = this._mergeMatrix.getBottomConnectedRow(blockBottom, blockLeft, right);
                    int top = this._mergeMatrix.getTopConnectedRow(blockTop, blockLeft, right);
                    if (right >= this._spreadsheet.getCurrentMaxVisibleColumns()) {
                        right = this._spreadsheet.getCurrentMaxVisibleColumns() - 1;
                    }
                    if (bottom >= this._spreadsheet.getCurrentMaxVisibleRows()) {
                        bottom = this._spreadsheet.getCurrentMaxVisibleRows() - 1;
                    }
                    if (bottom > blockBottom) {
                        result = this.loadSouth(sheet, type, blockLeft, blockTop, blockRight, blockBottom, bottom - blockBottom, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("South", "", sheetId, result.json.toJSONString());
                    }
                    if (top < blockTop) {
                        result = this.loadNorth(sheet, type, blockLeft, blockTop, blockRight, bottom, blockTop - top, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("North", "", sheetId, result.json.toJSONString());
                    }
                    int size = right - blockRight;
                    LoadResult result2 = this.loadEast(sheet, type, blockLeft, top, blockRight, bottom, size, -1, cacheRangeFetchTopHeight, cacheRangeFetchBtmHeight);
                    this.syncLoadedRect(result2);
                    this.responseDataBlock("East", token, sheetId, result2.json.toJSONString());
                } else if ("south".equals(direction)) {
                    LoadResult result;
                    int bottom = blockBottom + fetchHeight;
                    bottom = this._mergeMatrix.getBottomConnectedRow(bottom, blockLeft, blockRight);
                    int right = this._mergeMatrix.getRightConnectedColumn(blockRight, blockTop, bottom);
                    int left = this._mergeMatrix.getLeftConnectedColumn(blockLeft, blockTop, bottom);
                    if (right >= this._spreadsheet.getCurrentMaxVisibleColumns()) {
                        right = this._spreadsheet.getCurrentMaxVisibleColumns() - 1;
                    }
                    if (bottom >= this._spreadsheet.getCurrentMaxVisibleRows()) {
                        bottom = this._spreadsheet.getCurrentMaxVisibleRows() - 1;
                    }
                    if (right > blockRight) {
                        result = this.loadEast(sheet, type, blockLeft, blockTop, blockRight, blockBottom, right - blockRight, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("East", "", sheetId, result.json.toJSONString());
                    }
                    if (left < blockLeft) {
                        result = this.loadWest(sheet, type, blockLeft, blockTop, right, blockBottom, blockLeft - left, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("West", "", sheetId, result.json.toJSONString());
                    }
                    int size = bottom - blockBottom;
                    LoadResult result3 = this.loadSouth(sheet, type, left, blockTop, right, blockBottom, size, -1, -1, -1);
                    this.syncLoadedRect(result3);
                    this.responseDataBlock("South", token, sheetId, result3.json.toJSONString());
                } else if ("west".equals(direction)) {
                    LoadResult result;
                    int left = blockLeft - fetchWidth;
                    left = this._mergeMatrix.getLeftConnectedColumn(left, blockTop, blockBottom);
                    int bottom = this._mergeMatrix.getBottomConnectedRow(blockBottom, left, blockRight);
                    int top = this._mergeMatrix.getTopConnectedRow(blockTop, left, blockRight);
                    if (bottom >= this._spreadsheet.getCurrentMaxVisibleRows()) {
                        bottom = this._spreadsheet.getCurrentMaxVisibleRows() - 1;
                    }
                    if (bottom > blockBottom) {
                        result = this.loadSouth(sheet, type, blockLeft, blockTop, blockRight, blockBottom, bottom - blockBottom, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("South", "", sheetId, result.json.toJSONString());
                    }
                    if (top < blockTop) {
                        result = this.loadNorth(sheet, type, blockLeft, blockTop, blockRight, bottom, blockTop - top, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("North", "", sheetId, result.json.toJSONString());
                    }
                    int size = blockLeft - left;
                    LoadResult result4 = this.loadWest(sheet, type, blockLeft, blockTop, blockRight, blockBottom, size, -1, cacheRangeFetchTopHeight, cacheRangeFetchBtmHeight);
                    this.syncLoadedRect(result4);
                    this.responseDataBlock("West", token, sheetId, result4.json.toJSONString());
                } else if ("north".equals(direction)) {
                    LoadResult result;
                    int top = blockTop - fetchHeight;
                    top = this._mergeMatrix.getTopConnectedRow(top, blockLeft, blockRight);
                    int right = this._mergeMatrix.getRightConnectedColumn(blockRight, top, blockBottom);
                    int left = this._mergeMatrix.getLeftConnectedColumn(blockLeft, top, blockBottom);
                    if (right >= this._spreadsheet.getCurrentMaxVisibleColumns()) {
                        right = this._spreadsheet.getCurrentMaxVisibleColumns() - 1;
                    }
                    if (right > blockRight) {
                        result = this.loadEast(sheet, type, blockLeft, blockTop, blockRight, blockBottom, right - blockRight, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("East", "", sheetId, result.json.toJSONString());
                    }
                    if (left < blockLeft) {
                        result = this.loadWest(sheet, type, blockLeft, blockTop, right, blockBottom, blockLeft - left, -1, -1, -1);
                        this.syncLoadedRect(result);
                        this.responseDataBlock("West", "", sheetId, result.json.toJSONString());
                    }
                    int size = blockTop - top;
                    LoadResult result5 = this.loadNorth(sheet, type, left, blockTop, right, blockBottom, size, -1, -1, -1);
                    this.syncLoadedRect(result5);
                    this.responseDataBlock("North", token, sheetId, result5.json.toJSONString());
                }
            } else if ("visible".equals(type)) {
                this.loadForVisible((Spreadsheet)comp, sheetId, sheet, type, dpWidth, dpHeight, viewWidth, viewHeight, blockLeft, blockTop, blockRight, blockBottom, visibleLeft, visibleTop, visibleRight, visibleBottom, fetchWidth, fetchHeight);
                String ack = this.ackResult();
                this.responseDataBlock(null, token, sheetId, ack);
            } else {
                log.warning("unknow type:" + type);
            }
        }
        catch (Throwable x) {
            this.responseDataBlock("Error", "", sheetId, this.ackError(x.getMessage()));
            throw new UiException(x.getMessage(), x);
        }
        ((SpreadsheetInCtrl)((Object)this._ctrl)).setLoadedRect(this._loadedLeft < cacheLeft ? this._loadedLeft : cacheLeft, this._loadedTop < cacheTop ? this._loadedTop : cacheTop, this._loadedRight > cacheRight ? this._loadedRight : cacheRight, this._loadedBottom > cacheBottom ? this._loadedBottom : cacheBottom);
        ((SpreadsheetInCtrl)((Object)this._ctrl)).setVisibleRect(this._lastleft, this._lasttop, this._lastright, this._lastbottom);
    }

    private void loadForVisible(Spreadsheet spreadsheet, String sheetId, SSheet sheet, String type, int dpWidth, int dpHeight, int viewWidth, int viewHeight, int blockLeft, int blockTop, int blockRight, int blockBottom, int visibleLeft, int visibleTop, int visibleRight, int visibleBottom, int cacheRangeWidth, int cacheRangeHeight) {
        int size;
        LoadResult result;
        boolean loadNorth;
        if (visibleRight > spreadsheet.getCurrentMaxVisibleColumns() - 1) {
            visibleRight = spreadsheet.getCurrentMaxVisibleColumns() - 1;
        }
        if (visibleBottom > spreadsheet.getCurrentMaxVisibleRows() - 1) {
            visibleBottom = spreadsheet.getCurrentMaxVisibleRows() - 1;
        }
        int left = Math.min(visibleLeft, blockLeft);
        int top = Math.min(visibleTop, blockTop);
        int right = Math.max(visibleRight, blockRight);
        int bottom = Math.max(visibleBottom, blockBottom);
        int cacheRangeRight = -1;
        int cacheRangeLeft = -1;
        boolean loadEast = right > blockRight;
        boolean loadWest = left < blockLeft;
        boolean loadSouth = bottom > blockBottom;
        boolean bl = loadNorth = top < blockTop;
        if (loadEast) {
            if ((right = this._mergeMatrix.getRightConnectedColumn(right, top, bottom)) >= spreadsheet.getCurrentMaxVisibleColumns()) {
                right = spreadsheet.getCurrentMaxVisibleColumns() - 1;
            }
            int width = right - blockRight;
            result = this.loadEast(sheet, type, blockLeft, blockTop, blockRight, blockBottom, width, cacheRangeWidth, -1, loadSouth && cacheRangeHeight > 0 ? -1 : cacheRangeHeight);
            cacheRangeRight = result.loadedRight;
            this.syncLoadedRect(result);
            this.responseDataBlock("East", "", sheetId, result.json.toJSONString());
            blockRight += width;
        }
        if (loadWest) {
            left = this._mergeMatrix.getLeftConnectedColumn(left, top, bottom);
            size = blockLeft - left;
            result = this.loadWest(sheet, type, blockLeft, blockTop, right, blockBottom, size, cacheRangeWidth, -1, loadSouth && cacheRangeHeight > 0 ? -1 : cacheRangeHeight);
            cacheRangeLeft = result.loadedLeft;
            this.syncLoadedRect(result);
            this.responseDataBlock("West", "", sheetId, result.json.toJSONString());
            blockLeft -= size;
        }
        if (loadSouth) {
            if ((bottom = this._mergeMatrix.getBottomConnectedRow(bottom, left, right)) >= spreadsheet.getCurrentMaxVisibleRows()) {
                bottom = spreadsheet.getCurrentMaxVisibleRows() - 1;
            }
            int height = bottom - blockBottom;
            result = this.loadSouth(sheet, type, left, blockTop, right, blockBottom, height, cacheRangeLeft, blockRight + cacheRangeWidth - 1, cacheRangeHeight);
            visibleBottom = result.loadedBottom;
            this.syncLoadedRect(result);
            this.responseDataBlock("South", "", sheetId, result.json.toJSONString());
            blockBottom += height;
        }
        if (loadNorth) {
            top = this._mergeMatrix.getTopConnectedRow(top, left, right);
            size = blockTop - top;
            result = this.loadNorth(sheet, type, left, blockTop, right, bottom, size, cacheRangeLeft, blockRight + cacheRangeWidth - 1, cacheRangeHeight);
            this.syncLoadedRect(result);
            this.responseDataBlock("North", "", sheetId, result.json.toJSONString());
            blockTop -= size;
        }
    }

    private void syncLoadedRect(LoadResult loadResult) {
        this._loadedLeft = loadResult.loadedLeft;
        this._loadedRight = loadResult.loadedRight;
        this._loadedTop = loadResult.loadedTop;
        this._loadedBottom = loadResult.loadedBottom;
    }

    private String ackResult() {
        JSONObj jresult = new JSONObj();
        jresult.setData("type", "ack");
        return jresult.toString();
    }

    private String ackError(String message) {
        JSONObj jresult = new JSONObj();
        jresult.setData("type", "error");
        jresult.setData("message", message);
        return jresult.toString();
    }

    private String jumpResult(Spreadsheet spreadsheet, SSheet sheet, int left, int top, int right, int bottom) {
        int fzc;
        int preloadSize;
        int newRight;
        int newTop;
        top = this._mergeMatrix.getTopConnectedRow(top, left, right);
        bottom = this._mergeMatrix.getBottomConnectedRow(bottom, left, right);
        right = this._mergeMatrix.getRightConnectedColumn(right, top, bottom);
        left = this._mergeMatrix.getLeftConnectedColumn(left, top, bottom);
        if (right >= spreadsheet.getCurrentMaxVisibleColumns()) {
            right = spreadsheet.getCurrentMaxVisibleColumns() - 1;
        }
        if (bottom >= spreadsheet.getCurrentMaxVisibleRows()) {
            bottom = spreadsheet.getCurrentMaxVisibleRows() - 1;
        }
        int w = right - left + 1;
        int h = bottom - top + 1;
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"jump");
        json.put((Object)"left", (Object)left);
        json.put((Object)"top", (Object)top);
        json.put((Object)"width", (Object)w);
        json.put((Object)"height", (Object)h);
        SpreadsheetCtrl.Header header = SpreadsheetCtrl.Header.NONE;
        if (!this._hidecolhead && !this._hiderowhead) {
            header = SpreadsheetCtrl.Header.BOTH;
        } else if (!this._hidecolhead) {
            header = SpreadsheetCtrl.Header.COLUMN;
        } else if (!this._hiderowhead) {
            header = SpreadsheetCtrl.Header.ROW;
        }
        int preloadColSize = this._spreadsheet.getPreloadColumnSize();
        int preloadRowSize = this._spreadsheet.getPreloadRowSize();
        int re = top + h;
        int ce = left + w;
        int rangeLeft = left;
        int rangeRight = right;
        int rangeTop = top;
        int rangeBtm = bottom;
        if (preloadColSize > 0 && preloadRowSize > 0) {
            int newLeft = Math.max(rangeLeft - (preloadColSize /= 2), 0);
            newTop = Math.max(rangeTop - (preloadRowSize /= 2), 0);
            newRight = Math.min(rangeRight + preloadColSize, this._spreadsheet.getCurrentMaxVisibleColumns() - 1);
            int newBtm = Math.min(rangeBtm + preloadRowSize, this._spreadsheet.getCurrentMaxVisibleRows() - 1);
            rangeTop = this._mergeMatrix.getTopConnectedRow(newTop, newLeft, newRight);
            rangeBtm = this._mergeMatrix.getBottomConnectedRow(newBtm, newLeft, newRight);
            rangeRight = this._mergeMatrix.getRightConnectedColumn(newRight, newTop, newBtm);
            rangeLeft = this._mergeMatrix.getLeftConnectedColumn(newLeft, newTop, newBtm);
        } else if (preloadColSize > 0) {
            preloadSize = preloadColSize / 2;
            int newLeft = Math.max(rangeLeft - preloadSize, 0);
            newRight = Math.min(rangeRight + preloadSize, this._spreadsheet.getCurrentMaxVisibleColumns() - 1);
            rangeLeft = this._mergeMatrix.getLeftConnectedColumn(newLeft, rangeTop, rangeBtm);
            rangeRight = this._mergeMatrix.getRightConnectedColumn(newRight, rangeTop, rangeBtm);
        } else if (preloadRowSize > 0) {
            preloadSize = preloadRowSize / 2;
            newTop = Math.max(rangeTop - preloadSize, 0);
            int newBtm = Math.min(rangeBtm + preloadSize, this._spreadsheet.getCurrentMaxVisibleRows() - 1);
            rangeTop = this._mergeMatrix.getTopConnectedRow(newTop, rangeLeft, rangeRight);
            rangeBtm = this._mergeMatrix.getBottomConnectedRow(newBtm, rangeLeft, rangeRight);
        }
        if (rangeBtm >= this._spreadsheet.getCurrentMaxVisibleRows()) {
            rangeBtm = this._spreadsheet.getCurrentMaxVisibleRows() - 1;
        }
        if (rangeRight >= this._spreadsheet.getCurrentMaxVisibleColumns()) {
            rangeRight = this._spreadsheet.getCurrentMaxVisibleColumns() - 1;
        }
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this._spreadsheet.getExtraCtrl();
        JSONObject mainBlock = spreadsheetCtrl.getRangeAttrs(sheet, header, SpreadsheetCtrl.CellAttribute.ALL, rangeLeft, rangeTop, rangeRight, rangeBtm);
        mainBlock.put((Object)"dir", (Object)"jump");
        json.put((Object)"data", (Object)mainBlock);
        this._lastleft = left;
        this._lastright = right;
        this._lasttop = top;
        this._lastbottom = bottom;
        this._loadedLeft = rangeLeft;
        this._loadedRight = rangeRight;
        this._loadedTop = rangeTop;
        this._loadedRight = rangeBtm;
        FreezeInfoLoader freezeInfo = spreadsheetCtrl.getFreezeInfoLoader();
        int fzr = freezeInfo.getRowFreeze(sheet);
        if (fzr > -1) {
            mainBlock.put((Object)"topFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, header, SpreadsheetCtrl.CellAttribute.ALL, rangeLeft, 0, rangeRight, fzr));
        }
        if ((fzc = freezeInfo.getColumnFreeze(sheet)) > -1) {
            mainBlock.put((Object)"leftFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, header, SpreadsheetCtrl.CellAttribute.ALL, 0, rangeTop, fzc, rangeBtm));
        }
        return json.toString();
    }

    private String jump(String dir, Spreadsheet spreadsheet, String sheetId, SSheet sheet, String type, int dpWidth, int dpHeight, int viewWidth, int viewHeight, int blockLeft, int blockTop, int blockRight, int blockBottom, int col, int row, int rangeLeft, int rangeTop, int rangeRight, int rangeBottom) {
        int top;
        int bottom;
        int left;
        int right;
        if (dir.indexOf("E") >= 0) {
            right = col + 1;
            left = this._colHelper.getCellIndex(this._colHelper.getStartPixel(col) - viewWidth);
        } else if (dir.indexOf("W") >= 0) {
            left = col <= 0 ? 0 : col - 1;
            right = this._colHelper.getCellIndex(this._colHelper.getStartPixel(col) + viewWidth);
        } else {
            left = blockLeft;
            right = blockRight;
        }
        if (dir.indexOf("S") >= 0) {
            bottom = row + 1;
            top = this._rowHelper.getCellIndex(this._rowHelper.getStartPixel(row) - viewHeight);
        } else if (dir.indexOf("N") >= 0) {
            top = row <= 0 ? 0 : row - 1;
            bottom = this._rowHelper.getCellIndex(this._rowHelper.getStartPixel(row) + viewHeight);
        } else {
            top = blockTop;
            bottom = blockBottom;
        }
        return this.jumpResult(spreadsheet, sheet, left, top, right, bottom);
    }

    private LoadResult loadEast(SSheet sheet, String type, int blockLeft, int blockTop, int blockRight, int blockBottom, int fetchWidth, int rangeWidth, int rangeTopHeight, int rangeBtmHeight) {
        int rangeTop;
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"neighbor");
        json.put((Object)"width", (Object)fetchWidth);
        json.put((Object)"height", (Object)(blockBottom - blockTop + 1));
        int cs = blockRight + 1;
        int ce = blockRight + fetchWidth;
        json.put((Object)"top", (Object)blockTop);
        json.put((Object)"left", (Object)cs);
        int n = rangeTop = rangeTopHeight > 0 ? blockTop - rangeTopHeight : blockTop;
        if (rangeTop < 0) {
            rangeTop = 0;
        }
        int rangeRight = rangeWidth > fetchWidth ? cs + rangeWidth - 1 : ce;
        int rangeBottom = rangeBtmHeight < 0 ? blockBottom : blockBottom + rangeBtmHeight;
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this._spreadsheet.getExtraCtrl();
        JSONObject mainBlock = spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.COLUMN, SpreadsheetCtrl.CellAttribute.ALL, cs, rangeTop, rangeRight, rangeBottom);
        mainBlock.put((Object)"dir", (Object)"east");
        json.put((Object)"data", (Object)mainBlock);
        this._lastleft = blockLeft;
        this._lastright = ce;
        this._lasttop = blockTop;
        this._lastbottom = blockBottom;
        int fzr = spreadsheetCtrl.getFreezeInfoLoader().getRowFreeze(sheet);
        if (fzr > -1) {
            mainBlock.put((Object)"topFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, cs, 0, rangeRight, fzr));
        }
        return new LoadResult(cs, rangeTop, rangeRight, rangeBottom, json);
    }

    private LoadResult loadWest(SSheet sheet, String type, int blockLeft, int blockTop, int blockRight, int blockBottom, int fetchWidth, int rangeWidth, int rangeTopHeight, int rangeBtmHeight) {
        int rangeLeft;
        int rangeTop;
        int ce;
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"neighbor");
        json.put((Object)"width", (Object)fetchWidth);
        json.put((Object)"height", (Object)(blockBottom - blockTop + 1));
        int cs = blockLeft - 1;
        if (cs < 0) {
            cs = 0;
        }
        if ((ce = blockLeft - fetchWidth) < 0) {
            ce = 0;
        }
        json.put((Object)"top", (Object)blockTop);
        json.put((Object)"left", (Object)ce);
        int n = rangeTop = rangeTopHeight > 0 ? blockTop - rangeTopHeight : blockTop;
        if (rangeTop < 0) {
            rangeTop = 0;
        }
        int n2 = rangeLeft = rangeWidth > fetchWidth ? blockLeft - rangeWidth : ce;
        if (rangeLeft < 0) {
            rangeLeft = 0;
        }
        int rangeBottom = rangeBtmHeight < 0 ? blockBottom : blockBottom + rangeBtmHeight;
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this._spreadsheet.getExtraCtrl();
        JSONObject mainBlock = spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.COLUMN, SpreadsheetCtrl.CellAttribute.ALL, rangeLeft, rangeTop, cs, rangeBottom);
        mainBlock.put((Object)"dir", (Object)"west");
        json.put((Object)"data", (Object)mainBlock);
        this._lastleft = ce;
        this._lastright = blockRight;
        this._lasttop = blockTop;
        this._lastbottom = blockBottom;
        int fzr = spreadsheetCtrl.getFreezeInfoLoader().getRowFreeze(sheet);
        if (fzr > -1) {
            mainBlock.put((Object)"topFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, rangeLeft, 0, cs, fzr));
        }
        return new LoadResult(rangeLeft, rangeTop, cs, rangeBottom, json);
    }

    private LoadResult loadSouth(SSheet sheet, String type, int blockLeft, int blockTop, int blockRight, int blockBottom, int fetchHeight, int rangeLeft, int cacheRight, int cacheRangeHeight) {
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"neighbor");
        json.put((Object)"width", (Object)(blockRight - blockLeft + 1));
        json.put((Object)"height", (Object)fetchHeight);
        int rs = blockBottom + 1;
        int re = blockBottom + fetchHeight;
        json.put((Object)"top", (Object)rs);
        json.put((Object)"left", (Object)blockLeft);
        int rangeBottom = Math.min(cacheRangeHeight > fetchHeight ? rs + cacheRangeHeight - 1 : re, this._spreadsheet.getCurrentMaxVisibleRows() - 1);
        rangeLeft = rangeLeft > 0 && rangeLeft < blockLeft ? rangeLeft : blockLeft;
        cacheRight = Math.max(blockRight, cacheRight);
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this._spreadsheet.getExtraCtrl();
        JSONObject mainBlock = spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.ROW, SpreadsheetCtrl.CellAttribute.ALL, rangeLeft, rs, cacheRight, rangeBottom);
        mainBlock.put((Object)"dir", (Object)"south");
        json.put((Object)"data", (Object)mainBlock);
        this._lastleft = blockLeft;
        this._lastright = blockRight;
        this._lasttop = blockTop;
        this._lastbottom = re;
        int fzc = spreadsheetCtrl.getFreezeInfoLoader().getColumnFreeze(sheet);
        if (fzc > -1) {
            mainBlock.put((Object)"leftFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, 0, rs, fzc, rangeBottom));
        }
        return new LoadResult(rangeLeft, rs, cacheRight, rangeBottom, json);
    }

    private LoadResult loadNorth(SSheet sheet, String type, int blockLeft, int blockTop, int blockRight, int blockBottom, int fetchHeight, int rangeLeft, int rangeRight, int cacheRangeHeight) {
        int rangeTop;
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"neighbor");
        json.put((Object)"width", (Object)(blockRight - blockLeft + 1));
        json.put((Object)"height", (Object)fetchHeight);
        int rs = blockTop - 1;
        int re = blockTop - fetchHeight;
        if (rs < 0) {
            rs = 0;
        }
        if (re < 0) {
            re = 0;
        }
        json.put((Object)"top", (Object)re);
        json.put((Object)"left", (Object)blockLeft);
        int n = rangeTop = cacheRangeHeight > fetchHeight ? rs - cacheRangeHeight + 1 : re;
        if (rangeTop < 0) {
            rangeTop = 0;
        }
        rangeLeft = rangeLeft > 0 && rangeLeft < blockLeft ? rangeLeft : blockLeft;
        rangeRight = Math.max(blockRight, rangeRight);
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this._spreadsheet.getExtraCtrl();
        JSONObject mainBlock = spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.ROW, SpreadsheetCtrl.CellAttribute.ALL, rangeLeft, rangeTop, rangeRight, rs);
        mainBlock.put((Object)"dir", (Object)"north");
        json.put((Object)"data", (Object)mainBlock);
        this._lastleft = blockLeft;
        this._lastright = blockRight;
        this._lasttop = re;
        this._lastbottom = blockBottom;
        int frc = spreadsheetCtrl.getFreezeInfoLoader().getColumnFreeze(sheet);
        if (frc > -1) {
            mainBlock.put((Object)"leftFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, 0, rangeTop, frc, rs));
        }
        return new LoadResult(rangeLeft, rangeTop, rangeRight, rs, json);
    }

    private class LoadResult {
        int loadedTop;
        int loadedLeft;
        int loadedBottom;
        int loadedRight;
        JSONObject json;

        LoadResult(int left, int top, int right, int bottom, JSONObject json) {
            this.loadedLeft = left;
            this.loadedTop = top;
            this.loadedRight = right;
            this.loadedBottom = bottom;
            this.json = json;
        }
    }
}

