/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation;

import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class ResetCPMemberOp
extends Operation
implements RaftSystemOperation,
IdentifiedDataSerializable {
    private long seed;

    public ResetCPMemberOp() {
    }

    public ResetCPMemberOp(long seed) {
        this.seed = seed;
    }

    @Override
    public CallStatus call() throws Exception {
        return new OffloadImpl();
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 40;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.seed);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.seed = in.readLong();
    }

    private class ResetLocalTask
    implements Runnable {
        private ResetLocalTask() {
        }

        @Override
        public void run() {
            RaftService service = (RaftService)ResetCPMemberOp.this.getService();
            try {
                service.resetLocal(ResetCPMemberOp.this.seed);
                ResetCPMemberOp.this.sendResponse(null);
            }
            catch (Exception e) {
                ResetCPMemberOp.this.sendResponse(e);
            }
        }
    }

    private final class OffloadImpl
    extends Offload {
        private OffloadImpl() {
            super(ResetCPMemberOp.this);
        }

        @Override
        public void start() {
            ResetCPMemberOp.this.getNodeEngine().getExecutionService().execute("hz:system", new ResetLocalTask());
        }
    }
}

