/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.usermodel;

import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Pair;

public final class BuiltinFormats {
    public static final int FIRST_USER_DEFINED_FORMAT_INDEX = 164;
    private static final String[] _formats;
    private static final CacheMap _dateFormat;

    private static void putFormat(List<String> m, int index, String value) {
        if (m.size() != index) {
            throw new IllegalStateException("index " + index + " is wrong");
        }
        m.add(value);
    }

    public static Map<Integer, String> getBuiltinFormats() {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < _formats.length; ++i) {
            result.put(i, _formats[i]);
        }
        return result;
    }

    public static String[] getAll() {
        return (String[])_formats.clone();
    }

    public static String getBuiltinFormat(int index) {
        if (index < 0 || index >= _formats.length) {
            return null;
        }
        return _formats[index];
    }

    public static int getBuiltinFormat(String pFmt) {
        String fmt = pFmt.equalsIgnoreCase("TEXT") ? "@" : pFmt;
        for (int i = 0; i < _formats.length; ++i) {
            if (!fmt.equals(_formats[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getBuiltinFormat(int index, Locale locale) {
        String fmt = BuiltinFormats.getBuiltinFormat(index);
        if (fmt == null && index != 256) {
            return null;
        }
        if (Locale.US.equals(locale)) {
            return fmt;
        }
        switch (index) {
            case 15: 
            case 16: 
            case 17: {
                fmt = BuiltinFormats.getNameMonthFormat(index, locale);
                break;
            }
            case 14: 
            case 19: 
            case 22: 
            case 256: {
                fmt = BuiltinFormats.getNumMonthFormat(index, locale);
            }
        }
        return fmt;
    }

    private static String getNameMonthFormat(int formatType, Locale locale) {
        Pair key = new Pair((Object)locale, (Object)formatType);
        String result = (String)_dateFormat.get((Object)key);
        if (result != null) {
            return result;
        }
        boolean noyear = false;
        boolean noday = false;
        switch (formatType) {
            case 15: {
                break;
            }
            case 16: {
                noyear = true;
                break;
            }
            case 17: {
                noday = true;
            }
        }
        DateFormat format = DateFormat.getDateInstance(1, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        int dcount = 0;
        int mcount = 0;
        int ycount = 0;
        int cindex = -2;
        char c = iter.first();
        while (c != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                if (mcount > 0 || dcount > 0 || ycount > 0) {
                    if (cindex < 0) {
                        cindex = sb.length();
                    }
                    sb.append(c);
                }
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (!noday) {
                                sb.append('d');
                                ++dcount;
                            } else if (cindex >= 0) {
                                sb.delete(cindex, sb.length());
                            }
                            cindex = -2;
                            break;
                        }
                        case 1: {
                            if (!noyear) {
                                if (ycount < 2) {
                                    sb.append('y');
                                    ++ycount;
                                }
                            } else if (cindex >= 0) {
                                sb.delete(cindex, sb.length());
                            }
                            cindex = -2;
                            break;
                        }
                        case 2: {
                            if (mcount < 3) {
                                sb.append('m');
                                ++mcount;
                            }
                            cindex = -2;
                        }
                    }
                }
            }
            c = iter.next();
        }
        if ((noday || noyear) && cindex > 0) {
            sb.delete(cindex, sb.length());
        }
        String formatString = sb.toString();
        _dateFormat.put((Object)key, (Object)formatString);
        return formatString;
    }

    private static String getNumMonthFormat(int formatType, Locale locale) {
        Pair key = new Pair((Object)locale, (Object)formatType);
        String result = (String)_dateFormat.get((Object)key);
        if (result != null) {
            return result;
        }
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        DateFormat format = null;
        switch (formatType) {
            case 19: {
                if ("zh".equals(locale.getLanguage())) {
                    String formatString = "hh:mm:ss AM/PM";
                    _dateFormat.put((Object)key, (Object)"hh:mm:ss AM/PM");
                    return "hh:mm:ss AM/PM";
                }
                format = DateFormat.getTimeInstance(2, locale);
                break;
            }
            case 14: {
                format = DateFormat.getDateInstance(2, locale);
                break;
            }
            case 22: {
                format = DateFormat.getDateTimeInstance(2, 3, locale);
                break;
            }
            case 256: {
                if ("zh".equals(locale.getLanguage())) {
                    String formatString = "yyyy/m/d hh:mm:ss AM/PM";
                    _dateFormat.put((Object)key, (Object)"yyyy/m/d hh:mm:ss AM/PM");
                    return "yyyy/m/d hh:mm:ss AM/PM";
                }
                format = DateFormat.getDateTimeInstance(2, 2, locale);
            }
        }
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(1234, 5, 6, 7, 8, 9);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        int ycount = 0;
        int yindex = -1;
        int mcount = 0;
        boolean alreadyAMPM = false;
        char c = iter.first();
        while (c != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                sb.append(c);
            } else {
                block16: for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            sb.append('d');
                            continue block16;
                        }
                        case 1: {
                            yindex = sb.length();
                            sb.append('y');
                            ++ycount;
                            continue block16;
                        }
                        case 10: 
                        case 11: {
                            sb.append('h');
                            continue block16;
                        }
                        case 2: {
                            if (mcount >= 2) continue block16;
                            sb.append('m');
                            ++mcount;
                            continue block16;
                        }
                        case 12: {
                            sb.append('m');
                            continue block16;
                        }
                        case 13: {
                            sb.append('s');
                            continue block16;
                        }
                        case 0: 
                        case 9: {
                            if (alreadyAMPM) continue block16;
                            sb.append("AM/PM");
                            alreadyAMPM = true;
                            continue block16;
                        }
                    }
                    if (!DateFormat.Field.HOUR1.equals(field) && !DateFormat.Field.HOUR_OF_DAY1.equals(field) && !DateFormat.Field.HOUR0.equals(field) && !DateFormat.Field.HOUR_OF_DAY0.equals(field)) continue;
                    sb.append('h');
                }
            }
            c = iter.next();
        }
        if (yindex >= 0) {
            for (int k = ycount; k < 4; ++k) {
                sb.insert(yindex, 'y');
            }
        }
        String formatString = sb.toString();
        _dateFormat.put((Object)key, (Object)formatString);
        return formatString;
    }

    static {
        ArrayList<String> m = new ArrayList<String>();
        BuiltinFormats.putFormat(m, 0, "General");
        BuiltinFormats.putFormat(m, 1, "0");
        BuiltinFormats.putFormat(m, 2, "0.00");
        BuiltinFormats.putFormat(m, 3, "#,##0");
        BuiltinFormats.putFormat(m, 4, "#,##0.00");
        BuiltinFormats.putFormat(m, 5, "\"$\"#,##0_);\\(\"$\"#,##0\\)");
        BuiltinFormats.putFormat(m, 6, "\"$\"#,##0_);[Red]\\(\"$\"#,##0\\)");
        BuiltinFormats.putFormat(m, 7, "\"$\"#,##0.00_);\\(\"$\"#,##0.00\\)");
        BuiltinFormats.putFormat(m, 8, "\"$\"#,##0.00_);[Red]\\(\"$\"#,##0.00\\)");
        BuiltinFormats.putFormat(m, 9, "0%");
        BuiltinFormats.putFormat(m, 10, "0.00%");
        BuiltinFormats.putFormat(m, 11, "0.00E+00");
        BuiltinFormats.putFormat(m, 12, "# ?/?");
        BuiltinFormats.putFormat(m, 13, "# ??/??");
        BuiltinFormats.putFormat(m, 14, "m/d/yyyy");
        BuiltinFormats.putFormat(m, 15, "d-mmm-yy");
        BuiltinFormats.putFormat(m, 16, "d-mmm");
        BuiltinFormats.putFormat(m, 17, "mmm-yy");
        BuiltinFormats.putFormat(m, 18, "h:mm AM/PM");
        BuiltinFormats.putFormat(m, 19, "h:mm:ss AM/PM");
        BuiltinFormats.putFormat(m, 20, "h:mm");
        BuiltinFormats.putFormat(m, 21, "h:mm:ss");
        BuiltinFormats.putFormat(m, 22, "m/d/yyyy h:mm");
        for (int i = 23; i <= 36; ++i) {
            BuiltinFormats.putFormat(m, i, "reserved-0x" + Integer.toHexString(i));
        }
        BuiltinFormats.putFormat(m, 37, "#,##0_);\\(#,##0\\)");
        BuiltinFormats.putFormat(m, 38, "#,##0_);[Red]\\(#,##0\\)");
        BuiltinFormats.putFormat(m, 39, "#,##0.00_);\\(#,##0.00\\)");
        BuiltinFormats.putFormat(m, 40, "#,##0.00_);[Red]\\(#,##0.00\\)");
        BuiltinFormats.putFormat(m, 41, "_(* #,##0_);_(* \\(#,##0\\);_(* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(m, 42, "_(\"$\"* #,##0_);_(\"$\"* \\(#,##0\\);_(\"$\"* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(m, 43, "_(* #,##0.00_);_(* \\(#,##0.00\\);_(* \"-\"??_);_(@_)");
        BuiltinFormats.putFormat(m, 44, "_(\"$\"* #,##0.00_);_(\"$\"* \\(#,##0.00\\);_(\"$\"* \"-\"??_);_(@_)");
        BuiltinFormats.putFormat(m, 45, "mm:ss");
        BuiltinFormats.putFormat(m, 46, "[h]:mm:ss");
        BuiltinFormats.putFormat(m, 47, "mm:ss.0");
        BuiltinFormats.putFormat(m, 48, "##0.0E+0");
        BuiltinFormats.putFormat(m, 49, "@");
        String[] ss = new String[m.size()];
        m.toArray(ss);
        _formats = ss;
        _dateFormat = new CacheMap(8);
        _dateFormat.setLifetime(86400000);
    }
}

