/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.poifs.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.zkoss.poi.poifs.common.POIFSBigBlockSize;
import org.zkoss.poi.poifs.common.POIFSConstants;
import org.zkoss.poi.poifs.dev.POIFSViewable;
import org.zkoss.poi.poifs.filesystem.BATManaged;
import org.zkoss.poi.poifs.filesystem.DocumentOutputStream;
import org.zkoss.poi.poifs.filesystem.POIFSDocumentPath;
import org.zkoss.poi.poifs.filesystem.POIFSWriterEvent;
import org.zkoss.poi.poifs.filesystem.POIFSWriterListener;
import org.zkoss.poi.poifs.property.DocumentProperty;
import org.zkoss.poi.poifs.property.Property;
import org.zkoss.poi.poifs.storage.BlockWritable;
import org.zkoss.poi.poifs.storage.DataInputBlock;
import org.zkoss.poi.poifs.storage.DocumentBlock;
import org.zkoss.poi.poifs.storage.ListManagedBlock;
import org.zkoss.poi.poifs.storage.RawDataBlock;
import org.zkoss.poi.poifs.storage.SmallDocumentBlock;
import org.zkoss.poi.util.HexDump;

public final class POIFSDocument
implements BATManaged,
BlockWritable,
POIFSViewable {
    private static final DocumentBlock[] EMPTY_BIG_BLOCK_ARRAY = new DocumentBlock[0];
    private static final SmallDocumentBlock[] EMPTY_SMALL_BLOCK_ARRAY = new SmallDocumentBlock[0];
    private DocumentProperty _property;
    private int _size;
    private final POIFSBigBlockSize _bigBigBlockSize;
    private SmallBlockStore _small_store;
    private BigBlockStore _big_store;

    public POIFSDocument(String name, RawDataBlock[] blocks, int length) throws IOException {
        this._size = length;
        this._bigBigBlockSize = blocks.length == 0 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : (blocks[0].getBigBlockSize() == 512 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : POIFSConstants.LARGER_BIG_BLOCK_SIZE_DETAILS);
        this._big_store = new BigBlockStore(this._bigBigBlockSize, POIFSDocument.convertRawBlocksToBigBlocks(blocks));
        this._property = new DocumentProperty(name, this._size);
        this._small_store = new SmallBlockStore(this._bigBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        this._property.setDocument(this);
    }

    private static DocumentBlock[] convertRawBlocksToBigBlocks(ListManagedBlock[] blocks) throws IOException {
        DocumentBlock[] result = new DocumentBlock[blocks.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new DocumentBlock((RawDataBlock)blocks[i]);
        }
        return result;
    }

    private static SmallDocumentBlock[] convertRawBlocksToSmallBlocks(ListManagedBlock[] blocks) {
        if (blocks instanceof SmallDocumentBlock[]) {
            return (SmallDocumentBlock[])blocks;
        }
        SmallDocumentBlock[] result = new SmallDocumentBlock[blocks.length];
        System.arraycopy(blocks, 0, result, 0, blocks.length);
        return result;
    }

    public POIFSDocument(String name, SmallDocumentBlock[] blocks, int length) {
        this._size = length;
        this._bigBigBlockSize = blocks.length == 0 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : blocks[0].getBigBlockSize();
        this._big_store = new BigBlockStore(this._bigBigBlockSize, EMPTY_BIG_BLOCK_ARRAY);
        this._property = new DocumentProperty(name, this._size);
        this._small_store = new SmallBlockStore(this._bigBigBlockSize, blocks);
        this._property.setDocument(this);
    }

    public POIFSDocument(String name, POIFSBigBlockSize bigBlockSize, ListManagedBlock[] blocks, int length) throws IOException {
        this._size = length;
        this._bigBigBlockSize = bigBlockSize;
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (Property.isSmall(this._size)) {
            this._big_store = new BigBlockStore(bigBlockSize, EMPTY_BIG_BLOCK_ARRAY);
            this._small_store = new SmallBlockStore(bigBlockSize, POIFSDocument.convertRawBlocksToSmallBlocks(blocks));
        } else {
            this._big_store = new BigBlockStore(bigBlockSize, POIFSDocument.convertRawBlocksToBigBlocks(blocks));
            this._small_store = new SmallBlockStore(bigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        }
    }

    public POIFSDocument(String name, ListManagedBlock[] blocks, int length) throws IOException {
        this(name, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, blocks, length);
    }

    public POIFSDocument(String name, POIFSBigBlockSize bigBlockSize, InputStream stream) throws IOException {
        DocumentBlock block;
        ArrayList<DocumentBlock> blocks = new ArrayList<DocumentBlock>();
        this._size = 0;
        this._bigBigBlockSize = bigBlockSize;
        do {
            int blockSize;
            if ((blockSize = (block = new DocumentBlock(stream, bigBlockSize)).size()) <= 0) continue;
            blocks.add(block);
            this._size += blockSize;
        } while (!block.partiallyRead());
        BlockWritable[] bigBlocks = blocks.toArray(new DocumentBlock[blocks.size()]);
        this._big_store = new BigBlockStore(bigBlockSize, (DocumentBlock[])bigBlocks);
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(bigBlockSize, SmallDocumentBlock.convert(bigBlockSize, bigBlocks, this._size));
            this._big_store = new BigBlockStore(bigBlockSize, new DocumentBlock[0]);
        } else {
            this._small_store = new SmallBlockStore(bigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        }
    }

    public POIFSDocument(String name, InputStream stream) throws IOException {
        this(name, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, stream);
    }

    public POIFSDocument(String name, int size, POIFSBigBlockSize bigBlockSize, POIFSDocumentPath path, POIFSWriterListener writer) {
        this._size = size;
        this._bigBigBlockSize = bigBlockSize;
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(this._bigBigBlockSize, path, name, size, writer);
            this._big_store = new BigBlockStore(this._bigBigBlockSize, EMPTY_BIG_BLOCK_ARRAY);
        } else {
            this._small_store = new SmallBlockStore(this._bigBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
            this._big_store = new BigBlockStore(this._bigBigBlockSize, path, name, size, writer);
        }
    }

    public POIFSDocument(String name, int size, POIFSDocumentPath path, POIFSWriterListener writer) {
        this(name, size, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, path, writer);
    }

    public BlockWritable[] getSmallBlocks() {
        return this._small_store.getBlocks();
    }

    public int getSize() {
        return this._size;
    }

    void read(byte[] buffer, int offset) {
        int len = buffer.length;
        DataInputBlock currentBlock = this.getDataInputBlock(offset);
        int blockAvailable = currentBlock.available();
        if (blockAvailable > len) {
            currentBlock.readFully(buffer, 0, len);
            return;
        }
        int remaining = len;
        int writePos = 0;
        int currentOffset = offset;
        while (remaining > 0) {
            boolean blockIsExpiring = remaining >= blockAvailable;
            int reqSize = blockIsExpiring ? blockAvailable : remaining;
            currentBlock.readFully(buffer, writePos, reqSize);
            remaining -= reqSize;
            writePos += reqSize;
            currentOffset += reqSize;
            if (!blockIsExpiring) continue;
            if (currentOffset == this._size) {
                if (remaining > 0) {
                    throw new IllegalStateException("reached end of document stream unexpectedly");
                }
                currentBlock = null;
                break;
            }
            currentBlock = this.getDataInputBlock(currentOffset);
            blockAvailable = currentBlock.available();
        }
    }

    DataInputBlock getDataInputBlock(int offset) {
        if (offset >= this._size) {
            if (offset > this._size) {
                throw new RuntimeException("Request for Offset " + offset + " doc size is " + this._size);
            }
            return null;
        }
        if (this._property.shouldUseSmallBlocks()) {
            return SmallDocumentBlock.getDataInputBlock(this._small_store.getBlocks(), offset);
        }
        return DocumentBlock.getDataInputBlock(this._big_store.getBlocks(), offset);
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    @Override
    public void writeBlocks(OutputStream stream) throws IOException {
        this._big_store.writeBlocks(stream);
    }

    @Override
    public int countBlocks() {
        return this._big_store.countBlocks();
    }

    @Override
    public void setStartBlock(int index) {
        this._property.setStartBlock(index);
    }

    @Override
    public Object[] getViewableArray() {
        String result;
        Object[] results = new Object[1];
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            BlockWritable[] blocks = null;
            if (this._big_store.isValid()) {
                blocks = this._big_store.getBlocks();
            } else if (this._small_store.isValid()) {
                blocks = this._small_store.getBlocks();
            }
            if (blocks != null) {
                for (int k = 0; k < blocks.length; ++k) {
                    blocks[k].writeBlocks(output);
                }
                byte[] data = output.toByteArray();
                if (data.length > this._property.getSize()) {
                    byte[] tmp = new byte[this._property.getSize()];
                    System.arraycopy(data, 0, tmp, 0, tmp.length);
                    data = tmp;
                }
                output = new ByteArrayOutputStream();
                HexDump.dump(data, 0L, output, 0);
                result = output.toString();
            } else {
                result = "<NO DATA>";
            }
        }
        catch (IOException e) {
            result = e.getMessage();
        }
        results[0] = result;
        return results;
    }

    @Override
    public Iterator getViewableIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public boolean preferArray() {
        return true;
    }

    @Override
    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document: \"").append(this._property.getName()).append("\"");
        buffer.append(" size = ").append(this.getSize());
        return buffer.toString();
    }

    private static final class BigBlockStore {
        private DocumentBlock[] bigBlocks;
        private final POIFSDocumentPath _path;
        private final String _name;
        private final int _size;
        private final POIFSWriterListener _writer;
        private final POIFSBigBlockSize _bigBlockSize;

        BigBlockStore(POIFSBigBlockSize bigBlockSize, DocumentBlock[] blocks) {
            this._bigBlockSize = bigBlockSize;
            this.bigBlocks = (DocumentBlock[])blocks.clone();
            this._path = null;
            this._name = null;
            this._size = -1;
            this._writer = null;
        }

        BigBlockStore(POIFSBigBlockSize bigBlockSize, POIFSDocumentPath path, String name, int size, POIFSWriterListener writer) {
            this._bigBlockSize = bigBlockSize;
            this.bigBlocks = new DocumentBlock[0];
            this._path = path;
            this._name = name;
            this._size = size;
            this._writer = writer;
        }

        boolean isValid() {
            return this.bigBlocks.length > 0 || this._writer != null;
        }

        DocumentBlock[] getBlocks() {
            if (this.isValid() && this._writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this._size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this._size);
                this._writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this._path, this._name, this._size));
                this.bigBlocks = DocumentBlock.convert(this._bigBlockSize, stream.toByteArray(), this._size);
            }
            return this.bigBlocks;
        }

        void writeBlocks(OutputStream stream) throws IOException {
            if (this.isValid()) {
                if (this._writer != null) {
                    DocumentOutputStream dstream = new DocumentOutputStream(stream, this._size);
                    this._writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this._path, this._name, this._size));
                    dstream.writeFiller(this.countBlocks() * this._bigBlockSize.getBigBlockSize(), DocumentBlock.getFillByte());
                } else {
                    for (int k = 0; k < this.bigBlocks.length; ++k) {
                        this.bigBlocks[k].writeBlocks(stream);
                    }
                }
            }
        }

        int countBlocks() {
            if (this.isValid()) {
                if (this._writer == null) {
                    return this.bigBlocks.length;
                }
                return (this._size + this._bigBlockSize.getBigBlockSize() - 1) / this._bigBlockSize.getBigBlockSize();
            }
            return 0;
        }
    }

    private static final class SmallBlockStore {
        private SmallDocumentBlock[] _smallBlocks;
        private final POIFSDocumentPath _path;
        private final String _name;
        private final int _size;
        private final POIFSWriterListener _writer;
        private final POIFSBigBlockSize _bigBlockSize;

        SmallBlockStore(POIFSBigBlockSize bigBlockSize, SmallDocumentBlock[] blocks) {
            this._bigBlockSize = bigBlockSize;
            this._smallBlocks = (SmallDocumentBlock[])blocks.clone();
            this._path = null;
            this._name = null;
            this._size = -1;
            this._writer = null;
        }

        SmallBlockStore(POIFSBigBlockSize bigBlockSize, POIFSDocumentPath path, String name, int size, POIFSWriterListener writer) {
            this._bigBlockSize = bigBlockSize;
            this._smallBlocks = new SmallDocumentBlock[0];
            this._path = path;
            this._name = name;
            this._size = size;
            this._writer = writer;
        }

        boolean isValid() {
            return this._smallBlocks.length > 0 || this._writer != null;
        }

        SmallDocumentBlock[] getBlocks() {
            if (this.isValid() && this._writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this._size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this._size);
                this._writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this._path, this._name, this._size));
                this._smallBlocks = SmallDocumentBlock.convert(this._bigBlockSize, stream.toByteArray(), this._size);
            }
            return this._smallBlocks;
        }
    }
}

