/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.Serializable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTop10;
import org.zkoss.poi.ss.usermodel.Top10Filter;
import org.zkoss.poi.xssf.usermodel.XSSFAutoFilter;

public class XSSFTop10Filter
implements Top10Filter,
Serializable {
    private CTTop10 _cttop10;

    XSSFTop10Filter(CTTop10 cttop10) {
        this._cttop10 = cttop10;
    }

    public XSSFTop10Filter(XSSFAutoFilter.XSSFFilterColumn fc) {
        CTFilterColumn ctfc = fc.getCTFilterColumn();
        if (ctfc.isSetTop10()) {
            ctfc.unsetTop10();
        }
        this._cttop10 = ctfc.addNewTop10();
    }

    @Override
    public boolean isTop() {
        return !this._cttop10.isSetTop() || this._cttop10.getTop();
    }

    @Override
    public boolean isPercent() {
        return this._cttop10.isSetPercent() && this._cttop10.getPercent();
    }

    @Override
    public double getValue() {
        return this._cttop10.getVal();
    }

    @Override
    public double getFilterValue() {
        return this._cttop10.getFilterVal();
    }

    @Override
    public void setProperties(boolean isTop, double value, boolean isPercent, double filterValue) {
        if (isTop) {
            if (this._cttop10.isSetTop()) {
                this._cttop10.unsetTop();
            }
        } else {
            this._cttop10.setTop(false);
        }
        this._cttop10.setVal(value);
        this._cttop10.setFilterVal(filterValue);
        if (isPercent) {
            this._cttop10.setPercent(true);
        } else if (this._cttop10.isSetPercent()) {
            this._cttop10.unsetTop();
        }
    }
}

