/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.zkoss.poi.poifs.filesystem.BATManaged;
import org.zkoss.poi.poifs.property.DirectoryProperty;
import org.zkoss.poi.poifs.property.Property;
import org.zkoss.poi.poifs.property.RootProperty;
import org.zkoss.poi.poifs.storage.HeaderBlock;

public abstract class PropertyTableBase
implements BATManaged {
    private final HeaderBlock _header_block;
    protected final List<Property> _properties;

    public PropertyTableBase(HeaderBlock header_block) {
        this._header_block = header_block;
        this._properties = new ArrayList<Property>();
        this.addProperty(new RootProperty());
    }

    public PropertyTableBase(HeaderBlock header_block, List<Property> properties) throws IOException {
        this._header_block = header_block;
        this._properties = properties;
        this.populatePropertyTree((DirectoryProperty)this._properties.get(0));
    }

    public void addProperty(Property property) {
        this._properties.add(property);
    }

    public void removeProperty(Property property) {
        this._properties.remove(property);
    }

    public RootProperty getRoot() {
        return (RootProperty)this._properties.get(0);
    }

    private void populatePropertyTree(DirectoryProperty root) throws IOException {
        int index = root.getChildIndex();
        if (!Property.isValidIndex(index)) {
            return;
        }
        Stack<Property> children = new Stack<Property>();
        children.push(this._properties.get(index));
        while (!children.empty()) {
            Property property = (Property)children.pop();
            if (property == null) continue;
            root.addChild(property);
            if (property.isDirectory()) {
                this.populatePropertyTree((DirectoryProperty)property);
            }
            if (Property.isValidIndex(index = property.getPreviousChildIndex())) {
                children.push(this._properties.get(index));
            }
            if (!Property.isValidIndex(index = property.getNextChildIndex())) continue;
            children.push(this._properties.get(index));
        }
    }

    public int getStartBlock() {
        return this._header_block.getPropertyStart();
    }

    @Override
    public void setStartBlock(int index) {
        this._header_block.setPropertyStart(index);
    }
}

