/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import java.util.LinkedHashMap;
import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.common.BuiltInStyle;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.hssf.record.common.LPWideString;
import org.zkoss.poi.hssf.record.common.XFProp;
import org.zkoss.poi.hssf.record.cont.ContinuableRecord;
import org.zkoss.poi.hssf.record.cont.ContinuableRecordOutput;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;

public final class StyleExtRecord
extends ContinuableRecord {
    private static final BitField fBuiltIn = BitFieldFactory.getInstance(1);
    private static final BitField fHidden = BitFieldFactory.getInstance(2);
    private static final BitField fCustom = BitFieldFactory.getInstance(4);
    private FtrHeader futureHeader;
    private byte bits;
    private byte iCategory;
    public static final byte CUSTOM = 0;
    public static final byte NEUTRAL = 1;
    public static final byte DATA_MODEL = 2;
    public static final byte TITLE = 3;
    public static final byte THEMED_CELL = 4;
    public static final byte NUMBER_FORMAT = 5;
    private BuiltInStyle builtInData;
    private LPWideString stName;
    private LinkedHashMap<Short, XFProp> xfProps;
    public static final short sid = 2194;

    public StyleExtRecord(int bits, int iCategory, BuiltInStyle builtInData, String stName, XFProp[] xfProps) {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2194);
        this.bits = (byte)bits;
        this.iCategory = (byte)iCategory;
        this.builtInData = builtInData;
        this.stName = new LPWideString(stName);
        this.xfProps = new LinkedHashMap(xfProps.length * 4 / 3);
        for (int j = 0; j < xfProps.length; ++j) {
            XFProp prop = xfProps[j];
            this.xfProps.put((short)prop.getXFPropType(), prop);
        }
    }

    public StyleExtRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.bits = in.readByte();
        this.iCategory = in.readByte();
        this.builtInData = new BuiltInStyle(in);
        this.stName = new LPWideString(in);
        in.readShort();
        int cprops = in.readShort();
        this.xfProps = new LinkedHashMap(cprops * 4 / 3);
        for (int j = 0; j < cprops; ++j) {
            try {
                XFProp prop = new XFProp(in);
                this.xfProps.put((short)prop.getXFPropType(), prop);
                continue;
            }
            catch (RuntimeException e) {
                System.out.println(e);
                throw e;
            }
        }
    }

    @Override
    public short getSid() {
        return 2194;
    }

    public XFProp getProperty(int xfPropType) {
        return this.xfProps.get((short)xfPropType);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[STYLEEXT]\n");
        sb.append(this.futureHeader.toString());
        sb.append("    .bits       = ").append(HexDump.intToHex(this.bits)).append("\n");
        sb.append("       .fBuiltIn            = ").append(this.isBuiltIn()).append("\n");
        sb.append("       .fHidden             = ").append(this.isHidden()).append("\n");
        sb.append("       .fCustom             = ").append(this.isCustom()).append("\n");
        sb.append("    .iCategory  = ").append(HexDump.byteToHex(this.getCategory())).append("\n");
        sb.append("    .builtInData= \n");
        this.builtInData.appendString(sb, "        ");
        sb.append("    .stName                 = \n");
        this.stName.appendString(sb, "        ");
        for (XFProp prop : this.xfProps.values()) {
            sb.append("    .XFProp\n");
            prop.appendString(sb, "    ");
        }
        sb.append("[/STYLEEXT]\n");
        return sb.toString();
    }

    public boolean isBuiltIn() {
        return fBuiltIn.isSet(this.bits);
    }

    public void setBuiltIn(boolean flag) {
        this.bits = fBuiltIn.setByteBoolean(this.bits, flag);
    }

    public boolean isHidden() {
        return fHidden.isSet(this.bits);
    }

    public void setHidden(boolean flag) {
        this.bits = fHidden.setByteBoolean(this.bits, flag);
    }

    public boolean isCustom() {
        return fCustom.isSet(this.bits);
    }

    public void setCustom(boolean flag) {
        this.bits = fCustom.setByteBoolean(this.bits, flag);
    }

    public int getCategory() {
        return this.iCategory & 0xFF;
    }

    public void setCategory(int category) {
        this.iCategory = (byte)category;
    }

    public BuiltInStyle getBuiltInData() {
        return this.builtInData;
    }

    public void setBuiltInData(BuiltInStyle data) {
        this.builtInData = data;
    }

    public String getName() {
        return this.stName.getString();
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    protected int getDataSize() {
        int result = 16;
        result += this.stName.getDataSize();
        for (XFProp prop : this.xfProps.values()) {
            result += prop.getDataSize();
        }
        return result;
    }

    @Override
    protected void serialize(ContinuableRecordOutput out) {
        this.futureHeader.serialize(out);
        out.writeByte(this.bits);
        out.writeByte(this.iCategory);
        this.builtInData.serialize(out);
        this.stName.serialize(out);
        int cprops = this.xfProps.size();
        out.writeShort(0);
        out.writeShort(cprops);
        for (XFProp prop : this.xfProps.values()) {
            prop.serialize(out);
        }
    }
}

