

(function () {
	var IDLE = 0,
		LOADING = 1;


zss.MainBlockCtrl = zk.$extends(zss.CellBlockCtrl, {
	loadstate: IDLE,
	_loadVisibleOnResponse: false,
	replaceWidget: function (newwgt) {
		this.$supers(zss.MainBlockCtrl, 'replaceWidget', [newwgt]); 
		
		var r = newwgt.range;
		newwgt.create_('jump', r.top, r.left, r.bottom, r.right, true);
	},
	
	create_: function (dir, tRow, lCol, bRow, rCol, createFrozenOnly) {
		var sht = this.sheet;
		switch (dir) {
		case 'east':
		case 'west':
			sht.tp.create_(dir, lCol, rCol, 0, sht._wgt.getRowFreeze());
			break;
		case 'north':
		case 'south':
			sht.lp.create_(dir, tRow, bRow, 0, sht._wgt.getColumnFreeze());
			break;
		case 'jump':
			sht.tp.create_(dir, lCol, rCol, 0, sht._wgt.getRowFreeze());
			sht.lp.create_(dir, tRow, bRow, 0, sht._wgt.getColumnFreeze());
			break;
		}
		if (!createFrozenOnly)
			this.$supers(zss.MainBlockCtrl, 'create_', [dir, tRow, lCol, bRow, rCol]); 
		sht.dp._fixSize(this);
	},
	_recheckVisible: function () {
		var self = this,
			sheet = this.sheet;
		clearTimeout(self._timeoutId);
		self._timeoutId = setTimeout(function () {
			self.loadForVisible();
		}, 50);
	},
	
	_createCellsIfCached: function (dir, size, jump, vr0) {
		var sheet = this.sheet,
			wgt = sheet._wgt,
			cr = this.range,
			maxCellSize = wgt.getMaxRenderedCellSize(),
			ar = wgt._cacheCtrl.getSelectedSheet(),
			vr = vr0 || zss.SSheetCtrl._getVisibleRange(sheet); 
		switch (dir) {
		case 'south':
			var tRow = cr.bottom + 1,
				lCol = cr.left,
				rCol = cr.right,
				bRow = tRow + size - 1,
				cache = false;
			bRow = Math.min(bRow, sheet.maxRows - 1);
			if (ar.containsRange(tRow, lCol, bRow, rCol)) {
				this.create_(dir, tRow, lCol, bRow, rCol);
				var size = this.range.size(),
					prune = size > maxCellSize;
				
				if (prune && cr.top + vr.height < vr.top) {
					this.pruneCell('north', vr, jump ? null : vr.top - (cr.top + vr.height));
				}
				cache = true;
			}
			break;
		case 'north':
			var bRow = cr.top - 1,
				lCol = cr.left,
				rCol = cr.right,
				tRow = bRow - size + 1,
				cache = false;
			bRow = bRow >= 0 ? bRow : 0;
			tRow = tRow >= 0 ? tRow : 0;
			if (ar.containsRange(tRow, lCol, bRow, rCol)) {
				this.create_(dir, tRow, lCol, bRow, rCol);
				var size = this.range.size(),
					prune = size > maxCellSize;
				
				if (prune && (cr.bottom - vr.height > vr.bottom)) {
					this.pruneCell('south', vr, jump ? null : cr.bottom - vr.height - vr.bottom);
				}
				cache = true;
			}
			break;
		case 'west':
			var tRow = cr.top,
				bRow = cr.bottom,
				rCol = cr.left - 1,
				lCol = rCol - size + 1,
				cache = false;
			rCol = rCol >= 0 ? rCol : 0;
			lCol = lCol >= 0 ? lCol : 0;
			if (ar.containsRange(tRow, lCol, bRow, rCol)) {
				this.create_(dir, tRow, lCol, bRow, rCol);
				var size = this.range.size(),
					prune = size > maxCellSize;
				
				if (prune && (cr.right - vr.width > vr.right)) {
					this.pruneCell('east', vr, jump ? null : cr.right - vr.width - vr.right);
				}
				cache = true;
			}
			break;
		case 'east':
			var tRow = cr.top,
				bRow = cr.bottom,
				lCol = cr.right + 1,
				rCol = lCol + size - 1,
				cache = false;
			rCol = Math.min(rCol, sheet.maxCols - 1);
			if (ar.containsRange(tRow, lCol, bRow, rCol)) {
				this.create_(dir, tRow, lCol, bRow, rCol);
				var size = this.range.size(),
					prune = size > maxCellSize;
				
				if (prune && (cr.left + vr.width < vr.left)) {
					this.pruneCell('west', vr, jump ? null : (vr.left - (cr.left + vr.width)));
				}
				cache = true;
			}
			break;
		}
		if (cache) {
			this.sheet.dp._fixSize(this);
			this._recheckVisible(); 
			return true; 
		}
		return false;
	},
	
	doScroll: function (vertical) {
		var sheet = this.sheet,
			range = zss.SSheetCtrl._getVisibleRange(sheet),
			alwaysjump = false,
			scrolling = true; 
		
		sheet._wgt._sheetScrolled = true;
		if (vertical) {
			var ctop = this.range.top,
				cbottom = this.range.bottom;
			if (range.top >= ctop && range.top <= cbottom) {
				if(range.bottom < cbottom) {
					
					var wasRendering = sheet.renderingWin;
					sheet.startRenderingMessage();
					if (!wasRendering) {
						sheet.closeRenderingMessage();
					}
					return; 
				}
				var hgh = range.bottom - cbottom + 1;
				
				if (hgh > 0 && !this._createCellsIfCached('south', hgh)) {
					sheet.activeBlock.loadCell(range.bottom, range.left, (alwaysjump ? -1 : 20), null, alwaysjump, scrolling);
				}
			} else if(ctop >= range.top && ctop <= range.bottom) {
				var hgh = ctop - range.top + 1;
				
				if (!this._createCellsIfCached('north', hgh)) {
					sheet.activeBlock.loadCell(range.top,range.left, (alwaysjump ? -1 : 20), null, alwaysjump, scrolling); 
				}
			} else if(range.top > cbottom) {
				
				if (!this._createCellsIfCached('south', range.height, true)) {
					sheet.activeBlock.loadCell(range.bottom, range.left,-1, null, alwaysjump, scrolling); 
				}
			} else if(ctop > range.bottom) {
				
				if (!this._createCellsIfCached('north', range.height, true)) {
					sheet.activeBlock.loadCell(range.top, range.left, -1, null, alwaysjump, scrolling); 
				}
			} else{
				return;
			}
		} else {
			var cleft = this.range.left,
				cright = this.range.right;
			if (range.left >= cleft && range.left <= cright) {
				if (range.bottom < cbottom)
					return; 
				var width = range.right - cright + 1;
				
				if (width > 0 && !this._createCellsIfCached('east', width)) {
					sheet.activeBlock.loadCell(range.top, range.right, (alwaysjump ? -1 : 5), null, alwaysjump, scrolling); 
				}
			} else if (cleft >= range.left && cleft <= range.right) {
				var width = cleft - range.left + 1;
				
				if (!this._createCellsIfCached('west', width)) {
					sheet.activeBlock.loadCell(range.top, range.left, (alwaysjump ? -1 : 5), null, alwaysjump, scrolling); 
				}
			} else if (range.left>cright) {
				
				if (!this._createCellsIfCached('east', range.width, true)) {
					sheet.activeBlock.loadCell(range.top, range.right, -1, null, alwaysjump, scrolling); 
				}
			} else if (cleft > range.right) {
				
				if (!this._createCellsIfCached('west', range.width, true)) {
					sheet.activeBlock.loadCell(range.top, range.left, -1, null, alwaysjump, scrolling); 
				}
			} else {
				return;
			}
		}
	},
	_sendOnCellFetch: function(token, type, direction, fetchLeft, fetchTop, fetchWidth, fetchHeight, vrange) {
		var sheet = this.sheet;
		this.loadstate = zss.MainBlockCtrl.LOADING;
		if (!vrange)
			vrange = zss.SSheetCtrl._getVisibleRange(sheet);

		var wgt = sheet._wgt,
			range = this.range,
			spcmp = this.sheet.sp.comp,
			dp = this.sheet.dp,
			arRect = wgt._cacheCtrl.getSelectedSheet().rect,
			arTopHgh = -1,
			arBtmHgh = -1
			arLeftWidth = -1,
			arRightWidth = -1;

		if ('east' == direction || 'west' == direction) {
			var	topHgh = range.top - arRect.top + 1,
				btmHgh = arRect.bottom - range.bottom + 1;
			if (topHgh > 1)
				arTopHgh = topHgh;
			if (btmHgh > 1)
				arBtmHgh = btmHgh;
		} else if ('north' == direction || 'south' == direction) {
			
			var	ar = sheet._wgt._cacheCtrl.getSelectedSheet(),
				leftWidth = range.left - arRect.left,
				rightWidth = arRect.right - range.right;
			
			if (leftWidth > 0) {
				ar.pruneLeft(leftWidth);
			}
			if (rightWidth > 0) {
				ar.pruneRight(rightWidth);
			}
		}
		
		this.sheet.startRenderingMessage();

		wgt.fire('onZSSCellFetch', 
		 {token: token, sheetId: sheet.serverSheetId, type: type, direction: direction,
		 dpWidth: dp.width, dpHeight: dp.height, viewWidth: spcmp.clientWidth, viewHeight: spcmp.clientHeight,
		 blockLeft: range.left, blockTop: range.top, blockRight: range.right, blockBottom: range.bottom,
		 fetchLeft: fetchLeft, fetchTop: fetchTop, fetchWidth: fetchWidth, fetchHeight: fetchHeight,
		 rangeLeft: vrange.left, rangeTop: vrange.top, rangeRight: vrange.right, rangeBottom: vrange.bottom,
		 arLeft: arRect.left, arTop: arRect.top, arRight: arRect.right, arBottom: arRect.bottom,
		 arFetchTopHeight: arTopHgh, arFetchBtmHeight: arBtmHgh}, {toServer: true}, 25);
	},
	
	_getLastDirection: function () {
		return this.sheet.activeBlock._lastDir;
	},
	
	loadCell: function (row, col, pruneres, callbackfn, alwaysjump, scrolling) {
		
		if (scrolling) {
			this.sheet.startRenderingMessage();
		}
		var cleft = this.range.left,
			ctop = this.range.top,
			cw = this.range.width,
			ch = this.range.height,
			cright = this.range.right,
			cbottom = this.range.bottom;
		
		
		var sheet = this.sheet,
			lastFocus = sheet.getLastFocus();
		if (lastFocus.row == row && lastFocus.column == col) {
			return true;
		}

		if (row >= ctop && row <= cbottom && col >= cleft && col <= cright)
			return true;
		if (this.loadstate != zss.MainBlockCtrl.IDLE)
			return false;
		var token = "",
			range = zss.SSheetCtrl._getVisibleRange(sheet),
			local = this,
			fetchw = range.width, 
			fetchh = range.height, 
			
			rect = sheet._wgt._cacheCtrl.getSelectedSheet().rect;
		if ((row >= ctop && row <= cbottom)) {
			if (col < cleft) {
				var y = ctop,
					h = ch,
					x = rect.left - 1, 
					w = x - col + 1;
				if (alwaysjump || (w > 0 && w > fetchw)) { 
					
					token = zkS.addCallback(function () {
						if (sheet.invalid) return;
						
						var block = sheet.activeBlock ;
						block._lastDir = null;
						block.loadstate = zss.MainBlockCtrl.IDLE;
						if (callbackfn) callbackfn();
						block.loadForVisible();
					});
					this._sendOnCellFetch(token, "jump", "west", col, row, -1, -1, range);
				} else {
					
					if (x - w < 0)
						w = x + 1;
					
					var fn = function () {
						if (sheet.invalid) return;
						var block = sheet.activeBlock,
							lastDir = block._lastDir,
							wgt = sheet._wgt,
							maxCellSize = wgt.getMaxRenderedCellSize(),
							size = block.range.size(),
							prune = size > maxCellSize;
						block._lastDir = "H";
						if (prune) {
							if (lastDir && lastDir == "V"){
								block.pruneCell("south", range, 1);
								block.pruneCell("north", range, 1);
							} else if(pruneres >= 0) {
								block.pruneCell("east", range, pruneres);
							}	
						}
						block.loadstate = zss.MainBlockCtrl.IDLE;
						if(callbackfn) callbackfn();
						block.loadForVisible();
					};
					
					if (w > 0) {
						token = zkS.addCallback(fn);
						this._sendOnCellFetch(token, "neighbor", "west", x, y, w, h, range);
					} else {
						fn();
					}
				}

			} else {
				var y = ctop,
					x = rect.right + 1, 
					w = col-x + 1;
				if (alwaysjump || (w > 0 && w > fetchw)) { 
					
					token = zkS.addCallback(function () {
						if (sheet.invalid) return;
						var block = sheet.activeBlock ;
						block._lastDir = null;
						block.loadstate = zss.MainBlockCtrl.IDLE;
						if (callbackfn) callbackfn();
						block.loadForVisible();
					});
					this._sendOnCellFetch(token, "jump", "east", col, row, -1, -1, range);
				} else {
					
					var h = ch;
					if (x + w > this.sheet.maxCols)
						w = this.sheet.maxCols - x;
					
					var fn = function () {
						if (sheet.invalid) return;
						var block = sheet.activeBlock,
							lastDir = block._lastDir,
							wgt = sheet._wgt,
							maxCellSize = wgt.getMaxRenderedCellSize(),
							size = block.range.size(),
							prune = size > maxCellSize;
						block._lastDir = "H";
						if (prune) {
							if (lastDir && lastDir == "V") {
								block.pruneCell("south", range, 1);
								block.pruneCell("north", range, 1);
							} else if (pruneres >= 0){
								block.pruneCell("west", range, pruneres);
							}	
						}
						block.loadstate = zss.MainBlockCtrl.IDLE;
						if (callbackfn) callbackfn();
						block.loadForVisible();
					};
					
					if (w > 0) {
						token = zkS.addCallback(fn);
						this._sendOnCellFetch(token, "neighbor", "east", x, y, w, h, range);
					} else {
						fn();
					}
				}
			}
		} else if ((col >= cleft && col <=cright)) {
			if (row < ctop) {
				var x = cleft,
					w = cw,
					y = rect.top - 1, 
					h = y - row + 1;
				if (alwaysjump || (h > 0 && h > fetchh)) { 
					token = zkS.addCallback(function () {
						if (sheet.invalid) return;
						var block = sheet.activeBlock ;
						block._lastDir = null;
						block.loadstate = zss.MainBlockCtrl.IDLE;
						if (callbackfn) callbackfn();
						block.loadForVisible();
					});
					this._sendOnCellFetch(token, "jump", "north", col, row, -1, -1, range);
				} else {
					if (y - h < 0)
						h = y + 1;
					
					var fn = function () {
						if (sheet.invalid) return;
						var block = sheet.activeBlock,
							lastDir = block._lastDir,
							wgt = sheet._wgt,
							maxCellSize = wgt.getMaxRenderedCellSize(),
							size = block.range.size(),
							prune = size > maxCellSize;
						local._lastDir = "V";
						if (prune) {
							if (lastDir && lastDir == "H") {
								block.pruneCell("east", range, 1);
								block.pruneCell("west", range, 1);
							} else if (pruneres >= 0) {
								block.pruneCell("south", range, pruneres);
							}	
						}
						sheet.activeBlock.loadstate = zss.MainBlockCtrl.IDLE;
						if (callbackfn) callbackfn();

						sheet.activeBlock.loadForVisible();
					};
					
					if (h > 0) {
						token = zkS.addCallback(fn);
						this._sendOnCellFetch(token, "neighbor", "north", x, y, w, h, range);
					} else {
						fn();
					}
				}
			} else {
				var y = rect.bottom + 1,
					x = cleft,
					w = cw,
					h = row-y +1;
				if (alwaysjump || (h > 0 && h > fetchh)) { 
					
					token = zkS.addCallback(function () {
						if (sheet.invalid) return;
						var block = sheet.activeBlock ;
						block._lastDir = null;
						block.loadstate = zss.MainBlockCtrl.IDLE;
						if (callbackfn) callbackfn();
						block.loadForVisible();
					});
					this._sendOnCellFetch(token, "jump", "south", col, row, -1, -1, range);
				} else {
					if (y + h > this.sheet.maxRows)
						h = this.sheet.maxRows - y;
					
					var fn = function () {
						if (sheet.invalid) return;
						
						var block = sheet.activeBlock,
							lastDir = block._lastDir,
							wgt = sheet._wgt,
							maxCellSize = wgt.getMaxRenderedCellSize(),
							size = block.range.size(),
							prune = size > maxCellSize;
						block._lastDir = "V";
						if (prune) {
							if (lastDir && lastDir == "H") {
								block.pruneCell("east", range, 1);
								block.pruneCell("west", range, 1);
							} else if(pruneres >= 0) {
								block.pruneCell("north", range, pruneres);
							}	
						}
						block.loadstate = zss.MainBlockCtrl.IDLE;
						if (callbackfn) callbackfn();
						block.loadForVisible();
					};
					
					if (h > 0) {
						token = zkS.addCallback(fn);
						this._sendOnCellFetch(token, "neighbor", "south", x, y, w, h, range);
					} else {
						fn();
					}
				}
			}
		} else {
			token = zkS.addCallback(function () {
				if(sheet.invalid) return;
				var block = sheet.activeBlock ;
				block.loadstate = zss.MainBlockCtrl.IDLE;
				if(callbackfn) callbackfn();
				
				block.loadForVisible();
			});

			var direction = "";
			if (row < ctop && col < cleft) {
				
				direction = "westnorth";
			} else if(row < ctop && col > cright) {
				
				direction = "eastnorth";
			} else if(row > cbottom && col < cleft) {
				
				direction = "westsouth";
			} else if(row > cbottom && col > cright) {
				
				direction = "eastsouth";
			} else{
				direction = "eastnorth";
			}
			this._sendOnCellFetch(token, "jump", direction, col, row, -1, -1, range);
		}
		return false;
		
	},
	
	pruneCell: function (type , range, reserve) {
		var sheet = this.sheet;
		if (!sheet.config.prune) return;
		
		if (!range)
			range = zss.SSheetCtrl._getVisibleRange(sheet);
		if (!reserve || reserve < 0)
			reserve = 0;
		
		var sync = false,
			wgt = sheet._wgt,
			pruneCache = wgt.isClientCacheDisabled(),
			ar = wgt._cacheCtrl.getSelectedSheet(),
			rect = ar.rect;
		if (type == "west") {
			var l = range.left - reserve;
			l = sheet.mergeMatrix.getLeftConnectedColumn(l, this.range.top, this.range.bottom);

			if (l <= 0 || l < this.range.left) return;
			var size = l - this.range.left;
			if (size > 0) {
				if (size > this.range.width) {
					size = this.range.width;
				}
				this.removeColumnsFromStart_(size);
				sheet.tp.removeChildFromStart_(size);
				if (pruneCache) {
					var colSize = wgt.getPreloadColumnSize();
					if (colSize <= 0)
						ar.pruneLeft(size);
					else {
						var pruneSize = (l - ar.rect.left + 1) - colSize;
						if (pruneSize > 0)
							ar.pruneLeft(pruneSize);
					}
					sync = true;
				}
			}
		} else if (type == "east") {
			var r = range.right + reserve;
			r = sheet.mergeMatrix.getRightConnectedColumn(r,this.range.top,this.range.bottom);
			
			if(r > this.range.right) return;
			var size = this.range.right - r;
			if (size > 0) {
				if (size > this.range.width) {
					size = this.range.width;
				}
				this.removeColumnsFromEnd_(size);
				sheet.tp.removeChildFromEnd_(size);
				if (pruneCache) {
					var colSize = wgt.getPreloadColumnSize();
					if (colSize <= 0) {
						ar.pruneRight(size);
					} else {
						var pruneSize = (ar.rect.right - r + 1) - colSize;
						if (pruneSize > 0)
							ar.pruneRight(pruneSize);
					}
					sync = true;
				}
			}
		} else if (type == "north") {
			var t = range.top - reserve;
			t = sheet.mergeMatrix.getTopConnectedRow(t, this.range.left, this.range.right);
			
			if(t <= 0 || t < this.range.top) return;
			var size = t - this.range.top;
			if (size > 0) {
				if (size > this.range.height) {
					size = this.range.height;
				}
				this.removeRowsFromStart_(size);
				sheet.lp.removeChildFromStart_(size);
				if (pruneCache) {
					var rowSize = wgt._preloadRowSize;
					if (rowSize <= 0) {
						ar.pruneTop(size);
					} else {
						var pruneSize = (t - ar.rect.top + 1) - rowSize;
						if (pruneSize > 0) {
							ar.pruneTop(pruneSize);
						}
					}
					sync = true;
				}
			}
		} else if (type == "south") {
			var b = range.bottom + reserve;
			b = sheet.mergeMatrix.getBottomConnectedRow(b,this.range.left,this.range.right);
			
			if (b > this.range.bottom) return;
			var size = this.range.bottom - b;
			if (size > 0) {
				if (size > this.range.height) {
					size = this.range.height;
				}
				this.removeRowsFromEnd_(size);
				sheet.lp.removeChildFromEnd_(size);
				if (pruneCache) {
					var rowSize = wgt._preloadRowSize;
					if (rowSize <= 0) {
						ar.pruneBottom(size);
					} else {
						var pruneSize = (ar.rect.bottom - b + 1) - rowSize;
						if (pruneSize > 0) {
							ar.pruneBottom(pruneSize);
						}
					}
					sync = true;
				}
			}
			
		}
		if (sync) {
			
			
			setTimeout(function () {
				sheet.sendSyncblock();
			}, 0);	
		}
		sheet.dp._fixSize(this);
	},
	
	_getEastFetchWidth: function (rCol, arRight) {
		var sheet = this.sheet;
		return Math.min(sheet._wgt.getMaxColumns(), rCol + sheet._wgt.getPreloadColumnSize()) - arRight;
	},
	
	_getSouthFetchHeight: function (bRow, arBtm) {
		var sheet = this.sheet;
		return Math.min(sheet._wgt.getMaxRows(), bRow + sheet._wgt.getPreloadRowSize()) - arBtm;
	},
	
	_getWestFetchWidth: function (lCol, arLeft) {
		var sheet = this.sheet;
		return arLeft - Math.max(0, lCol - sheet._wgt.getPreloadColumnSize());
	},
	
	_getNorthFetchHeight: function (tRow, arTop) {
		var sheet = this.sheet;
		return arTop - Math.max(0, tRow - sheet._wgt.getPreloadRowSize());
	},
	
	_getSouthRow: function (bRow) {
		var sheet = this.sheet;
		return Math.min(sheet._wgt.getMaxRows(), bRow + Math.round(sheet._wgt.getPreloadRowSize()/2));
	},
	
	_getEastCol: function (rCol) {
		var sheet = this.sheet;
		return Math.min(sheet._wgt.getMaxColumns(), rCol + Math.round(sheet._wgt.getPreloadColumnSize()/2));
	},
	
	_getNorthRow: function (tRow) {
		var sheet = this.sheet;
		return Math.max(0, tRow - Math.round(sheet._wgt.getPreloadRowSize()/2));
	},
	
	_getWestCol: function (lCol) {
		var sheet = this.sheet;
		return Math.max(0, lCol - Math.round(sheet._wgt.getPreloadColumnSize()/2));
	},
	
	loadForVisible: function (vrange) {
		
		if (!this._loadForVisible(vrange)) {
			var sheet = this.sheet;
			if (sheet) {
				var wgt = sheet._wgt,
					af = wgt._autoFilter;
				if (af != null && wgt.setAutoFilter) {
					var rng = af.range,
						l = rng.left,
						t = rng.top,
						r = rng.right;
					if (!vrange) vrange = zss.SSheetCtrl._getVisibleRange(sheet);
					
					if ((t <= vrange.bottom && t >= vrange.top) || (l <= vrange.right && r >= vrange.left)) { 
						wgt.setAutoFilter(af);
					}
				}
				
				var tbafs = wgt._tableFilters;
				if (tbafs && wgt.setTableFilters) {
					for (var tbname in tbafs) {
						
						if (!tbafs.hasOwnProperty(tbname)) 
							continue;
						
						var af = tbafs[tbname];
						if (af) { 
							var rng = af.range,
								l = rng.left,
								t = rng.top,
								r = rng.right;
							if (!vrange) vrange = zss.SSheetCtrl._getVisibleRange(sheet);
							
							if ((t <= vrange.bottom && t >= vrange.top) || (l <= vrange.right && r >= vrange.left)) { 
								wgt._prepareAutoFilter(sheet, wgt._tableFilters ? wgt._tableFilters[tbname] : null, af);
							}
						}
					}
				}
			}
		}
	},
	_loadForVisible: function (vrange0) {
		var local = this,
			sheet = this.sheet;
		if (!sheet) {
			
			return false;
		}
		if (this.loadstate != zss.MainBlockCtrl.IDLE) { 
			if (!this._loadVisibleOnResponse) {
				this._loadVisibleOnResponse = true;
				sheet._wgt._onResponseCallback.push(function () {
					local.loadForVisible.apply(local);
					local._loadVisibleOnResponse = false;
				});
			}
			return true;
		}
		var vrange = vrange0 || zss.SSheetCtrl._getVisibleRange(sheet);
		
		
		
		
		
		var tRow = vrange.top,
			lCol = vrange.left,
			rCol = vrange.right,
			bRow = vrange.bottom,
			range = this.range,
			top = range.top,
			left = range.left,
			right = range.right,
			bottom = range.bottom,
			ar = sheet._wgt._cacheCtrl.getSelectedSheet();
		
		
		if (right + 1 <= rCol) {
			var createFromCache = false,
				fRow = sheet._wgt.getRowFreeze(),
				rCol0 = this._getEastCol(rCol);  
			if (ar.containsRange(top, right + 1, bottom, rCol0)) {

				this._createCellsIfCached("east", rCol0 - right, null, vrange); 
				createFromCache = true;
			} else if (ar.rect.right >= right + 1 && ar.rect.right < rCol0 && ar.containsRange(top, right + 1, bottom, ar.rect.right)) {
				

				this._createCellsIfCached("east", ar.rect.right - right, null, vrange); 
				createFromCache = true;
			}
			if (createFromCache) { 
				range = this.range;
				top = range.top;
				left = range.left;
				right = range.right;
				bottom = range.bottom;
			}
		}
		
		
		if (left - 1 >= lCol) {
			var createFromCache = false,
				fRow = sheet._wgt.getRowFreeze(),
				lCol0 = this._getWestCol(lCol);  
			if (ar.containsRange(top, lCol0, bottom, left - 1)) {

				this._createCellsIfCached("west", left - lCol0, null, vrange); 
				createFromCache = true;
			} else if (ar.rect.left > lCol0 && ar.rect.left <= left - 1 && ar.containsRange(top, ar.rect.left, bottom, left - 1)) {
				

				this._createCellsIfCached("west", left - ar.rect.left, null, vrange); 
				createFromCache = true;
			}
			if (createFromCache) { 
				range = this.range;
				top = range.top;
				left = range.left;
				right = range.right;
				bottom = range.bottom;
			}
		}

		
		if (bottom + 1 <= bRow) {
			var createFromCache = false,
				fCol = sheet._wgt.getColumnFreeze(),
				bRow0 = this._getSouthRow(bRow); 
			if (ar.containsRange(bottom + 1, left, bRow0, right)) {

				this._createCellsIfCached("south", bRow0 - bottom, null, vrange); 
				createFromCache = true;
			} else if (ar.rect.bottom >= bottom + 1 && ar.rect.bottom < bRow0 && ar.containsRange(bottom + 1, left, ar.rect.bottom, right)) {
				

				this._createCellsIfCached("south", ar.rect.bottom - bottom, null, vrange); 
				createFromCache = true;
			}
			if (createFromCache) {
				range = this.range;
				top = range.top;
				left = range.left;
				right = range.right;
				bottom = range.bottom;
			}
		}
		
		
		if (tRow < top) {
			var createFromCache = false,
				fCol = sheet._wgt.getColumnFreeze(),
				tRow0 = this._getNorthRow(tRow); 
			if (ar.containsRange(tRow0, left, top - 1, right)) {

				this._createCellsIfCached("north", top - tRow0, null, vrange); 
				createFromCache = true;
			} else if (ar.rect.top > tRow0 && ar.rect.top <= top - 1 && ar.containsRange(ar.rect.top, left, top - 1, right)) {
				

				this._createCellsIfCached("north", top - ar.rect.top, null, vrange); 
				createFromCache = true;
			}
			if (createFromCache) {
				range = this.range;
				top = range.top;
				left = range.left;
				right = range.right;
				bottom = range.bottom;
			}
		}
		
		if (tRow > bottom || bRow < top || lCol > right || rCol < left) {
			
			
			
			var alwaysjump = true,
				scrolling = true;
			this.loadCell(vrange.top, vrange.left, 0, null, alwaysjump, scrolling);
			return true;
		} else if (!(tRow >= top && lCol >= left && bRow <= bottom && rCol <= right)) {

			
			var southFetchHeight = -1,
				eastFetchWidth = -1,
				northFetchHeight = -1,
				westFetchWidth = -1,
				arRight = ar.rect.right,
				arBtm = ar.rect.bottom,
				arLeft = ar.rect.left,
				arTop = ar.rect.top;

			if (arRight < rCol) {
				eastFetchWidth = this._getEastFetchWidth(rCol, arRight);
			} else if (arLeft > lCol) {
				westFetchWidth = this._getWestFetchWidth(lCol, arLeft);
			}
			if (arBtm < bRow) {
				southFetchHeight = this._getSouthFetchHeight(bRow, arBtm);
			} else if (arTop > tRow) {
				northFetchHeight = this._getNorthFetchHeight(tRow, arTop);
			}

			var token = zkS.addCallback(function () {
				
				
				
				
				
				if (local.invalid || !local.range) return; 
				var b = sheet.activeBlock;
				b.loadstate = zss.MainBlockCtrl.IDLE;
				b.loadForVisible();
				sheet.dp._fixSize(local);
			});
			
			
			var fetchWidth = eastFetchWidth > 0 ? eastFetchWidth : westFetchWidth,
				fetchHeight = southFetchHeight > 0  ? southFetchHeight : northFetchHeight;
				




			if (fetchHeight > 0 || fetchWidth > 0) {
				this.loadstate = zss.MainBlockCtrl.LOADING;
				this._sendOnCellFetch(token, "visible", "", -1, -1, fetchWidth, fetchHeight, vrange);
			}
			return true;
		}
		sheet.dp._fixSize(this);

		var deferLoader = sheet.deferLoader;
		if (!deferLoader) {
			deferLoader = sheet.deferLoader = new zss.DeferLoader(sheet);
		}
		deferLoader.asyncRun(); 
		
		sheet.sendSyncblock(true);
		return false;
	},
	
	reloadBlock: function (dir) {
		var local = this,
			sheet = this.sheet,
		
		
			vrange = zss.SSheetCtrl._getVisibleRange(sheet),
			top = this.range.top,
			left = this.range.left,
			right = this.range.right,
			bottom = this.range.bottom; 
		var token = zkS.addCallback(function () {
			if (sheet.invald) return; 
			var block = sheet.activeBlock,
				range = block.range;
			block.loadstate = zss.MainBlockCtrl.IDLE;
			if (dir == "east" || dir == "west") {
				sheet.sp.scrollToVisible(null, dir == "east" ? range.right : range.left);
			} else if (dir == "south" || dir == "north") {
				sheet.sp.scrollToVisible(dir == "south" ? range.bottom: range.top ? range.right: range.left, null);
			}
			block.loadForVisible();
		});
		var col = dir=="east" ? right : left,
			row = dir=="south" ? bottom : top;
		this._sendOnCellFetch(token, "jump", (dir ? dir: "west"), col, row, -1, -1, vrange);
	}
}, {
	IDLE: 0,
	LOADING: 1
});
})();