/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.undo.InsertCellAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;

public class InsertRowHandler
extends AbstractHandler {
    private static final long serialVersionUID = -9104949440019029413L;

    @Override
    protected boolean processAction(UserActionContext ctx) {
        int maxVisibleRows;
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        Range range = Ranges.range(sheet, selection);
        if (this.checkInCornerFreezePanel(range = range.toRowRange())) {
            throw new IllegalOpArgumentException(Labels.getLabel((String)"zss.msg.operation_not_supported_with_freeze_panel"));
        }
        int row = range.getRow();
        int lastRow = range.getLastRow();
        if (lastRow - row + 1 == (maxVisibleRows = ctx.getSpreadsheet().getCurrentMaxVisibleRows())) {
            throw new IllegalOpArgumentException(Labels.getLabel((String)"zss.msg.operation_not_supported_with_all_row"));
        }
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction(new InsertCellAction(Labels.getLabel((String)"zss.undo.insertRow"), sheet, range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn(), Range.InsertShift.DOWN, Range.InsertCopyOrigin.FORMAT_LEFT_ABOVE));
        ctx.clearClipboard();
        return true;
    }

    @Override
    public boolean isEnabled(Book book, Sheet sheet) {
        return book != null && sheet != null && (!sheet.isProtected() || Ranges.range(sheet).getSheetProtection().isInsertRowsAllowed());
    }
}

