/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Color;
import io.keikai.api.model.Sheet;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ActionHelper;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.impl.undo.AggregatedAction;
import io.keikai.ui.impl.undo.FontStyleAction;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import java.util.ArrayList;
import org.zkoss.lang.Strings;
import org.zkoss.util.resource.Labels;

public class FontColorHandler
extends AbstractCellHandler {
    private static final long serialVersionUID = -2858669945093101441L;

    @Override
    protected boolean processAction(UserActionContext ctx) {
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        CellSelectionType type = ctx.getSelectionType();
        Range range = Ranges.range(sheet, selection);
        if (range.isProtected() && !range.getSheetProtection().isFormatCellsAllowed()) {
            this.showProtectMessage();
            return true;
        }
        switch (type) {
            case ROW: {
                range = range.toRowRange();
                break;
            }
            case COLUMN: {
                range = range.toColumnRange();
                break;
            }
            case ALL: {
                range = range.toColumnRange();
            }
        }
        selection = new AreaRef(range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn());
        String color = this.getColor(ctx);
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        Color xcolor = range.getCellStyleHelper().createColorFromHtmlColor(color);
        ArrayList<UndoableAction> actions = new ArrayList<UndoableAction>();
        actions.add(new FontStyleAction("", sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), CellOperationUtil.getFontColorApplier(xcolor)));
        ActionHelper.collectRichTextStyleActions(range, CellOperationUtil.getRichTextFontColorApplier(xcolor), actions);
        AggregatedAction action = new AggregatedAction(Labels.getLabel((String)"zss.undo.fontStyle"), actions.toArray(new UndoableAction[actions.size()]));
        uam.doAction(action);
        return true;
    }

    protected String getColor(UserActionContext ctx) {
        String color = (String)ctx.getData("color");
        if (Strings.isEmpty((String)color)) {
            color = this.getDefaultColor();
        }
        return color;
    }

    protected String getDefaultColor() {
        return "#FFFFFF";
    }
}

