/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.impl.undo.CellStyleAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.lang.Strings;
import org.zkoss.util.resource.Labels;

public class FillColorHandler
extends AbstractCellHandler {
    private static final long serialVersionUID = -8183364171723692198L;

    @Override
    protected boolean processAction(UserActionContext ctx) {
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        CellSelectionType type = ctx.getSelectionType();
        Range range = Ranges.range(sheet, selection);
        if (range.isProtected() && !range.getSheetProtection().isFormatCellsAllowed()) {
            this.showProtectMessage();
            return true;
        }
        switch (type) {
            case ROW: {
                range = range.toRowRange();
                break;
            }
            case COLUMN: {
                range = range.toColumnRange();
                break;
            }
            case ALL: {
                range = range.toColumnRange();
            }
        }
        selection = new AreaRef(range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn());
        String color = this.getColor(ctx);
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction(new CellStyleAction(Labels.getLabel((String)"zss.undo.cellStyle"), sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), CellOperationUtil.getFillColorApplier(range.getCellStyleHelper().createColorFromHtmlColor(color))));
        return true;
    }

    protected String getColor(UserActionContext ctx) {
        String color = (String)ctx.getData("color");
        if (Strings.isEmpty((String)color)) {
            color = this.getDefaultColor();
        }
        return color;
    }

    protected String getDefaultColor() {
        return "#000000";
    }
}

