/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SConditionalStyle;
import io.keikai.model.SDataBar;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SHyperlink;
import io.keikai.model.SIconSet;
import io.keikai.model.SRichText;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.impl.AbstractCellStyleAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.AbstractTableAdv;
import io.keikai.model.impl.ConditionalStyleImpl;
import io.keikai.model.impl.IconSetImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.format.FormatResult;
import io.keikai.model.util.RichTextHelper;
import io.keikai.range.impl.StyleUtil;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.impl.MergeMatrixHelper;
import io.keikai.ui.impl.MergedRect;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;

public class CellFormatHelper
implements Serializable {
    private static final long serialVersionUID = 8480097718738495064L;
    private static final int RESERVE_CELL_MARGIN = 4;
    private SCell _cell;
    private SCellStyle _cellStyle;
    private SSheet _sheet;
    private int _row;
    private int _col;
    private boolean hasRightBorder_set = false;
    private boolean hasRightBorder = false;
    private MergeMatrixHelper _mmHelper;
    private FormatEngine _formatEngine;
    private SConditionalStyle _cdStyle;

    @Deprecated
    public CellFormatHelper(SSheet sheet, int row, int col, MergeMatrixHelper mmhelper) {
        this(sheet, row, col, mmhelper, null);
    }

    public CellFormatHelper(SSheet sheet, int row, int col, MergeMatrixHelper mmhelper, SConditionalStyle cdStyle) {
        this._sheet = sheet;
        this._row = row;
        this._col = col;
        this._cell = sheet.getCell(row, col);
        this._cellStyle = this._cell.getCellStyle();
        this._mmHelper = mmhelper;
        this._formatEngine = EngineFactory.getInstance().createFormatEngine();
        this._cdStyle = cdStyle;
    }

    public String getHtmlStyle(StringBuffer doubleBorder, STable table, SCellStyle tbStyle) {
        String backColor;
        StringBuffer sb = new StringBuffer();
        SCellStyle fillStyle = StyleUtil.getFillStyle((SCellStyle)this._cellStyle, (SCellStyle)tbStyle, (SConditionalStyle)this._cdStyle);
        String string = backColor = fillStyle != null ? fillStyle.getBackColor().getHtmlColor() : null;
        if (backColor != null) {
            sb.append("background-color:").append(backColor).append(";");
        }
        if (fillStyle != null) {
            sb.append(((AbstractCellStyleAdv)fillStyle).getFillPatternHtml());
        }
        HashMap<String, String> mergedBorder = new HashMap<String, String>(4);
        this.processTopBorder(sb, doubleBorder, fillStyle, tbStyle, mergedBorder);
        this.processLeftBorder(sb, doubleBorder, fillStyle, tbStyle, mergedBorder);
        if (!mergedBorder.isEmpty()) {
            this.appendMergedBorder(sb, mergedBorder);
        }
        this.processBottomBorder(sb, doubleBorder, fillStyle, tbStyle);
        this.processRightBorder(sb, doubleBorder, fillStyle, tbStyle);
        return sb.toString();
    }

    private boolean processBottomBorder(StringBuffer sb, StringBuffer db, SCellStyle fillStyle, SCellStyle tbStyle) {
        String bgColor;
        boolean hitBottom = false;
        MergedRect rect = null;
        boolean hitMerge = false;
        rect = this._mmHelper.getMergeRange(this._row, this._col);
        int bottom = this._row;
        if (rect != null) {
            hitMerge = true;
            bottom = rect.getLastRow();
        }
        SCellStyle nextStyle = StyleUtil.getBottomStyle((SCellStyle)this._sheet.getCell(bottom, this._col).getCellStyle(), (SCellStyle)tbStyle, (SConditionalStyle)this._cdStyle);
        SBorder.BorderType bb = null;
        if (nextStyle != null) {
            bb = nextStyle.getBorderBottom();
            String color = nextStyle.getBorderBottomColor().getHtmlColor();
            hitBottom = this.appendBorderStyle(sb, "bottom", bb, color);
        }
        SCellStyle nextFillStyle = null;
        if (!hitBottom) {
            int n = bottom = hitMerge ? rect.getLastRow() + 1 : this._row + 1;
            if (!hitMerge || rect.getColumn() == rect.getLastColumn()) {
                nextFillStyle = nextStyle = this._sheet.getCell(bottom, this._col).getCellStyle();
                SCellStyle nextTbStyle = null;
                ConditionalStyleImpl nextCdStyle = null;
                if (nextStyle.getBorderTop() == SBorder.BorderType.NONE) {
                    nextCdStyle = ((AbstractSheetAdv)this._sheet).getConditionalFormattingStyle(bottom, this._col);
                    STable table0 = ((AbstractSheetAdv)this._sheet).getTableByRowCol(bottom, this._col);
                    nextTbStyle = table0 == null ? null : ((AbstractTableAdv)table0).getCellStyle(bottom, this._col);
                    nextStyle = StyleUtil.getTopStyle((SCellStyle)nextStyle, (SCellStyle)nextTbStyle, (SConditionalStyle)nextCdStyle);
                }
                if (nextStyle != null) {
                    bb = nextStyle.getBorderTop();
                    String color = nextStyle.getBorderTopColor().getHtmlColor();
                    hitBottom = this.appendBorderStyle(sb, "bottom", bb, color);
                }
                if (!hitBottom) {
                    nextFillStyle = StyleUtil.getFillStyle((SCellStyle)nextFillStyle, nextTbStyle, (SConditionalStyle)nextCdStyle);
                }
            }
        }
        if (!hitBottom && nextFillStyle != null) {
            String string = bgColor = nextFillStyle.getFillPattern() == SFill.FillPattern.SOLID ? nextFillStyle.getBackColor().getHtmlColor() : null;
            if (bgColor != null) {
                hitBottom = this.appendBorderStyle(sb, "bottom", SBorder.BorderType.THIN, bgColor);
            } else if (nextFillStyle.getFillPattern() != SFill.FillPattern.NONE) {
                sb.append("border-bottom:none;");
                hitBottom = true;
            }
        }
        if (!hitBottom && fillStyle != null) {
            String string = bgColor = fillStyle.getFillPattern() == SFill.FillPattern.SOLID ? fillStyle.getBackColor().getHtmlColor() : null;
            if (bgColor != null) {
                hitBottom = this.appendBorderStyle(sb, "bottom", SBorder.BorderType.THIN, bgColor);
            } else if (fillStyle.getFillPattern() != SFill.FillPattern.NONE) {
                sb.append("border-bottom:none;");
                hitBottom = true;
            }
        }
        db.append(hitBottom && bb == SBorder.BorderType.DOUBLE ? "b" : "_");
        return hitBottom;
    }

    private boolean processRightBorder(StringBuffer sb, StringBuffer db, SCellStyle fillStyle, SCellStyle tbStyle) {
        String bgColor;
        boolean hitRight = false;
        MergedRect rect = null;
        boolean hitMerge = false;
        rect = this._mmHelper.getMergeRange(this._row, this._col);
        int right = this._col;
        if (rect != null) {
            hitMerge = true;
            right = rect.getLastColumn();
        }
        SBorder.BorderType bb = null;
        SCellStyle nextStyle = StyleUtil.getRightStyle((SCellStyle)this._sheet.getCell(this._row, right).getCellStyle(), (SCellStyle)tbStyle, (SConditionalStyle)this._cdStyle);
        if (nextStyle != null) {
            bb = nextStyle.getBorderRight();
            String color = nextStyle.getBorderRightColor().getHtmlColor();
            hitRight = this.appendBorderStyle(sb, "right", bb, color);
        }
        SCellStyle nextFillStyle = null;
        if (!hitRight) {
            int n = right = hitMerge ? rect.getLastColumn() + 1 : this._col + 1;
            if (!hitMerge || rect.getRow() == rect.getLastRow()) {
                nextFillStyle = nextStyle = this._sheet.getCell(this._row, right).getCellStyle();
                SCellStyle nextTbStyle = null;
                ConditionalStyleImpl nextCdStyle = null;
                if (nextStyle.getBorderLeft() == SBorder.BorderType.NONE) {
                    nextCdStyle = ((AbstractSheetAdv)this._sheet).getConditionalFormattingStyle(this._row, right);
                    STable table0 = ((AbstractSheetAdv)this._sheet).getTableByRowCol(this._row, right);
                    nextTbStyle = table0 == null ? null : ((AbstractTableAdv)table0).getCellStyle(this._row, right);
                    nextStyle = StyleUtil.getLeftStyle((SCellStyle)nextStyle, (SCellStyle)nextTbStyle, (SConditionalStyle)nextCdStyle);
                }
                if (nextStyle != null) {
                    bb = nextStyle.getBorderLeft();
                    String color = nextStyle.getBorderLeftColor().getHtmlColor();
                    hitRight = this.appendBorderStyle(sb, "right", bb, color);
                }
                if (!hitRight) {
                    nextFillStyle = StyleUtil.getFillStyle((SCellStyle)nextFillStyle, nextTbStyle, (SConditionalStyle)nextCdStyle);
                }
            }
        }
        if (!hitRight && nextFillStyle != null) {
            String string = bgColor = nextFillStyle.getFillPattern() == SFill.FillPattern.SOLID ? nextFillStyle.getBackColor().getHtmlColor() : null;
            if (bgColor != null) {
                hitRight = this.appendBorderStyle(sb, "right", SBorder.BorderType.THIN, bgColor);
            } else if (nextFillStyle.getFillPattern() != SFill.FillPattern.NONE) {
                sb.append("border-right:none;");
                hitRight = true;
            }
        }
        if (!hitRight && fillStyle != null) {
            String string = bgColor = fillStyle.getFillPattern() == SFill.FillPattern.SOLID ? fillStyle.getBackColor().getHtmlColor() : null;
            if (bgColor != null) {
                hitRight = this.appendBorderStyle(sb, "right", SBorder.BorderType.THIN, bgColor);
            } else if (fillStyle.getFillPattern() != SFill.FillPattern.NONE) {
                sb.append("border-right:none;");
                hitRight = true;
            }
        }
        db.append(hitRight && bb == SBorder.BorderType.DOUBLE ? "r" : "_");
        return hitRight;
    }

    private boolean appendBorderStyle(StringBuffer sb, String locate, SBorder.BorderType bs, String color) {
        if (bs == SBorder.BorderType.NONE) {
            return false;
        }
        sb.append("border-").append(locate).append(":");
        switch (bs) {
            case DASHED: 
            case DOTTED: {
                sb.append("dashed");
                break;
            }
            case HAIR: {
                sb.append("dotted");
                break;
            }
            case DOUBLE: {
                sb.append("none");
                break;
            }
            default: {
                sb.append("solid");
            }
        }
        sb.append(" 1px");
        if (color != null) {
            sb.append(" ");
            sb.append(color);
        }
        sb.append(";");
        return true;
    }

    public static String getFontCSSStyle(SCell cell, SFont font) {
        SCellStyle.VerticalAlignment verticalAlignment;
        boolean isUnderline;
        String textColor;
        StringBuilder sb = new StringBuilder();
        String fontName = font.getName();
        if (fontName != null) {
            sb.append("font-family:").append(fontName).append(";");
        }
        if ((textColor = font.getColor().getHtmlColor()) != null) {
            sb.append("color:").append(textColor).append(";");
        }
        SFont.Underline fontUnderline = font.getUnderline();
        boolean strikeThrough = font.isStrikeout();
        boolean bl = isUnderline = fontUnderline == SFont.Underline.SINGLE || fontUnderline == SFont.Underline.SINGLE_ACCOUNTING;
        if (strikeThrough || isUnderline) {
            sb.append("text-decoration:");
            if (strikeThrough) {
                sb.append(" line-through");
            }
            if (isUnderline) {
                sb.append(" underline");
            }
            sb.append(";");
        } else {
            sb.append("text-decoration:none;");
        }
        SFont.Boldweight weight = font.getBoldweight();
        boolean italic = font.isItalic();
        sb.append("font-weight:").append(weight).append(";");
        if (italic) {
            sb.append("font-style:").append("italic;");
        }
        int fontSize = font.getHeightPoints();
        if (font.getTypeOffset() != SFont.TypeOffset.NONE) {
            fontSize = (int)(0.7 * (double)fontSize + 0.5);
        }
        sb.append("font-size:").append(fontSize).append("pt;");
        if (font.getTypeOffset() == SFont.TypeOffset.SUPER) {
            sb.append("vertical-align:").append("super;");
        } else if (font.getTypeOffset() == SFont.TypeOffset.SUB) {
            sb.append("vertical-align:").append("sub;");
        }
        SCellStyle cellStyle = cell.getCellStyle();
        if (cellStyle != null && CellFormatHelper.isIE9VerticalAligment(verticalAlignment = cellStyle.getVerticalAlignment()) && (verticalAlignment == null || verticalAlignment == SCellStyle.VerticalAlignment.BOTTOM)) {
            sb.append("position:absolute;bottom:0px;padding-right:4px;box-sizing:border-box;");
        }
        return sb.toString();
    }

    private static boolean isIE9VerticalAligment(SCellStyle.VerticalAlignment verticalAlignment) {
        return Spreadsheet.isIE9() && verticalAlignment != SCellStyle.VerticalAlignment.CENTER;
    }

    public String getInnerHtmlStyle() {
        if (!this._cell.isNull()) {
            StringBuffer sb = new StringBuffer();
            sb.append(CellFormatHelper.getTextCSSStyle(this._cell));
            SCellStyle.VerticalAlignment verticalAlignment = this._cellStyle.getVerticalAlignment();
            if (!CellFormatHelper.isIE9VerticalAligment(verticalAlignment)) {
                sb.append("display: table-cell;");
                switch (verticalAlignment) {
                    case TOP: {
                        sb.append("vertical-align: top;");
                        break;
                    }
                    case CENTER: {
                        sb.append("vertical-align: middle;");
                        break;
                    }
                    default: {
                        sb.append("vertical-align: bottom;");
                    }
                }
            }
            if (this._cdStyle != null) {
                SDataBar dataBar = this._cdStyle.getDataBar();
                SIconSet iconSet = this._cdStyle.getIconSet();
                if (dataBar != null) {
                    Double barPercent = this._cdStyle.getBarPercent();
                    if (barPercent != null) {
                        sb.append("background-repeat:no-repeat;").append("background-position:0px 1px;").append("background-size: ").append(barPercent).append("% calc(100% - 4px);").append("background-image: linear-gradient(to right, ");
                        String htmlColor = dataBar.getColor().getHtmlColor();
                        sb.append(htmlColor).append(", #e5ecf5);");
                    }
                } else if (iconSet != null) {
                    String name;
                    SIconSet.IconSetType type = iconSet.getType();
                    String iconSetName = type != null ? type.name : null;
                    Integer iconSetId = this._cdStyle.getIconSetId();
                    WebApp app = WebApps.getCurrent();
                    if (iconSetId != null && app != null && iconSetName != null && (name = IconSetImpl.getIconSetName((String)iconSetName, (int)iconSetId, (boolean)iconSet.isReverse())) != null) {
                        try {
                            String path = ServletFns.encodeURL((String)("~./zss/img/" + name + ".png"));
                            sb.append("background-repeat:no-repeat;").append("background-position:0px 2px;").append("background-image: url(").append(path).append(");");
                        }
                        catch (ServletException servletException) {
                            // empty catch block
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public String getFontHtmlStyle() {
        if (!this._cell.isNull()) {
            SColor color;
            StringBuffer sb = new StringBuffer();
            SFont font = this._cellStyle.getFont();
            sb.append(CellFormatHelper.getFontCSSStyle(this._cell, font));
            FormatResult ft = this._formatEngine.format(this._cell, new FormatContext(ZssContext.getCurrent().getLocale()));
            boolean isRichText = ft.isRichText();
            if (!isRichText && (color = ft.getColor()) != null) {
                String htmlColor = color.getHtmlColor();
                sb.append("color:").append(htmlColor).append(";");
            }
            return sb.toString();
        }
        return "";
    }

    public static SCellStyle.Alignment getRealAlignment(SCell cell) {
        SCellStyle style = cell.getCellStyle();
        SCell.CellType type = cell.getType();
        SCellStyle.Alignment align = style.getAlignment();
        if (align == SCellStyle.Alignment.GENERAL) {
            boolean deg90;
            boolean vtxt;
            boolean bl = vtxt = style.getRotation() == 255;
            if (vtxt) {
                return SCellStyle.Alignment.CENTER;
            }
            boolean bl2 = deg90 = style.getRotation() == 90;
            if (deg90) {
                return SCellStyle.Alignment.RIGHT;
            }
            String format = style.getDataFormat();
            if (format != null && format.startsWith("@")) {
                type = SCell.CellType.STRING;
            } else if (type == SCell.CellType.FORMULA) {
                type = cell.getFormulaResultType();
            }
            switch (type) {
                case BLANK: {
                    return align;
                }
                case BOOLEAN: {
                    return SCellStyle.Alignment.CENTER;
                }
                case ERROR: {
                    return SCellStyle.Alignment.CENTER;
                }
                case NUMBER: {
                    return SCellStyle.Alignment.RIGHT;
                }
            }
            return SCellStyle.Alignment.LEFT;
        }
        return align;
    }

    public static String getTextCSSStyle(SCell cell) {
        boolean textWrap;
        SCellStyle style = cell.getCellStyle();
        StringBuffer sb = new StringBuffer();
        SCellStyle.Alignment textHAlign = CellFormatHelper.getRealAlignment(cell);
        switch (textHAlign) {
            case RIGHT: {
                sb.append("text-align:").append("right").append(";");
                break;
            }
            case CENTER: 
            case CENTER_SELECTION: {
                sb.append("text-align:").append("center").append(";");
                break;
            }
        }
        int rotate90 = style.getRotation();
        boolean bl = textWrap = style.isWrapText() && rotate90 != 90 && rotate90 != -90;
        if (textWrap) {
            sb.append("white-space:").append("pre-wrap").append(";");
        }
        return sb.toString();
    }

    @Deprecated
    public boolean hasRightBorder() {
        return this.hasRightBorder(null, null);
    }

    public boolean hasRightBorder(STable table, SCellStyle tbStyle) {
        if (this.hasRightBorder_set) {
            return this.hasRightBorder;
        }
        SCellStyle fillStyle = StyleUtil.getFillStyle((SCellStyle)this._cellStyle, (SCellStyle)tbStyle, (SConditionalStyle)this._cdStyle);
        this.hasRightBorder = this.processRightBorder(new StringBuffer(), new StringBuffer(), fillStyle, tbStyle);
        this.hasRightBorder_set = true;
        return this.hasRightBorder;
    }

    public String getCellFormattedText() {
        FormatResult ft = this._formatEngine.format(this._cell, new FormatContext(ZssContext.getCurrent().getLocale()));
        return ft.getText();
    }

    public String getCellEditText() {
        return this._formatEngine.getEditText(this._cell, new FormatContext(ZssContext.getCurrent().getLocale()));
    }

    public static String getRichCellHtmlText(SSheet sheet, int row, int column) {
        SCell cell = sheet.getCell(row, column);
        String text = "";
        if (!cell.isNull()) {
            SCellStyle style = cell.getCellStyle();
            boolean wrap = style.isWrapText();
            boolean vtxt = style.getRotation() == 255;
            FormatResult ft = EngineFactory.getInstance().createFormatEngine().format(cell, new FormatContext(ZssContext.getCurrent().getLocale()));
            if (ft.isRichText()) {
                SRichText rstr = ft.getRichText();
                text = vtxt ? CellFormatHelper.getVRichTextHtml(cell, rstr, wrap) : CellFormatHelper.getRichTextHtml(cell, rstr, wrap);
            } else {
                text = vtxt ? CellFormatHelper.escapeVText(ft.getText(), wrap) : CellFormatHelper.escapeText(ft.getText(), wrap, true);
            }
            SHyperlink hlink = cell.getHyperlink();
            if (hlink != null) {
                text = CellFormatHelper.getHyperlinkHtml(text, hlink, sheet, cell, style, ft, null, null);
            }
        }
        return text;
    }

    public static String getRichTextEditCellHtml(SSheet sheet, int row, int column) {
        SCell cell = sheet.getCell(row, column);
        String text = "";
        if (!cell.isNull()) {
            boolean wrap = cell.getCellStyle().isWrapText();
            FormatResult ft = EngineFactory.getInstance().createFormatEngine().format(cell, new FormatContext(ZssContext.getCurrent().getLocale()));
            if (ft.isRichText()) {
                SRichText rstr = ft.getRichText();
                text = RichTextHelper.getCellRichTextHtml((SCell)cell, (SRichText)rstr, (boolean)wrap);
            } else {
                text = RichTextHelper.getFontTextHtml((String)CellFormatHelper.escapeText(ft.getText(), wrap, true), (SFont)cell.getCellStyle().getFont());
            }
        }
        return text;
    }

    private static String getHyperlinkHtml(String label, SHyperlink link, SSheet sheet, SCell cell, SCellStyle cellStyle, FormatResult ft, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        String addr = CellFormatHelper.escapeText(link.getAddress() == null ? "" : link.getAddress(), false, false);
        if (label == null) {
            label = CellFormatHelper.escapeText(link.getLabel(), false, false);
        }
        if (label == null) {
            label = CellFormatHelper.escapeText(addr, false, false);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a zs.t=\"SHyperlink\" z.t=\"").append(link.getType().getValue()).append("\" href=\"javascript:\" z.href=\"").append(addr).append("\" style=\"").append(CellFormatHelper.getFontHtmlStyle(sheet, cell, cellStyle, ft, tbStyle, cdStyle)).append("\">").append(label == null ? "" : label).append("</a>");
        return sb.toString();
    }

    private static String getRichTextHtml(SCell cell, SRichText text, boolean wrap) {
        return RichTextHelper.getCellRichTextHtml((SCell)cell, (SRichText)text, (boolean)wrap);
    }

    public static String getCellHtmlText(SSheet sheet, int row, int column) {
        SCell cell = sheet.getCell(row, column);
        String text = "";
        if (cell != null) {
            boolean wrap = cell.getCellStyle().isWrapText();
            FormatResult ft = EngineFactory.getInstance().createFormatEngine().format(cell, new FormatContext(ZssContext.getCurrent().getLocale()));
            if (ft.isRichText()) {
                SRichText rstr = ft.getRichText();
                text = rstr.getText();
            } else {
                text = ft.getText();
            }
            text = CellFormatHelper.escapeText(text, wrap, true);
        }
        return text;
    }

    private static String escapeText(String text, boolean wrap, boolean multiline) {
        return RichTextHelper.escapeText((String)text, (boolean)wrap, (boolean)multiline);
    }

    private boolean processTopBorder(StringBuffer sb, StringBuffer db, SCellStyle fillStyle, SCellStyle tbStyle, Map<String, String> mergedBorder) {
        SBorder.BorderType bb;
        SCellStyle nextStyle;
        boolean hitTop = false;
        MergedRect rect = null;
        boolean hitMerge = false;
        rect = this._mmHelper.getMergeRange(this._row, this._col);
        int top = this._row;
        if (rect != null) {
            hitMerge = true;
            top = rect.getRow();
        }
        if ((nextStyle = StyleUtil.getTopStyle((SCellStyle)this._sheet.getCell(top, this._col).getCellStyle(), (SCellStyle)tbStyle, (SConditionalStyle)this._cdStyle)) != null) {
            bb = nextStyle.getBorderTop();
            if (bb == SBorder.BorderType.DOUBLE) {
                String color = nextStyle.getBorderTopColor().getHtmlColor();
                hitTop = this.appendBorderStyle(sb, "top", bb, color);
            } else if (bb != SBorder.BorderType.NONE) {
                int n = top = hitMerge ? rect.getRow() - 1 : this._row - 1;
                if (!hitMerge || this._row == rect.getRow() && this._col == rect.getColumn()) {
                    int right;
                    SCellStyle rightStyle;
                    MergedRect rectT;
                    if (top >= 0 && (rectT = this._mmHelper.getMergeRange(top, this._col)) != null && rectT.getColumn() < rectT.getLastColumn()) {
                        db.append('_');
                        String color = nextStyle.getBorderTopColor().getHtmlColor();
                        mergedBorder.put("top", color);
                        return true;
                    }
                    if (hitMerge && (rightStyle = StyleUtil.getTopStyle((SCellStyle)this._sheet.getCell(this._row, right = this._col + 1).getCellStyle(), (SCellStyle)tbStyle, (SConditionalStyle)this._cdStyle)) != null && rightStyle.getBorderTop() != SBorder.BorderType.NONE) {
                        db.append('_');
                        String color = nextStyle.getBorderTopColor().getHtmlColor();
                        mergedBorder.put("top", color);
                        return true;
                    }
                }
            }
        }
        if (!hitTop) {
            int n = top = hitMerge ? rect.getRow() - 1 : this._row - 1;
            if (top >= 0) {
                nextStyle = this._sheet.getCell(top, this._col).getCellStyle();
                if (nextStyle.getBorderBottom() == SBorder.BorderType.NONE) {
                    STable table0 = ((AbstractSheetAdv)this._sheet).getTableByRowCol(top, this._col);
                    SCellStyle tbStyle0 = table0 == null ? null : ((AbstractTableAdv)table0).getCellStyle(top, this._col);
                    ConditionalStyleImpl cdStyle0 = ((AbstractSheetAdv)this._sheet).getConditionalFormattingStyle(top, this._col);
                    nextStyle = StyleUtil.getBottomStyle((SCellStyle)nextStyle, (SCellStyle)tbStyle0, (SConditionalStyle)cdStyle0);
                }
                if (nextStyle != null && (bb = nextStyle.getBorderBottom()) == SBorder.BorderType.DOUBLE) {
                    String color = nextStyle.getBorderBottomColor().getHtmlColor();
                    hitTop = this.appendBorderStyle(sb, "top", bb, color);
                }
            }
        }
        db.append(hitTop ? "t" : "_");
        return hitTop;
    }

    private boolean processLeftBorder(StringBuffer sb, StringBuffer db, SCellStyle fillStyle, SCellStyle tbStyle, Map<String, String> mergedBorder) {
        String color;
        SBorder.BorderType bb;
        SCellStyle nextStyle;
        boolean hitLeft = false;
        MergedRect rect = null;
        boolean hitMerge = false;
        rect = this._mmHelper.getMergeRange(this._row, this._col);
        int left = this._col;
        if (rect != null) {
            hitMerge = true;
            left = rect.getColumn();
        }
        if ((nextStyle = StyleUtil.getLeftStyle((SCellStyle)this._sheet.getCell(this._row, left).getCellStyle(), (SCellStyle)tbStyle, (SConditionalStyle)this._cdStyle)) != null) {
            bb = nextStyle.getBorderLeft();
            if (bb == SBorder.BorderType.DOUBLE) {
                color = nextStyle.getBorderLeftColor().getHtmlColor();
                hitLeft = this.appendBorderStyle(sb, "left", bb, color);
            } else if (bb != SBorder.BorderType.NONE) {
                MergedRect rectT;
                int n = left = hitMerge ? rect.getColumn() - 1 : this._col - 1;
                if (left >= 0 && (rectT = this._mmHelper.getMergeRange(this._row, left)) != null && rectT.getRow() < rectT.getLastRow()) {
                    db.append('_');
                    String color2 = nextStyle.getBorderLeftColor().getHtmlColor();
                    mergedBorder.put("left", color2);
                    return true;
                }
            }
        }
        if (!hitLeft) {
            int n = left = hitMerge ? rect.getColumn() - 1 : this._col - 1;
            if (left >= 0) {
                nextStyle = this._sheet.getCell(this._row, left).getCellStyle();
                if (nextStyle.getBorderRight() == SBorder.BorderType.NONE) {
                    ConditionalStyleImpl cdStyle0 = ((AbstractSheetAdv)this._sheet).getConditionalFormattingStyle(this._row, left);
                    STable table0 = ((AbstractSheetAdv)this._sheet).getTableByRowCol(this._row, left);
                    SCellStyle tbStyle0 = table0 == null ? null : ((AbstractTableAdv)table0).getCellStyle(this._row, left);
                    nextStyle = StyleUtil.getRightStyle((SCellStyle)nextStyle, (SCellStyle)tbStyle0, (SConditionalStyle)cdStyle0);
                }
                if (nextStyle != null && (bb = nextStyle.getBorderRight()) == SBorder.BorderType.DOUBLE) {
                    color = nextStyle.getBorderRightColor().getHtmlColor();
                    hitLeft = this.appendBorderStyle(sb, "left", bb, color);
                }
            }
        }
        db.append(hitLeft ? "l" : "_");
        return hitLeft;
    }

    private static String escapeVText(String text, boolean wrap) {
        return RichTextHelper.escapeVText((String)text, (boolean)wrap);
    }

    private static String getVRichTextHtml(SCell cell, SRichText rstr, boolean wrap) {
        return RichTextHelper.getCellVRichTextHtml((SCell)cell, (SRichText)rstr, (boolean)wrap);
    }

    private boolean appendMergedBorder(StringBuffer sb, Map<String, String> mergedBorder) {
        String topColor = mergedBorder.get("top");
        String topPx = topColor != null ? "-1px" : "0px";
        String leftColor = mergedBorder.get("left");
        String leftPx = leftColor != null ? "-1px" : "0px";
        sb.append("box-shadow:").append(leftPx).append(" ").append(topPx).append(" ").append(topColor != null ? topColor : leftColor).append(";");
        return true;
    }

    public FormatResult getFormatResult() {
        return this._cell == null ? null : this._formatEngine.format(this._cell, new FormatContext(ZssContext.getCurrent().getLocale()));
    }

    public String getCellFormattedText(FormatResult ft) {
        return ft == null ? "" : ft.getText();
    }

    public static String getFontHtmlStyle(SSheet sheet, SCell cell, SCellStyle cellStyle, FormatResult ft, SCellStyle tbCellStyle, SConditionalStyle cdStyle) {
        if (!cell.isNull()) {
            SColor color;
            StringBuffer sb = new StringBuffer();
            SFont font = StyleUtil.getFontStyle((SBook)sheet.getBook(), (SCellStyle)cellStyle, (SCellStyle)tbCellStyle, (SConditionalStyle)cdStyle);
            sb.append(CellFormatHelper.getFontCSSStyle(cell, font));
            boolean isRichText = ft.isRichText();
            if (!isRichText && (color = ft.getColor()) != null) {
                String htmlColor = color.getHtmlColor();
                sb.append("color:").append(htmlColor).append(";");
            }
            return sb.toString();
        }
        return "";
    }

    public static String getRichCellHtmlText(SSheet sheet, int row, int column, FormatResult ft, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        SCell cell = sheet.getCell(row, column);
        String text = "";
        if (!cell.isNull()) {
            boolean vtxt;
            SCellStyle style = cell.getCellStyle();
            boolean wrap = style.isWrapText();
            boolean bl = vtxt = style.getRotation() == 255;
            if (ft.isRichText()) {
                SRichText rstr = ft.getRichText();
                text = vtxt ? CellFormatHelper.getVRichTextHtml(cell, rstr, wrap) : CellFormatHelper.getRichTextHtml(cell, rstr, wrap);
            } else {
                text = vtxt ? CellFormatHelper.escapeVText(ft.getText(), wrap) : CellFormatHelper.escapeText(ft.getText(), wrap, true);
            }
            SHyperlink hlink = cell.getHyperlink();
            if (hlink != null) {
                text = CellFormatHelper.getHyperlinkHtml(text, hlink, sheet, cell, style, ft, tbStyle, cdStyle);
            }
        }
        return text;
    }

    public static String getCellHtmlText(SSheet sheet, int row, int column, FormatResult ft, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        SCell cell = sheet.getCell(row, column);
        String text = "";
        if (cell != null) {
            boolean wrap = cell.getCellStyle().isWrapText();
            if (ft.isRichText()) {
                SRichText rstr = ft.getRichText();
                text = rstr.getText();
            } else {
                text = ft.getText();
            }
            text = CellFormatHelper.escapeText(text, wrap, true);
        }
        return text;
    }

    public String getRealHtmlStyle(FormatResult ft, SCellStyle tbCellStyle) {
        if (!this._cell.isNull()) {
            StringBuffer sb = new StringBuffer();
            sb.append(CellFormatHelper.getFontHtmlStyle(this._sheet, this._cell, this._cell.getCellStyle(), ft, tbCellStyle, this._cdStyle));
            sb.append(this.getIndentCSSStyle(this._cell));
            sb.append(this.getMergedMaxHeightStyle(this._cell));
            return sb.toString();
        }
        return "";
    }

    private String getIndentCSSStyle(SCell cell) {
        int indention = this._cell.getCellStyle().getIndention();
        boolean wrap = this._cell.getCellStyle().isWrapText();
        if (indention > 0) {
            if (wrap) {
                return "float:right; width: " + ((double)this._sheet.getColumn(this._cell.getColumnIndex()).getWidth() - (double)indention * 8.5 - 4.0) + "px;";
            }
            return "text-indent:" + (double)indention * 8.5 + "px;";
        }
        return "";
    }

    private String getMergedMaxHeightStyle(SCell cell) {
        MergedRect rect = this._mmHelper.getMergeRange(cell.getRowIndex(), cell.getColumnIndex());
        if (rect != null) {
            return "max-height: none;";
        }
        return "";
    }

    public String getAutoFilterBorder() {
        StringBuffer sb = new StringBuffer();
        SAutoFilter filter = this._sheet.getAutoFilter();
        if (filter == null) {
            return "____";
        }
        CellRegion rgn = filter.getRegion();
        int t = rgn.getRow();
        int l = rgn.getColumn();
        int b = rgn.getLastRow();
        int r = rgn.getLastColumn();
        int r0 = this._cell.getRowIndex();
        int c0 = this._cell.getColumnIndex();
        sb.append(r0 == t && l <= c0 && c0 <= r ? "t" : "_");
        sb.append(c0 == l && t <= r0 && r0 <= b ? "l" : "_");
        sb.append(r0 == b && l <= c0 && c0 <= r ? "b" : "_");
        sb.append(c0 == r && t <= r0 && r0 <= b ? "r" : "_");
        return sb.toString();
    }

    public boolean withDataBarBorder() {
        Double barPercent;
        SDataBar dataBar;
        return this._cdStyle != null && (dataBar = this._cdStyle.getDataBar()) != null && (barPercent = this._cdStyle.getBarPercent()) != null && barPercent > 0.0;
    }
}

