/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.model.impl;

import io.keikai.api.SheetAnchor;
import io.keikai.api.model.Book;
import io.keikai.api.model.Chart;
import io.keikai.api.model.Picture;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.ChartImpl;
import io.keikai.api.model.impl.ModelRef;
import io.keikai.api.model.impl.PictureImpl;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.SBook;
import io.keikai.model.SChart;
import io.keikai.model.SPicture;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SheetImpl
implements Sheet,
Serializable {
    private static final long serialVersionUID = -4032733599166150544L;
    private ModelRef<SSheet> _sheetRef;
    private ModelRef<SBook> _bookRef;
    private Book _book;

    public SheetImpl(ModelRef<SBook> book, ModelRef<SSheet> sheet) {
        this._bookRef = book;
        this._sheetRef = sheet;
    }

    public SSheet getNative() {
        return this._sheetRef.get();
    }

    @Override
    public SSheet getInternalSheet() {
        return this._sheetRef.get();
    }

    public ModelRef<SSheet> getRef() {
        return this._sheetRef;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._sheetRef == null ? 0 : this._sheetRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SheetImpl other = (SheetImpl)obj;
        return !(this._sheetRef == null ? other._sheetRef != null : !this._sheetRef.equals(other._sheetRef));
    }

    @Override
    public Book getBook() {
        if (this._book != null) {
            return this._book;
        }
        this._book = new BookImpl(this._bookRef);
        return this._book;
    }

    @Override
    public boolean isProtected() {
        return this.getNative().isProtected();
    }

    @Override
    public boolean isAutoFilterEnabled() {
        return this.getNative().getAutoFilter() != null;
    }

    @Override
    public boolean isDisplayGridlines() {
        return this.getNative().getViewInfo().isDisplayGridlines();
    }

    @Override
    public String getSheetName() {
        return this.getNative().getSheetName();
    }

    @Override
    public boolean isRowHidden(int row) {
        return this.getNative().getRow(row).isHidden();
    }

    @Override
    public boolean isColumnHidden(int column) {
        return this.getNative().getColumn(column).isHidden();
    }

    @Override
    public List<Chart> getCharts() {
        ArrayList<Chart> charts = new ArrayList<Chart>();
        for (SChart chart : this.getNative().getCharts()) {
            charts.add(new ChartImpl(this._sheetRef, new SimpleRef<SChart>(chart)));
        }
        return charts;
    }

    @Override
    public List<Picture> getPictures() {
        ArrayList<Picture> pictures = new ArrayList<Picture>();
        for (SPicture pic : this.getNative().getPictures()) {
            pictures.add(new PictureImpl(this._sheetRef, new SimpleRef<SPicture>(pic)));
        }
        return pictures;
    }

    @Override
    public int getRowFreeze() {
        return this.getNative().getViewInfo().getNumOfRowFreeze();
    }

    @Override
    public int getColumnFreeze() {
        return this.getNative().getViewInfo().getNumOfColumnFreeze();
    }

    @Override
    public boolean isPrintGridlines() {
        return this.getNative().getPrintSetup().isPrintGridlines();
    }

    @Override
    public int getRowHeight(int row) {
        return this.getNative().getRow(row).getHeight();
    }

    @Override
    public int getColumnWidth(int column) {
        return this.getNative().getColumn(column).getWidth();
    }

    @Override
    @Deprecated
    public Object getSync() {
        return this.getNative();
    }

    public static ViewAnchor toViewAnchor(SSheet sheet, SheetAnchor anchor) {
        int i;
        int row = anchor.getRow();
        int column = anchor.getColumn();
        int x1 = anchor.getXOffset();
        int y1 = anchor.getYOffset();
        int lrow = anchor.getLastRow();
        int lcolumn = anchor.getLastColumn();
        int x2 = anchor.getLastXOffset();
        int y2 = anchor.getLastYOffset();
        int w = 0;
        int h = 0;
        if (row == lrow) {
            h = y2 - y1 + 1;
        } else {
            for (i = row; i <= lrow; ++i) {
                if (i == row) {
                    h += sheet.getRow(i).getHeight() - y1;
                    continue;
                }
                if (i == lrow) {
                    h += y2 + 1;
                    continue;
                }
                h += sheet.getRow(i).getHeight();
            }
        }
        if (column == lcolumn) {
            w = x2 - x1 + 1;
        } else {
            for (i = column; i <= lcolumn; ++i) {
                if (i == column) {
                    w += sheet.getColumn(i).getWidth() - x1;
                    continue;
                }
                if (i == lcolumn) {
                    w += x2 + 1;
                    continue;
                }
                w += sheet.getColumn(i).getWidth();
            }
        }
        ViewAnchor av = new ViewAnchor(row, column, x1, y1, w, h);
        return av;
    }

    public static SheetAnchor toSheetAnchor(SSheet sheet, ViewAnchor anchor) {
        int row = anchor.getRowIndex();
        int column = anchor.getColumnIndex();
        int x1 = anchor.getXOffset();
        int y1 = anchor.getYOffset();
        int w = anchor.getWidth();
        int h = anchor.getHeight();
        int row2 = row;
        int column2 = column;
        int x2 = 0;
        int y2 = 0;
        while (w > 0) {
            if (column2 == column) {
                w -= sheet.getColumn(column).getWidth() - x1;
                ++column2;
                continue;
            }
            w -= sheet.getColumn(column).getWidth();
            ++column2;
        }
        x2 = sheet.getColumn(--column2).getWidth() + w;
        while (h > 0) {
            if (row2 == row) {
                h -= sheet.getRow(row2).getHeight() - y1;
                ++row2;
                continue;
            }
            h -= sheet.getRow(row2).getHeight();
            ++row2;
        }
        y2 = sheet.getRow(--row2).getHeight() + h;
        SheetAnchor san = new SheetAnchor(row, column, x1, y1, row2, column2, x2, y2);
        return san;
    }

    @Override
    public int getFirstRow() {
        return this.getNative().getStartRowIndex();
    }

    @Override
    public int getLastRow() {
        return this.getNative().getEndRowIndex();
    }

    @Override
    public int getFirstColumn(int row) {
        return this.getNative().getStartCellIndex(row);
    }

    @Override
    public int getLastColumn(int row) {
        return this.getNative().getEndCellIndex(row);
    }

    @Override
    public boolean isHidden() {
        return this.getNative().getSheetVisible() == SSheet.SheetVisible.HIDDEN;
    }

    @Override
    public boolean isVeryHidden() {
        return this.getNative().getSheetVisible() == SSheet.SheetVisible.VERY_HIDDEN;
    }
}

