/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.model.impl;

import io.keikai.api.UnitUtil;
import io.keikai.api.model.Color;
import io.keikai.api.model.EditableFont;
import io.keikai.api.model.Font;
import io.keikai.api.model.impl.ColorImpl;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.api.model.impl.FontImpl;
import io.keikai.api.model.impl.ModelRef;
import io.keikai.model.SBook;
import io.keikai.model.SFont;
import io.keikai.model.impl.AbstractFontAdv;

public class EditableFontImpl
extends FontImpl
implements EditableFont {
    public EditableFontImpl(ModelRef<SBook> book, ModelRef<SFont> font) {
        super(book, font);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._fontRef == null ? 0 : this._fontRef.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditableFontImpl other = (EditableFontImpl)obj;
        return !(this._fontRef == null ? other._fontRef != null : !this._fontRef.equals(other._fontRef));
    }

    public void copyAttributeFrom(Font src) {
        SFont sfont = ((FontImpl)src).getNative();
        SFont font = this.getNative();
        font.setBoldweight(sfont.getBoldweight());
        font.setColor(sfont.getColor());
        font.setHeightPoints(sfont.getHeightPoints());
        font.setName(sfont.getName());
        font.setItalic(sfont.isItalic());
        font.setStrikeout(sfont.isStrikeout());
        font.setTypeOffset(sfont.getTypeOffset());
        font.setUnderline(sfont.getUnderline());
        ((AbstractFontAdv)font).setOverrideName(((AbstractFontAdv)sfont).isOverrideName());
        ((AbstractFontAdv)font).setOverrideColor(((AbstractFontAdv)sfont).isOverrideColor());
        ((AbstractFontAdv)font).setOverrideBold(((AbstractFontAdv)sfont).isOverrideBold());
        ((AbstractFontAdv)font).setOverrideItalic(((AbstractFontAdv)sfont).isOverrideItalic());
        ((AbstractFontAdv)font).setOverrideStrikeout(((AbstractFontAdv)sfont).isOverrideStrikeout());
        ((AbstractFontAdv)font).setOverrideUnderline(((AbstractFontAdv)sfont).isOverrideUnderline());
        ((AbstractFontAdv)font).setOverrideHeightPoints(((AbstractFontAdv)sfont).isOverrideHeightPoints());
        ((AbstractFontAdv)font).setOverrideTypeOffset(((AbstractFontAdv)sfont).isOverrideTypeOffset());
    }

    @Override
    public void setFontName(String fontName) {
        this.getNative().setName(fontName);
    }

    @Override
    public void setBoldweight(Font.Boldweight boldweight) {
        this.getNative().setBoldweight(EnumUtil.toFontBoldweight(boldweight));
    }

    @Override
    public void setItalic(boolean italic) {
        this.getNative().setItalic(italic);
    }

    @Override
    public void setStrikeout(boolean strikeout) {
        this.getNative().setStrikeout(strikeout);
    }

    @Override
    public void setUnderline(Font.Underline underline) {
        this.getNative().setUnderline(EnumUtil.toFontUnderline(underline));
    }

    @Override
    public void setFontHeight(int twip) {
        this.setFontHeightInPoint(UnitUtil.twipToPoint(twip));
    }

    @Override
    public void setColor(Color color) {
        this.getNative().setColor(((ColorImpl)color).getNative());
    }

    @Override
    public void setFontHeightInPoint(int point) {
        this.getNative().setHeightPoints(point);
    }
}

